/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.campaign.infra.jpa;

import com.chutneytesting.campaign.infra.jpa.CampaignParameterEntity;
import com.chutneytesting.campaign.infra.jpa.CampaignScenarioEntity;
import com.chutneytesting.scenario.infra.raw.TagListMapper;
import com.chutneytesting.server.core.domain.scenario.campaign.Campaign;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderBy;
import jakarta.persistence.Version;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

@Entity(name="CAMPAIGN")
public class CampaignEntity
implements Serializable {
    @Id
    @Column(name="ID")
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(name="TITLE")
    private String title;
    @Column(name="DESCRIPTION")
    private String description;
    @Column(name="ENVIRONMENT")
    private String environment;
    @Column(name="PARALLEL_RUN")
    private Boolean parallelRun;
    @Column(name="RETRY_AUTO")
    private Boolean retryAuto;
    @Column(name="DATASET_ID")
    private String datasetId;
    @Column(name="TAGS")
    private String tags;
    @Column(name="VERSION")
    @Version
    private Integer version;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="campaign")
    @OrderBy(value="rank ASC")
    private List<CampaignScenarioEntity> campaignScenarios;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="campaign")
    private Set<CampaignParameterEntity> parameters;

    public CampaignEntity() {
    }

    public CampaignEntity(String title) {
        this(null, title, "", null, false, false, null, null, null, null, null);
    }

    public CampaignEntity(String title, List<CampaignScenarioEntity> scenarios) {
        this(null, title, "", null, false, false, null, null, null, scenarios, null);
    }

    public CampaignEntity(Long id, String title, String description, String environment, boolean parallelRun, boolean retryAuto, String datasetId, List<String> tags, Integer version, List<CampaignScenarioEntity> campaignScenarios, Set<CampaignParameterEntity> parameters) {
        this.id = id;
        this.title = title;
        this.description = description;
        this.environment = environment;
        this.parallelRun = parallelRun;
        this.retryAuto = retryAuto;
        this.datasetId = datasetId;
        this.tags = TagListMapper.tagsListToString(tags);
        this.version = Optional.ofNullable(version).orElse(1);
        this.fromCampaignScenarios(campaignScenarios);
        this.fromCampaignParameters(parameters);
    }

    public static CampaignEntity fromDomain(Campaign campaign, Integer version) {
        return new CampaignEntity(campaign.id, campaign.title, campaign.description, campaign.executionEnvironment(), campaign.parallelRun, campaign.retryAuto, campaign.externalDatasetId, campaign.tags, version, CampaignScenarioEntity.fromDomain(campaign), CampaignParameterEntity.fromDomain(campaign));
    }

    private void fromCampaignScenarios(List<CampaignScenarioEntity> campaignScenarioEntities) {
        this.initCampaignScenarios();
        if (campaignScenarioEntities != null && !campaignScenarioEntities.isEmpty()) {
            this.campaignScenarios.clear();
            this.campaignScenarios.addAll(campaignScenarioEntities);
            this.attachCampaignScenarios();
        }
    }

    private void fromCampaignParameters(Set<CampaignParameterEntity> campaignParameterEntities) {
        this.initParameters();
        if (campaignParameterEntities != null && !campaignParameterEntities.isEmpty()) {
            this.parameters.clear();
            this.parameters.addAll(campaignParameterEntities);
            this.attachParameters();
        }
    }

    public Campaign toDomain() {
        return new Campaign(this.id, this.title, this.description, this.campaignScenarios.stream().map(CampaignScenarioEntity::scenarioId).toList(), this.parameters.stream().collect(Collectors.toMap(CampaignParameterEntity::parameter, CampaignParameterEntity::value)), this.environment, this.parallelRun.booleanValue(), this.retryAuto.booleanValue(), this.datasetId, TagListMapper.tagsStringToList(this.tags));
    }

    public Long id() {
        return this.id;
    }

    public String title() {
        return this.title;
    }

    public List<CampaignScenarioEntity> campaignScenarios() {
        return this.campaignScenarios;
    }

    public Set<CampaignParameterEntity> parameters() {
        return this.parameters;
    }

    public Integer version() {
        return this.version;
    }

    public void removeScenario(String scenarioId) {
        Optional<CampaignScenarioEntity> campaignScenario = this.campaignScenarios.stream().filter(cs -> cs.scenarioId().equals(scenarioId)).findFirst();
        if (campaignScenario.isPresent()) {
            CampaignScenarioEntity cs2 = campaignScenario.get();
            this.campaignScenarios.remove(cs2.rank());
            for (int i = cs2.rank().intValue(); i < this.campaignScenarios.size(); ++i) {
                this.campaignScenarios.get(i).rank(i);
            }
        }
    }

    private void initCampaignScenarios() {
        if (this.campaignScenarios == null) {
            this.campaignScenarios = new ArrayList<CampaignScenarioEntity>();
        }
    }

    private void attachCampaignScenarios() {
        Optional.ofNullable(this.campaignScenarios).ifPresent(css -> css.forEach(cs -> cs.forCampaign(this)));
    }

    private void initParameters() {
        if (this.parameters == null) {
            this.parameters = new HashSet<CampaignParameterEntity>();
        }
    }

    private void attachParameters() {
        Optional.ofNullable(this.parameters).ifPresent(params -> params.forEach(param -> param.forCampaign(this)));
    }
}

