/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.tools;

import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import org.springframework.core.io.Resource;

public final class IoUtils {
    private IoUtils() {
    }

    public static String toString(Resource resource) {
        String string;
        InputStreamReader isr = new InputStreamReader(resource.getInputStream(), Charsets.UTF_8);
        try {
            string = CharStreams.toString((Readable)isr);
        }
        catch (Throwable throwable) {
            try {
                try {
                    isr.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        isr.close();
        return string;
    }

    public static boolean isHidden(Path path, Path rootPath) {
        boolean isHidden = path.toFile().isHidden() || path.toFile().getName().startsWith(".");
        Path p = path;
        while (!isHidden && p.getParent() != null && !p.getParent().equals(rootPath)) {
            isHidden = p.getParent().toFile().isHidden() || p.getParent().toFile().getName().startsWith(".");
            p = p.getParent();
        }
        return isHidden;
    }

    public static boolean isHidden(Path path) {
        return IoUtils.isHidden(path, path.getRoot());
    }
}

