/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.execution.infra.storage.jpa;

import com.chutneytesting.campaign.infra.jpa.CampaignExecution;
import com.chutneytesting.server.core.domain.execution.history.ExecutionHistory;
import com.chutneytesting.server.core.domain.execution.history.ImmutableExecutionHistory;
import com.chutneytesting.server.core.domain.execution.report.ServerReportStatus;
import com.chutneytesting.server.core.domain.scenario.campaign.CampaignExecutionReport;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Version;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

@Entity(name="SCENARIO_EXECUTIONS")
public class ScenarioExecution {
    @Id
    @Column(name="ID")
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(name="SCENARIO_ID")
    private String scenarioId;
    @ManyToOne
    @JoinColumn(name="CAMPAIGN_EXECUTION_ID")
    private CampaignExecution campaignExecution;
    @Column(name="EXECUTION_TIME")
    private Long executionTime;
    @Column(name="DURATION")
    private Long duration;
    @Column(name="STATUS")
    @Enumerated(value=EnumType.STRING)
    private ServerReportStatus status;
    @Column(name="INFORMATION")
    private String information;
    @Column(name="ERROR")
    private String error;
    @Column(name="SCENARIO_TITLE")
    private String scenarioTitle;
    @Column(name="ENVIRONMENT")
    private String environment;
    @Column(name="USER_ID")
    private String userId;
    @Column(name="DATASET_ID")
    private String datasetId;
    @Column(name="DATASET_VERSION")
    private Integer datasetVersion;
    @Column(name="VERSION")
    @Version
    private Integer version;

    public ScenarioExecution() {
    }

    public ScenarioExecution(Long id, String scenarioId, CampaignExecution campaignExecution, Long executionTime, Long duration, ServerReportStatus status, String information, String error, String scenarioTitle, String environment, String userId, String datasetId, Integer datasetVersion, Integer version) {
        this.id = id;
        this.scenarioId = scenarioId;
        this.campaignExecution = campaignExecution;
        this.executionTime = executionTime;
        this.duration = duration;
        this.status = status;
        this.information = information;
        this.error = error;
        this.scenarioTitle = scenarioTitle;
        this.environment = environment;
        this.userId = userId;
        this.datasetId = datasetId;
        this.datasetVersion = datasetVersion;
        this.version = version;
    }

    public Long id() {
        return this.id;
    }

    public String scenarioId() {
        return this.scenarioId;
    }

    public CampaignExecution campaignExecution() {
        return this.campaignExecution;
    }

    public void forCampaignExecution(CampaignExecution campaignExecution) {
        this.campaignExecution = campaignExecution;
    }

    public void clearCampaignExecution() {
        this.campaignExecution = null;
    }

    public Integer version() {
        return this.version;
    }

    public Long executionTime() {
        return this.executionTime;
    }

    public Long duration() {
        return this.duration;
    }

    public ServerReportStatus status() {
        return this.status;
    }

    public String information() {
        return this.information;
    }

    public String error() {
        return this.error;
    }

    public String scenarioTitle() {
        return this.scenarioTitle;
    }

    public String environment() {
        return this.environment;
    }

    public String userId() {
        return this.userId;
    }

    public String datasetId() {
        return this.datasetId;
    }

    public Integer datasetVersion() {
        return this.datasetVersion;
    }

    public static ScenarioExecution fromDomain(String scenarioId, ExecutionHistory.ExecutionProperties execution) {
        return ScenarioExecution.fromDomain(scenarioId, null, null, execution);
    }

    public static ScenarioExecution fromDomain(String scenarioId, Long id, Integer version, ExecutionHistory.ExecutionProperties execution) {
        return new ScenarioExecution(id, scenarioId, null, execution.time().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli(), execution.duration(), execution.status(), execution.info().map(info -> StringUtils.substring((String)info, (int)0, (int)512)).orElse(null), execution.error().map(error -> StringUtils.substring((String)error, (int)0, (int)512)).orElse(null), execution.testCaseTitle(), execution.environment(), execution.user(), execution.datasetId().orElse(null), execution.datasetVersion().orElse(null), version);
    }

    public ExecutionHistory.ExecutionSummary toDomain() {
        return this.toDomain(null);
    }

    public ExecutionHistory.ExecutionSummary toDomain(CampaignExecutionReport campaignReport) {
        return ImmutableExecutionHistory.ExecutionSummary.builder().executionId(this.id).time(Instant.ofEpochMilli(this.executionTime).atZone(ZoneId.systemDefault()).toLocalDateTime()).duration(this.duration.longValue()).status(this.status).info(Optional.ofNullable(this.information)).error(Optional.ofNullable(this.error)).testCaseTitle(this.scenarioTitle).environment(this.environment).datasetId(Optional.ofNullable(this.datasetId)).datasetVersion(Optional.ofNullable(this.datasetVersion)).user(this.userId).campaignReport(Optional.ofNullable(campaignReport)).build();
    }

    public void updateFromExecution(ExecutionHistory.Execution execution) {
        this.duration = execution.duration();
        this.status = execution.status();
        this.information = execution.info().orElse(null);
        this.error = execution.error().orElse(null);
    }
}

