/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.execution.api.report.surefire;

import com.chutneytesting.execution.api.report.surefire.CampaignReportFolder;
import com.chutneytesting.execution.api.report.surefire.SurefireScenarioExecutionReportBuilder;
import com.chutneytesting.execution.api.report.surefire.Testsuite;
import com.chutneytesting.server.core.domain.scenario.campaign.CampaignExecutionReport;
import com.chutneytesting.server.core.domain.scenario.campaign.ScenarioExecutionReportCampaign;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class SurefireCampaignExecutionReportBuilder {
    private final SurefireScenarioExecutionReportBuilder surefireScenarioExecutionReportBuilder;

    public SurefireCampaignExecutionReportBuilder(SurefireScenarioExecutionReportBuilder surefireScenarioExecutionReportBuilder) {
        this.surefireScenarioExecutionReportBuilder = surefireScenarioExecutionReportBuilder;
    }

    public byte[] createReport(List<CampaignExecutionReport> campaignExecutionReports) {
        List<CampaignReportFolder> campaignReportFolders = campaignExecutionReports.stream().map(this::createReport).collect(Collectors.toList());
        return this.marshall(campaignReportFolders);
    }

    private byte[] marshall(List<CampaignReportFolder> campaignReportFolders) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ZipOutputStream zos = new ZipOutputStream(baos);){
            campaignReportFolders.forEach(campaignReportFolder -> {
                try {
                    zos.putNextEntry(new ZipEntry(campaignReportFolder.name + "/"));
                    campaignReportFolder.scenariosReport.forEach(testsuite -> {
                        try {
                            zos.putNextEntry(new ZipEntry(campaignReportFolder.name + "/" + testsuite.name + ".xml"));
                            zos.write(this.zipEntry((Testsuite)testsuite));
                            zos.closeEntry();
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e.getMessage(), e);
                        }
                    });
                    zos.closeEntry();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e.getMessage(), e);
                }
            });
        }
        catch (IOException | RuntimeException e) {
            throw new RuntimeException("Cannot serialize test suite.", e);
        }
        return baos.toByteArray();
    }

    private byte[] zipEntry(Testsuite testsuite) {
        byte[] byArray;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            XMLStreamWriter writer = XMLOutputFactory.newFactory().createXMLStreamWriter(output);
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Testsuite.class});
            Marshaller m = jc.createMarshaller();
            m.marshal((Object)testsuite, writer);
            byArray = output.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    output.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e.getMessage(), e);
            }
            catch (JAXBException | XMLStreamException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        output.close();
        return byArray;
    }

    private CampaignReportFolder createReport(CampaignExecutionReport campaignExecutionReport) {
        return new CampaignReportFolder(campaignExecutionReport.campaignName, this.testsuite(campaignExecutionReport.scenarioExecutionReports()));
    }

    private Set<Testsuite> testsuite(List<ScenarioExecutionReportCampaign> scenarioExecutionHistory) {
        return scenarioExecutionHistory.stream().map(this.surefireScenarioExecutionReportBuilder::create).collect(Collectors.toSet());
    }
}

