/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.execution.api;

import com.chutneytesting.execution.api.ExecutionSummaryDto;
import com.chutneytesting.server.core.domain.execution.history.ExecutionHistory;
import com.chutneytesting.server.core.domain.execution.report.ServerReportStatus;
import com.chutneytesting.server.core.domain.scenario.campaign.CampaignExecutionReport;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ExecutionSummaryDto", generator="Immutables")
@Immutable
public final class ImmutableExecutionSummaryDto
implements ExecutionSummaryDto {
    private final LocalDateTime time;
    private final long duration;
    private final ServerReportStatus status;
    @Nullable
    private final String info;
    @Nullable
    private final String error;
    private final String testCaseTitle;
    private final String environment;
    @Nullable
    private final String datasetId;
    @Nullable
    private final Integer datasetVersion;
    private final String user;
    @Nullable
    private final CampaignExecutionReport campaignReport;
    private final Long executionId;

    private ImmutableExecutionSummaryDto(LocalDateTime time, long duration, ServerReportStatus status, @Nullable String info, @Nullable String error, String testCaseTitle, String environment, @Nullable String datasetId, @Nullable Integer datasetVersion, String user, @Nullable CampaignExecutionReport campaignReport, Long executionId) {
        this.time = time;
        this.duration = duration;
        this.status = status;
        this.info = info;
        this.error = error;
        this.testCaseTitle = testCaseTitle;
        this.environment = environment;
        this.datasetId = datasetId;
        this.datasetVersion = datasetVersion;
        this.user = user;
        this.campaignReport = campaignReport;
        this.executionId = executionId;
    }

    @JsonProperty(value="time")
    public LocalDateTime time() {
        return this.time;
    }

    @JsonProperty(value="duration")
    public long duration() {
        return this.duration;
    }

    @JsonProperty(value="status")
    public ServerReportStatus status() {
        return this.status;
    }

    @JsonProperty(value="info")
    public Optional<String> info() {
        return Optional.ofNullable(this.info);
    }

    @JsonProperty(value="error")
    public Optional<String> error() {
        return Optional.ofNullable(this.error);
    }

    @JsonProperty(value="testCaseTitle")
    public String testCaseTitle() {
        return this.testCaseTitle;
    }

    @JsonProperty(value="environment")
    public String environment() {
        return this.environment;
    }

    @JsonProperty(value="datasetId")
    public Optional<String> datasetId() {
        return Optional.ofNullable(this.datasetId);
    }

    @JsonProperty(value="datasetVersion")
    public Optional<Integer> datasetVersion() {
        return Optional.ofNullable(this.datasetVersion);
    }

    @JsonProperty(value="user")
    public String user() {
        return this.user;
    }

    @JsonProperty(value="campaignReport")
    public Optional<CampaignExecutionReport> campaignReport() {
        return Optional.ofNullable(this.campaignReport);
    }

    @JsonProperty(value="executionId")
    public Long executionId() {
        return this.executionId;
    }

    public final ImmutableExecutionSummaryDto withTime(LocalDateTime value) {
        if (this.time == value) {
            return this;
        }
        LocalDateTime newValue = Objects.requireNonNull(value, "time");
        return new ImmutableExecutionSummaryDto(newValue, this.duration, this.status, this.info, this.error, this.testCaseTitle, this.environment, this.datasetId, this.datasetVersion, this.user, this.campaignReport, this.executionId);
    }

    public final ImmutableExecutionSummaryDto withDuration(long value) {
        if (this.duration == value) {
            return this;
        }
        return new ImmutableExecutionSummaryDto(this.time, value, this.status, this.info, this.error, this.testCaseTitle, this.environment, this.datasetId, this.datasetVersion, this.user, this.campaignReport, this.executionId);
    }

    public final ImmutableExecutionSummaryDto withStatus(ServerReportStatus value) {
        ServerReportStatus newValue = Objects.requireNonNull(value, "status");
        if (this.status == newValue) {
            return this;
        }
        return new ImmutableExecutionSummaryDto(this.time, this.duration, newValue, this.info, this.error, this.testCaseTitle, this.environment, this.datasetId, this.datasetVersion, this.user, this.campaignReport, this.executionId);
    }

    public final ImmutableExecutionSummaryDto withInfo(String value) {
        String newValue = Objects.requireNonNull(value, "info");
        if (Objects.equals(this.info, newValue)) {
            return this;
        }
        return new ImmutableExecutionSummaryDto(this.time, this.duration, this.status, newValue, this.error, this.testCaseTitle, this.environment, this.datasetId, this.datasetVersion, this.user, this.campaignReport, this.executionId);
    }

    public final ImmutableExecutionSummaryDto withInfo(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.info, value)) {
            return this;
        }
        return new ImmutableExecutionSummaryDto(this.time, this.duration, this.status, value, this.error, this.testCaseTitle, this.environment, this.datasetId, this.datasetVersion, this.user, this.campaignReport, this.executionId);
    }

    public final ImmutableExecutionSummaryDto withError(String value) {
        String newValue = Objects.requireNonNull(value, "error");
        if (Objects.equals(this.error, newValue)) {
            return this;
        }
        return new ImmutableExecutionSummaryDto(this.time, this.duration, this.status, this.info, newValue, this.testCaseTitle, this.environment, this.datasetId, this.datasetVersion, this.user, this.campaignReport, this.executionId);
    }

    public final ImmutableExecutionSummaryDto withError(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.error, value)) {
            return this;
        }
        return new ImmutableExecutionSummaryDto(this.time, this.duration, this.status, this.info, value, this.testCaseTitle, this.environment, this.datasetId, this.datasetVersion, this.user, this.campaignReport, this.executionId);
    }

    public final ImmutableExecutionSummaryDto withTestCaseTitle(String value) {
        String newValue = Objects.requireNonNull(value, "testCaseTitle");
        if (this.testCaseTitle.equals(newValue)) {
            return this;
        }
        return new ImmutableExecutionSummaryDto(this.time, this.duration, this.status, this.info, this.error, newValue, this.environment, this.datasetId, this.datasetVersion, this.user, this.campaignReport, this.executionId);
    }

    public final ImmutableExecutionSummaryDto withEnvironment(String value) {
        String newValue = Objects.requireNonNull(value, "environment");
        if (this.environment.equals(newValue)) {
            return this;
        }
        return new ImmutableExecutionSummaryDto(this.time, this.duration, this.status, this.info, this.error, this.testCaseTitle, newValue, this.datasetId, this.datasetVersion, this.user, this.campaignReport, this.executionId);
    }

    public final ImmutableExecutionSummaryDto withDatasetId(String value) {
        String newValue = Objects.requireNonNull(value, "datasetId");
        if (Objects.equals(this.datasetId, newValue)) {
            return this;
        }
        return new ImmutableExecutionSummaryDto(this.time, this.duration, this.status, this.info, this.error, this.testCaseTitle, this.environment, newValue, this.datasetVersion, this.user, this.campaignReport, this.executionId);
    }

    public final ImmutableExecutionSummaryDto withDatasetId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.datasetId, value)) {
            return this;
        }
        return new ImmutableExecutionSummaryDto(this.time, this.duration, this.status, this.info, this.error, this.testCaseTitle, this.environment, value, this.datasetVersion, this.user, this.campaignReport, this.executionId);
    }

    public final ImmutableExecutionSummaryDto withDatasetVersion(int value) {
        Integer newValue = value;
        if (Objects.equals(this.datasetVersion, newValue)) {
            return this;
        }
        return new ImmutableExecutionSummaryDto(this.time, this.duration, this.status, this.info, this.error, this.testCaseTitle, this.environment, this.datasetId, newValue, this.user, this.campaignReport, this.executionId);
    }

    public final ImmutableExecutionSummaryDto withDatasetVersion(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.datasetVersion, value)) {
            return this;
        }
        return new ImmutableExecutionSummaryDto(this.time, this.duration, this.status, this.info, this.error, this.testCaseTitle, this.environment, this.datasetId, value, this.user, this.campaignReport, this.executionId);
    }

    public final ImmutableExecutionSummaryDto withUser(String value) {
        String newValue = Objects.requireNonNull(value, "user");
        if (this.user.equals(newValue)) {
            return this;
        }
        return new ImmutableExecutionSummaryDto(this.time, this.duration, this.status, this.info, this.error, this.testCaseTitle, this.environment, this.datasetId, this.datasetVersion, newValue, this.campaignReport, this.executionId);
    }

    public final ImmutableExecutionSummaryDto withCampaignReport(CampaignExecutionReport value) {
        CampaignExecutionReport newValue = Objects.requireNonNull(value, "campaignReport");
        if (this.campaignReport == newValue) {
            return this;
        }
        return new ImmutableExecutionSummaryDto(this.time, this.duration, this.status, this.info, this.error, this.testCaseTitle, this.environment, this.datasetId, this.datasetVersion, this.user, newValue, this.executionId);
    }

    public final ImmutableExecutionSummaryDto withCampaignReport(Optional<? extends CampaignExecutionReport> optional) {
        CampaignExecutionReport value = optional.orElse(null);
        if (this.campaignReport == value) {
            return this;
        }
        return new ImmutableExecutionSummaryDto(this.time, this.duration, this.status, this.info, this.error, this.testCaseTitle, this.environment, this.datasetId, this.datasetVersion, this.user, value, this.executionId);
    }

    public final ImmutableExecutionSummaryDto withExecutionId(Long value) {
        Long newValue = Objects.requireNonNull(value, "executionId");
        if (this.executionId.equals(newValue)) {
            return this;
        }
        return new ImmutableExecutionSummaryDto(this.time, this.duration, this.status, this.info, this.error, this.testCaseTitle, this.environment, this.datasetId, this.datasetVersion, this.user, this.campaignReport, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableExecutionSummaryDto && this.equalTo(0, (ImmutableExecutionSummaryDto)another);
    }

    private boolean equalTo(int synthetic, ImmutableExecutionSummaryDto another) {
        return this.time.equals(another.time) && this.duration == another.duration && this.status.equals((Object)another.status) && Objects.equals(this.info, another.info) && Objects.equals(this.error, another.error) && this.testCaseTitle.equals(another.testCaseTitle) && this.environment.equals(another.environment) && Objects.equals(this.datasetId, another.datasetId) && Objects.equals(this.datasetVersion, another.datasetVersion) && this.user.equals(another.user) && Objects.equals(this.campaignReport, another.campaignReport) && this.executionId.equals(another.executionId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.time.hashCode();
        h += (h << 5) + Longs.hashCode((long)this.duration);
        h += (h << 5) + this.status.hashCode();
        h += (h << 5) + Objects.hashCode(this.info);
        h += (h << 5) + Objects.hashCode(this.error);
        h += (h << 5) + this.testCaseTitle.hashCode();
        h += (h << 5) + this.environment.hashCode();
        h += (h << 5) + Objects.hashCode(this.datasetId);
        h += (h << 5) + Objects.hashCode(this.datasetVersion);
        h += (h << 5) + this.user.hashCode();
        h += (h << 5) + Objects.hashCode(this.campaignReport);
        h += (h << 5) + this.executionId.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ExecutionSummaryDto").omitNullValues().add("time", (Object)this.time).add("duration", this.duration).add("status", (Object)this.status).add("info", (Object)this.info).add("error", (Object)this.error).add("testCaseTitle", (Object)this.testCaseTitle).add("environment", (Object)this.environment).add("datasetId", (Object)this.datasetId).add("datasetVersion", (Object)this.datasetVersion).add("user", (Object)this.user).add("campaignReport", (Object)this.campaignReport).add("executionId", (Object)this.executionId).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableExecutionSummaryDto fromJson(Json json) {
        Builder builder = ImmutableExecutionSummaryDto.builder();
        if (json.time != null) {
            builder.time(json.time);
        }
        if (json.durationIsSet) {
            builder.duration(json.duration);
        }
        if (json.status != null) {
            builder.status(json.status);
        }
        if (json.info != null) {
            builder.info(json.info);
        }
        if (json.error != null) {
            builder.error(json.error);
        }
        if (json.testCaseTitle != null) {
            builder.testCaseTitle(json.testCaseTitle);
        }
        if (json.environment != null) {
            builder.environment(json.environment);
        }
        if (json.datasetId != null) {
            builder.datasetId(json.datasetId);
        }
        if (json.datasetVersion != null) {
            builder.datasetVersion(json.datasetVersion);
        }
        if (json.user != null) {
            builder.user(json.user);
        }
        if (json.campaignReport != null) {
            builder.campaignReport(json.campaignReport);
        }
        if (json.executionId != null) {
            builder.executionId(json.executionId);
        }
        return builder.build();
    }

    public static ImmutableExecutionSummaryDto copyOf(ExecutionSummaryDto instance) {
        if (instance instanceof ImmutableExecutionSummaryDto) {
            return (ImmutableExecutionSummaryDto)instance;
        }
        return ImmutableExecutionSummaryDto.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ExecutionSummaryDto", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TIME = 1L;
        private static final long INIT_BIT_DURATION = 2L;
        private static final long INIT_BIT_STATUS = 4L;
        private static final long INIT_BIT_TEST_CASE_TITLE = 8L;
        private static final long INIT_BIT_ENVIRONMENT = 16L;
        private static final long INIT_BIT_USER = 32L;
        private static final long INIT_BIT_EXECUTION_ID = 64L;
        private long initBits = 127L;
        @Nullable
        private LocalDateTime time;
        private long duration;
        @Nullable
        private ServerReportStatus status;
        @Nullable
        private String info;
        @Nullable
        private String error;
        @Nullable
        private String testCaseTitle;
        @Nullable
        private String environment;
        @Nullable
        private String datasetId;
        @Nullable
        private Integer datasetVersion;
        @Nullable
        private String user;
        @Nullable
        private CampaignExecutionReport campaignReport;
        @Nullable
        private Long executionId;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ExecutionSummaryDto instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(ExecutionHistory.ExecutionProperties instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(ExecutionHistory.Attached instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Optional infoOptional;
            Optional campaignReportOptional;
            Optional errorOptional;
            Optional datasetIdOptional;
            Optional datasetVersionOptional;
            ExecutionSummaryDto instance;
            long bits = 0L;
            if (object instanceof ExecutionSummaryDto) {
                instance = (ExecutionSummaryDto)object;
                if ((bits & 1L) == 0L) {
                    this.duration(instance.duration());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.executionId(instance.executionId());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.environment(instance.environment());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    datasetVersionOptional = instance.datasetVersion();
                    if (datasetVersionOptional.isPresent()) {
                        this.datasetVersion(datasetVersionOptional);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    datasetIdOptional = instance.datasetId();
                    if (datasetIdOptional.isPresent()) {
                        this.datasetId(datasetIdOptional);
                    }
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.time(instance.time());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    errorOptional = instance.error();
                    if (errorOptional.isPresent()) {
                        this.error(errorOptional);
                    }
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    this.testCaseTitle(instance.testCaseTitle());
                    bits |= 0x80L;
                }
                if ((bits & 0x100L) == 0L) {
                    this.user(instance.user());
                    bits |= 0x100L;
                }
                if ((bits & 0x200L) == 0L) {
                    campaignReportOptional = instance.campaignReport();
                    if (campaignReportOptional.isPresent()) {
                        this.campaignReport(campaignReportOptional);
                    }
                    bits |= 0x200L;
                }
                if ((bits & 0x400L) == 0L) {
                    this.status(instance.status());
                    bits |= 0x400L;
                }
                if ((bits & 0x800L) == 0L) {
                    infoOptional = instance.info();
                    if (infoOptional.isPresent()) {
                        this.info(infoOptional);
                    }
                    bits |= 0x800L;
                }
            }
            if (object instanceof ExecutionHistory.ExecutionProperties) {
                instance = (ExecutionHistory.ExecutionProperties)object;
                if ((bits & 1L) == 0L) {
                    this.duration(instance.duration());
                    bits |= 1L;
                }
                if ((bits & 4L) == 0L) {
                    this.environment(instance.environment());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    datasetVersionOptional = instance.datasetVersion();
                    if (datasetVersionOptional.isPresent()) {
                        this.datasetVersion(datasetVersionOptional);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    datasetIdOptional = instance.datasetId();
                    if (datasetIdOptional.isPresent()) {
                        this.datasetId(datasetIdOptional);
                    }
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.time(instance.time());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    errorOptional = instance.error();
                    if (errorOptional.isPresent()) {
                        this.error(errorOptional);
                    }
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    this.testCaseTitle(instance.testCaseTitle());
                    bits |= 0x80L;
                }
                if ((bits & 0x100L) == 0L) {
                    this.user(instance.user());
                    bits |= 0x100L;
                }
                if ((bits & 0x200L) == 0L) {
                    campaignReportOptional = instance.campaignReport();
                    if (campaignReportOptional.isPresent()) {
                        this.campaignReport(campaignReportOptional);
                    }
                    bits |= 0x200L;
                }
                if ((bits & 0x400L) == 0L) {
                    this.status(instance.status());
                    bits |= 0x400L;
                }
                if ((bits & 0x800L) == 0L) {
                    infoOptional = instance.info();
                    if (infoOptional.isPresent()) {
                        this.info(infoOptional);
                    }
                    bits |= 0x800L;
                }
            }
            if (object instanceof ExecutionHistory.Attached) {
                instance = (ExecutionHistory.Attached)object;
                if ((bits & 2L) == 0L) {
                    this.executionId(instance.executionId());
                    bits |= 2L;
                }
            }
        }

        @JsonProperty(value="time")
        @CanIgnoreReturnValue
        public final Builder time(LocalDateTime time) {
            this.time = Objects.requireNonNull(time, "time");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="duration")
        @CanIgnoreReturnValue
        public final Builder duration(long duration) {
            this.duration = duration;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="status")
        @CanIgnoreReturnValue
        public final Builder status(ServerReportStatus status) {
            this.status = Objects.requireNonNull(status, "status");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder info(String info) {
            this.info = Objects.requireNonNull(info, "info");
            return this;
        }

        @JsonProperty(value="info")
        @CanIgnoreReturnValue
        public final Builder info(Optional<String> info) {
            this.info = info.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder error(String error) {
            this.error = Objects.requireNonNull(error, "error");
            return this;
        }

        @JsonProperty(value="error")
        @CanIgnoreReturnValue
        public final Builder error(Optional<String> error) {
            this.error = error.orElse(null);
            return this;
        }

        @JsonProperty(value="testCaseTitle")
        @CanIgnoreReturnValue
        public final Builder testCaseTitle(String testCaseTitle) {
            this.testCaseTitle = Objects.requireNonNull(testCaseTitle, "testCaseTitle");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="environment")
        @CanIgnoreReturnValue
        public final Builder environment(String environment) {
            this.environment = Objects.requireNonNull(environment, "environment");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder datasetId(String datasetId) {
            this.datasetId = Objects.requireNonNull(datasetId, "datasetId");
            return this;
        }

        @JsonProperty(value="datasetId")
        @CanIgnoreReturnValue
        public final Builder datasetId(Optional<String> datasetId) {
            this.datasetId = datasetId.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder datasetVersion(int datasetVersion) {
            this.datasetVersion = datasetVersion;
            return this;
        }

        @JsonProperty(value="datasetVersion")
        @CanIgnoreReturnValue
        public final Builder datasetVersion(Optional<Integer> datasetVersion) {
            this.datasetVersion = datasetVersion.orElse(null);
            return this;
        }

        @JsonProperty(value="user")
        @CanIgnoreReturnValue
        public final Builder user(String user) {
            this.user = Objects.requireNonNull(user, "user");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder campaignReport(CampaignExecutionReport campaignReport) {
            this.campaignReport = Objects.requireNonNull(campaignReport, "campaignReport");
            return this;
        }

        @JsonProperty(value="campaignReport")
        @CanIgnoreReturnValue
        public final Builder campaignReport(Optional<? extends CampaignExecutionReport> campaignReport) {
            this.campaignReport = campaignReport.orElse(null);
            return this;
        }

        @JsonProperty(value="executionId")
        @CanIgnoreReturnValue
        public final Builder executionId(Long executionId) {
            this.executionId = Objects.requireNonNull(executionId, "executionId");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public ImmutableExecutionSummaryDto build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableExecutionSummaryDto(this.time, this.duration, this.status, this.info, this.error, this.testCaseTitle, this.environment, this.datasetId, this.datasetVersion, this.user, this.campaignReport, this.executionId);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("time");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("duration");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("status");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("testCaseTitle");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("environment");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("user");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("executionId");
            }
            return "Cannot build ExecutionSummaryDto, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ExecutionSummaryDto", generator="Immutables")
    static final class Json
    implements ExecutionSummaryDto {
        @Nullable
        LocalDateTime time;
        long duration;
        boolean durationIsSet;
        @Nullable
        ServerReportStatus status;
        @Nullable
        Optional<String> info = Optional.empty();
        @Nullable
        Optional<String> error = Optional.empty();
        @Nullable
        String testCaseTitle;
        @Nullable
        String environment;
        @Nullable
        Optional<String> datasetId = Optional.empty();
        @Nullable
        Optional<Integer> datasetVersion = Optional.empty();
        @Nullable
        String user;
        @Nullable
        Optional<CampaignExecutionReport> campaignReport = Optional.empty();
        @Nullable
        Long executionId;

        Json() {
        }

        @JsonProperty(value="time")
        public void setTime(LocalDateTime time) {
            this.time = time;
        }

        @JsonProperty(value="duration")
        public void setDuration(long duration) {
            this.duration = duration;
            this.durationIsSet = true;
        }

        @JsonProperty(value="status")
        public void setStatus(ServerReportStatus status) {
            this.status = status;
        }

        @JsonProperty(value="info")
        public void setInfo(Optional<String> info) {
            this.info = info;
        }

        @JsonProperty(value="error")
        public void setError(Optional<String> error) {
            this.error = error;
        }

        @JsonProperty(value="testCaseTitle")
        public void setTestCaseTitle(String testCaseTitle) {
            this.testCaseTitle = testCaseTitle;
        }

        @JsonProperty(value="environment")
        public void setEnvironment(String environment) {
            this.environment = environment;
        }

        @JsonProperty(value="datasetId")
        public void setDatasetId(Optional<String> datasetId) {
            this.datasetId = datasetId;
        }

        @JsonProperty(value="datasetVersion")
        public void setDatasetVersion(Optional<Integer> datasetVersion) {
            this.datasetVersion = datasetVersion;
        }

        @JsonProperty(value="user")
        public void setUser(String user) {
            this.user = user;
        }

        @JsonProperty(value="campaignReport")
        public void setCampaignReport(Optional<CampaignExecutionReport> campaignReport) {
            this.campaignReport = campaignReport;
        }

        @JsonProperty(value="executionId")
        public void setExecutionId(Long executionId) {
            this.executionId = executionId;
        }

        public LocalDateTime time() {
            throw new UnsupportedOperationException();
        }

        public long duration() {
            throw new UnsupportedOperationException();
        }

        public ServerReportStatus status() {
            throw new UnsupportedOperationException();
        }

        public Optional<String> info() {
            throw new UnsupportedOperationException();
        }

        public Optional<String> error() {
            throw new UnsupportedOperationException();
        }

        public String testCaseTitle() {
            throw new UnsupportedOperationException();
        }

        public String environment() {
            throw new UnsupportedOperationException();
        }

        public Optional<String> datasetId() {
            throw new UnsupportedOperationException();
        }

        public Optional<Integer> datasetVersion() {
            throw new UnsupportedOperationException();
        }

        public String user() {
            throw new UnsupportedOperationException();
        }

        public Optional<CampaignExecutionReport> campaignReport() {
            throw new UnsupportedOperationException();
        }

        public Long executionId() {
            throw new UnsupportedOperationException();
        }
    }
}

