/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.campaign.infra;

import com.chutneytesting.campaign.domain.CampaignNotFoundException;
import com.chutneytesting.campaign.domain.CampaignRepository;
import com.chutneytesting.campaign.infra.CampaignExecutionDBRepository;
import com.chutneytesting.campaign.infra.CampaignJpaRepository;
import com.chutneytesting.campaign.infra.CampaignScenarioJpaRepository;
import com.chutneytesting.campaign.infra.jpa.CampaignEntity;
import com.chutneytesting.campaign.infra.jpa.CampaignScenario;
import com.chutneytesting.server.core.domain.scenario.campaign.Campaign;
import com.chutneytesting.server.core.domain.scenario.campaign.CampaignExecutionReport;
import com.google.common.base.Strings;
import jakarta.persistence.criteria.Expression;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.StreamSupport;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class DatabaseCampaignRepository
implements CampaignRepository {
    private final CampaignJpaRepository campaignJpaRepository;
    private final CampaignScenarioJpaRepository campaignScenarioJpaRepository;
    private final CampaignExecutionDBRepository campaignExecutionRepository;

    public DatabaseCampaignRepository(CampaignJpaRepository campaignJpaRepository, CampaignScenarioJpaRepository campaignScenarioJpaRepository, CampaignExecutionDBRepository campaignExecutionRepository) {
        this.campaignJpaRepository = campaignJpaRepository;
        this.campaignScenarioJpaRepository = campaignScenarioJpaRepository;
        this.campaignExecutionRepository = campaignExecutionRepository;
    }

    @Override
    public Campaign createOrUpdate(Campaign campaign) {
        CampaignEntity campaignJpa = (CampaignEntity)this.campaignJpaRepository.save(CampaignEntity.fromDomain(campaign, this.lastCampaignVersion(campaign.id)));
        return campaignJpa.toDomain();
    }

    private Integer lastCampaignVersion(Long id) {
        return Optional.ofNullable(id).flatMap(arg_0 -> ((CampaignJpaRepository)this.campaignJpaRepository).findById(arg_0)).map(CampaignEntity::version).orElse(null);
    }

    @Override
    public void saveReport(Long campaignId, CampaignExecutionReport report) {
        this.campaignExecutionRepository.saveCampaignReport(campaignId, report);
    }

    @Override
    public boolean removeById(Long id) {
        if (this.campaignJpaRepository.existsById(id)) {
            this.campaignExecutionRepository.clearAllExecutionHistory(id);
            this.campaignJpaRepository.deleteById(id);
            return true;
        }
        return false;
    }

    @Override
    @Transactional(readOnly=true)
    public Campaign findById(Long campaignId) throws CampaignNotFoundException {
        return this.campaignJpaRepository.findById(campaignId).map(CampaignEntity::toDomain).orElseThrow(() -> new CampaignNotFoundException(campaignId));
    }

    @Override
    @Transactional(readOnly=true)
    public List<Campaign> findByName(String campaignName) {
        return this.campaignJpaRepository.findAll((Specification & Serializable)(root, query, criteriaBuilder) -> criteriaBuilder.like(criteriaBuilder.lower((Expression)root.get("title")), campaignName.toLowerCase())).stream().map(CampaignEntity::toDomain).toList();
    }

    @Override
    @Transactional(readOnly=true)
    public List<CampaignExecutionReport> findLastExecutions(Long numberOfExecution) {
        return this.campaignExecutionRepository.findLastExecutions(numberOfExecution);
    }

    @Override
    @Transactional(readOnly=true)
    public List<String> findScenariosIds(Long campaignId) {
        return this.campaignJpaRepository.findById(campaignId).map(c -> c.campaignScenarios().stream().map(CampaignScenario::scenarioId).toList()).orElseThrow(() -> new CampaignNotFoundException(campaignId));
    }

    @Override
    public Long newCampaignExecution(Long campaignId) {
        return this.campaignExecutionRepository.generateCampaignExecutionId(campaignId);
    }

    @Override
    @Transactional(readOnly=true)
    public List<Campaign> findAll() {
        return StreamSupport.stream(this.campaignJpaRepository.findAll().spliterator(), false).map(CampaignEntity::toDomain).toList();
    }

    @Override
    @Transactional(readOnly=true)
    public List<CampaignExecutionReport> findExecutionsById(Long campaignId) {
        return this.campaignExecutionRepository.findExecutionHistory(campaignId);
    }

    @Override
    @Transactional(readOnly=true)
    public List<Campaign> findCampaignsByScenarioId(String scenarioId) {
        if (Strings.isNullOrEmpty((String)scenarioId)) {
            return Collections.emptyList();
        }
        return this.campaignScenarioJpaRepository.findAllByScenarioId(scenarioId).stream().map(CampaignScenario::campaign).map(CampaignEntity::toDomain).toList();
    }

    @Override
    @Transactional(readOnly=true)
    public CampaignExecutionReport findByExecutionId(Long campaignExecutionId) {
        return this.campaignExecutionRepository.getCampaignExecutionReportsById(campaignExecutionId);
    }
}

