/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.campaign.infra;

import com.chutneytesting.campaign.domain.CampaignExecutionRepository;
import com.chutneytesting.campaign.domain.CampaignNotFoundException;
import com.chutneytesting.campaign.infra.CampaignExecutionJpaRepository;
import com.chutneytesting.campaign.infra.CampaignJpaRepository;
import com.chutneytesting.campaign.infra.jpa.CampaignEntity;
import com.chutneytesting.campaign.infra.jpa.CampaignExecution;
import com.chutneytesting.execution.domain.campaign.CampaignExecutionNotFoundException;
import com.chutneytesting.execution.infra.storage.DatabaseExecutionJpaRepository;
import com.chutneytesting.execution.infra.storage.jpa.ScenarioExecution;
import com.chutneytesting.server.core.domain.scenario.TestCaseMetadata;
import com.chutneytesting.server.core.domain.scenario.TestCaseRepository;
import com.chutneytesting.server.core.domain.scenario.campaign.CampaignExecutionReport;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class CampaignExecutionDBRepository
implements CampaignExecutionRepository {
    private final CampaignExecutionJpaRepository campaignExecutionJpaRepository;
    private final CampaignJpaRepository campaignJpaRepository;
    private final DatabaseExecutionJpaRepository scenarioExecutionJpaRepository;
    private final TestCaseRepository testCaseRepository;
    private final Map<Long, CampaignExecutionReport> currentCampaignExecutions = new ConcurrentHashMap<Long, CampaignExecutionReport>();

    public CampaignExecutionDBRepository(CampaignExecutionJpaRepository campaignExecutionJpaRepository, CampaignJpaRepository campaignJpaRepository, DatabaseExecutionJpaRepository scenarioExecutionJpaRepository, TestCaseRepository testCaseRepository) {
        this.campaignExecutionJpaRepository = campaignExecutionJpaRepository;
        this.campaignJpaRepository = campaignJpaRepository;
        this.scenarioExecutionJpaRepository = scenarioExecutionJpaRepository;
        this.testCaseRepository = testCaseRepository;
    }

    @Transactional(readOnly=true)
    public List<CampaignExecutionReport> findExecutionHistory(Long campaignId) {
        CampaignEntity campaign = (CampaignEntity)this.campaignJpaRepository.findById(campaignId).orElseThrow(() -> new CampaignNotFoundException(campaignId));
        return this.campaignExecutionJpaRepository.findFirst20ByCampaignIdOrderByIdDesc(campaignId).stream().map(ce -> this.toDomain(campaign, (CampaignExecution)ce, false)).filter(Objects::nonNull).collect(Collectors.toCollection(ArrayList::new));
    }

    public void saveCampaignReport(Long campaignId, CampaignExecutionReport report) {
        CampaignExecution execution = (CampaignExecution)this.campaignExecutionJpaRepository.findById(report.executionId).orElseThrow(() -> new CampaignExecutionNotFoundException(report.executionId));
        Iterable scenarioExecutions = this.scenarioExecutionJpaRepository.findAllById(report.scenarioExecutionReports().stream().map(serc -> serc.execution.executionId()).toList());
        execution.updateFromDomain(report, scenarioExecutions);
        this.campaignExecutionJpaRepository.save(execution);
    }

    @Transactional(readOnly=true)
    public List<CampaignExecutionReport> findLastExecutions(Long numberOfExecution) {
        return this.campaignExecutionJpaRepository.findAll(null, (Pageable)PageRequest.of((int)0, (int)numberOfExecution.intValue(), (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"id"}))).stream().map(ce -> this.toDomain((CampaignExecution)ce, false)).filter(Objects::nonNull).toList();
    }

    @Transactional(readOnly=true)
    public CampaignExecutionReport getCampaignExecutionReportsById(Long campaignExecId) {
        return this.campaignExecutionJpaRepository.findById(campaignExecId).map(ce -> this.toDomain((CampaignExecution)ce, true)).orElseThrow(() -> new CampaignExecutionNotFoundException(campaignExecId));
    }

    private CampaignExecutionReport toDomain(CampaignExecution campaignExecution, boolean withRunning) {
        return this.toDomain((CampaignEntity)this.campaignJpaRepository.findById(campaignExecution.campaignId()).get(), campaignExecution, withRunning);
    }

    private CampaignExecutionReport toDomain(CampaignEntity campaign, CampaignExecution campaignExecution, boolean withRunning) {
        if (!withRunning && this.isCampaignExecutionRunning(campaignExecution)) {
            return null;
        }
        return campaignExecution.toDomain(campaign, this.isCampaignExecutionRunning(campaignExecution), this::title);
    }

    public void clearAllExecutionHistory(Long campaignId) {
        List<CampaignExecution> campaignExecutions = this.campaignExecutionJpaRepository.findAllByCampaignId(campaignId);
        List scenarioExecutions = campaignExecutions.stream().flatMap(ce -> ce.scenarioExecutions().stream()).toList();
        scenarioExecutions.forEach(ScenarioExecution::clearCampaignExecution);
        this.scenarioExecutionJpaRepository.saveAll(scenarioExecutions);
        this.campaignExecutionJpaRepository.deleteAll(campaignExecutions);
    }

    public Long generateCampaignExecutionId(Long campaignId) {
        CampaignExecution newExecution = new CampaignExecution(campaignId);
        this.campaignExecutionJpaRepository.save(newExecution);
        return newExecution.id();
    }

    private String title(String scenarioId) {
        return this.testCaseRepository.findMetadataById(scenarioId).map(TestCaseMetadata::title).orElse("");
    }

    private boolean isCampaignExecutionRunning(CampaignExecution campaignExecution) {
        return this.currentExecution(campaignExecution.campaignId()).map(cer -> cer.executionId.equals(campaignExecution.id())).orElse(false);
    }

    @Override
    public Optional<CampaignExecutionReport> currentExecution(Long campaignId) {
        return Optional.ofNullable(campaignId).map(id -> this.currentCampaignExecutions.get(campaignId));
    }

    @Override
    public List<CampaignExecutionReport> currentExecutions() {
        return new ArrayList<CampaignExecutionReport>(this.currentCampaignExecutions.values());
    }

    @Override
    public void startExecution(Long campaignId, CampaignExecutionReport campaignExecutionReport) {
        this.currentCampaignExecutions.put(campaignId, campaignExecutionReport);
    }

    @Override
    public void stopExecution(Long campaignId) {
        this.currentCampaignExecutions.remove(campaignId);
    }
}

