/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.campaign.api;

import com.chutneytesting.campaign.api.dto.CampaignDto;
import com.chutneytesting.campaign.api.dto.CampaignExecutionReportDto;
import com.chutneytesting.campaign.api.dto.CampaignExecutionReportMapper;
import com.chutneytesting.campaign.api.dto.CampaignMapper;
import com.chutneytesting.campaign.domain.CampaignRepository;
import com.chutneytesting.campaign.domain.CampaignService;
import com.chutneytesting.execution.domain.campaign.CampaignExecutionEngine;
import com.chutneytesting.scenario.api.raw.dto.TestCaseIndexDto;
import com.chutneytesting.scenario.infra.TestCaseRepositoryAggregator;
import com.chutneytesting.server.core.domain.scenario.ScenarioNotFoundException;
import com.chutneytesting.server.core.domain.scenario.campaign.Campaign;
import com.chutneytesting.server.core.domain.scenario.campaign.CampaignExecutionReport;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/ui/campaign/v1"})
@CrossOrigin(origins={"*"})
public class CampaignController {
    private final TestCaseRepositoryAggregator repositoryAggregator;
    private final CampaignRepository campaignRepository;
    private final CampaignExecutionEngine campaignExecutionEngine;
    private final CampaignService campaignService;

    public CampaignController(TestCaseRepositoryAggregator repositoryAggregator, CampaignRepository campaignRepository, CampaignExecutionEngine campaignExecutionEngine, CampaignService campaignService) {
        this.repositoryAggregator = repositoryAggregator;
        this.campaignRepository = campaignRepository;
        this.campaignExecutionEngine = campaignExecutionEngine;
        this.campaignService = campaignService;
    }

    @PreAuthorize(value="hasAuthority('CAMPAIGN_WRITE')")
    @PostMapping(path={""}, consumes={"application/json"}, produces={"application/json"})
    public CampaignDto saveCampaign(@RequestBody CampaignDto campaign) {
        return CampaignMapper.toDtoWithoutReport(this.campaignRepository.createOrUpdate(CampaignMapper.fromDto(campaign)));
    }

    @PreAuthorize(value="hasAuthority('CAMPAIGN_WRITE')")
    @PutMapping(path={""}, consumes={"application/json"}, produces={"application/json"})
    public CampaignDto updateCampaign(@RequestBody CampaignDto campaign) {
        return CampaignMapper.toDtoWithoutReport(this.campaignRepository.createOrUpdate(CampaignMapper.fromDto(campaign)));
    }

    @PreAuthorize(value="hasAuthority('CAMPAIGN_WRITE')")
    @DeleteMapping(path={"/{campaignId}"}, produces={"application/json"})
    public boolean deleteCampaign(@PathVariable(value="campaignId") Long campaignId) {
        return this.campaignRepository.removeById(campaignId);
    }

    @PreAuthorize(value="hasAuthority('CAMPAIGN_READ')")
    @GetMapping(path={"/{campaignId}"}, produces={"application/json"})
    public CampaignDto getCampaignById(@PathVariable(value="campaignId") Long campaignId) {
        Campaign campaign = this.campaignRepository.findById(campaignId);
        List<CampaignExecutionReport> reports = this.campaignService.findExecutionsById(campaignId);
        this.campaignExecutionEngine.currentExecution(campaignId).ifPresent(report -> this.addCurrentExecution(reports, (CampaignExecutionReport)report));
        return CampaignMapper.toDto(campaign, reports);
    }

    @PreAuthorize(value="hasAuthority('CAMPAIGN_READ')")
    @GetMapping(path={"/{campaignId}/scenarios"}, produces={"application/json"})
    public List<TestCaseIndexDto> getCampaignScenarios(@PathVariable(value="campaignId") Long campaignId) {
        return this.campaignRepository.findScenariosIds(campaignId).stream().map(id -> this.repositoryAggregator.findMetadataById((String)id).orElseThrow(() -> new ScenarioNotFoundException(id))).map(TestCaseIndexDto::from).collect(Collectors.toList());
    }

    @PreAuthorize(value="hasAuthority('CAMPAIGN_READ')")
    @GetMapping(path={""}, produces={"application/json"})
    public List<CampaignDto> getAllCampaigns() {
        return this.campaignRepository.findAll().stream().map(CampaignMapper::toDtoWithoutReport).collect(Collectors.toList());
    }

    @PreAuthorize(value="hasAuthority('CAMPAIGN_READ')")
    @GetMapping(path={"/lastexecutions/{limit}"}, produces={"application/json"})
    public List<CampaignExecutionReportDto> getLastExecutions(@PathVariable(value="limit") Long limit) {
        List<CampaignExecutionReport> lastExecutions = this.campaignExecutionEngine.currentExecutions();
        if ((long)lastExecutions.size() < limit) {
            lastExecutions.addAll(this.campaignRepository.findLastExecutions(limit - (long)lastExecutions.size()));
        }
        return lastExecutions.stream().map(CampaignExecutionReportMapper::toDto).sorted(Comparator.comparing(value -> ((CampaignExecutionReportDto)value).getStartDate()).reversed()).collect(Collectors.toList());
    }

    @PreAuthorize(value="hasAuthority('SCENARIO_READ')")
    @GetMapping(path={"/scenario/{scenarioId}"}, produces={"application/json"})
    public List<CampaignDto> getCampaignsByScenarioId(@PathVariable(value="scenarioId") String scenarioId) {
        return this.campaignRepository.findCampaignsByScenarioId(scenarioId).stream().map(CampaignMapper::toDtoWithoutReport).collect(Collectors.toList());
    }

    private void addCurrentExecution(List<CampaignExecutionReport> currentCampaignExecutionReports, CampaignExecutionReport campaignExecutionReport) {
        if (currentCampaignExecutionReports == null) {
            currentCampaignExecutionReports = new ArrayList<CampaignExecutionReport>();
        }
        currentCampaignExecutionReports.add(0, campaignExecutionReport);
    }
}

