/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.admin.infra;

import com.chutneytesting.server.core.domain.admin.DatabaseAdminService;
import com.chutneytesting.server.core.domain.admin.SqlResult;
import com.chutneytesting.server.core.domain.tools.ImmutablePaginatedDto;
import com.chutneytesting.server.core.domain.tools.PaginatedDto;
import com.chutneytesting.server.core.domain.tools.PaginationRequestWrapperDto;
import com.chutneytesting.server.core.domain.tools.SqlUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="jdbcAdminService")
class DatabaseAdminServiceImpl
implements DatabaseAdminService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseAdminServiceImpl.class);
    private final DataSource dataSource;

    DatabaseAdminServiceImpl(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public SqlResult execute(String query) {
        String cleanQuery = this.cleanQuery(query);
        boolean isSelect = this.isQuerySelect(query);
        String finalQuery = isSelect ? this.limit(cleanQuery, false) : cleanQuery;
        LOGGER.debug("Executing query {}", (Object)finalQuery);
        return this.executeQuery(finalQuery, new Integer[0]);
    }

    public PaginatedDto<SqlResult> paginate(PaginationRequestWrapperDto<String> paginationRequestWrapperDto) {
        long totalCount;
        boolean isQuerySelect;
        String cleanQuery;
        block21: {
            String query = paginationRequestWrapperDto.wrappedRequest().orElse("select 1");
            cleanQuery = this.cleanQuery(query);
            isQuerySelect = this.isQuerySelect(cleanQuery);
            totalCount = 0L;
            if (isQuerySelect) {
                String countQuery = SqlUtils.count((String)cleanQuery);
                try (Connection connection = this.dataSource.getConnection();
                     Statement statement = connection.createStatement();){
                    boolean dataSelected = statement.execute(countQuery);
                    if (!dataSelected) break block21;
                    try (ResultSet rs = statement.getResultSet();){
                        rs.next();
                        totalCount = rs.getLong(1);
                    }
                }
                catch (SQLException e) {
                    SqlResult result = SqlResult.error((String)("Unable to execute statement[" + countQuery + "]: " + e.getMessage()));
                    return ImmutablePaginatedDto.builder().totalCount(totalCount).addData((Object)result).build();
                }
            }
        }
        SqlResult result = isQuerySelect ? this.executeQuery(this.limit(cleanQuery, true), paginationRequestWrapperDto.elementPerPage(), (paginationRequestWrapperDto.pageNumber() - 1) * paginationRequestWrapperDto.elementPerPage()) : this.executeQuery(cleanQuery, new Integer[0]);
        return ImmutablePaginatedDto.builder().totalCount(totalCount).addData((Object)result).build();
    }

    private SqlResult executeQuery(String query, Integer ... args) {
        SqlResult result;
        block22: {
            try (Connection connection = this.dataSource.getConnection();
                 PreparedStatement statement = connection.prepareStatement(query);){
                boolean dataSelected;
                if (args != null && args.length == 2) {
                    statement.setInt(1, args[0]);
                    statement.setInt(2, args[1]);
                }
                if (dataSelected = statement.execute()) {
                    try (ResultSet rs = statement.getResultSet();){
                        result = SqlResult.data((SqlResult.Table)this.resultSetToTable(rs));
                        break block22;
                    }
                }
                result = SqlResult.updatedRows((int)statement.getUpdateCount());
            }
            catch (SQLException e) {
                result = SqlResult.error((String)("Unable to execute statement[" + query + "]: " + e.getMessage()));
            }
        }
        return result;
    }

    private String limit(String query, boolean paginate) {
        if (query.replaceAll("\\R", " ").matches(".*(?i:limit).*[^)]")) {
            return query;
        }
        if (paginate) {
            return query + " LIMIT ? OFFSET ?";
        }
        return query + " LIMIT 20";
    }

    private boolean isQuerySelect(String query) {
        String queryUpper = query.toUpperCase();
        return queryUpper.startsWith("SELECT");
    }

    private String cleanQuery(String query) {
        if ((query = query.trim()).endsWith(";")) {
            query = query.substring(0, query.length() - 1);
        }
        return query;
    }

    private SqlResult.Table resultSetToTable(ResultSet rs) throws SQLException {
        ResultSetMetaData metaData = rs.getMetaData();
        List<String> columNames = this.getColumnNames(metaData);
        ArrayList<SqlResult.Row> rows = new ArrayList<SqlResult.Row>();
        while (rs.next()) {
            ArrayList<String> values = new ArrayList<String>();
            for (String columName : columNames) {
                values.add(rs.getString(columName));
            }
            rows.add(new SqlResult.Row(values));
        }
        return new SqlResult.Table(columNames, rows);
    }

    private List<String> getColumnNames(ResultSetMetaData metaData) throws SQLException {
        int columnCount = metaData.getColumnCount();
        ArrayList<String> columNames = new ArrayList<String>();
        for (int i = 1; i <= columnCount; ++i) {
            columNames.add(metaData.getColumnName(i));
        }
        return columNames;
    }
}

