/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.security;

import com.chutneytesting.security.api.UserDto;
import com.chutneytesting.security.domain.AuthenticationService;
import com.chutneytesting.security.domain.Authorizations;
import com.chutneytesting.security.infra.handlers.Http401FailureHandler;
import com.chutneytesting.security.infra.handlers.HttpEmptyLogoutSuccessHandler;
import com.chutneytesting.server.core.domain.security.Authorization;
import com.chutneytesting.server.core.domain.security.User;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpStatus;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.ChannelSecurityConfigurer;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.HttpStatusEntryPoint;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;

@Configuration
@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true)
public class ChutneyWebSecurityConfig {
    public static final String LOGIN_URL = "/api/v1/user/login";
    public static final String LOGOUT_URL = "/api/v1/user/logout";
    public static final String API_BASE_URL_PATTERN = "/api/**";
    @Value(value="${management.endpoints.web.base-path:'/actuator'}")
    String actuatorBaseUrl;

    @Bean
    public AuthenticationService authenticationService(Authorizations authorizations) {
        return new AuthenticationService(authorizations);
    }

    @Bean
    public SecurityFilterChain securityFilterChain(HttpSecurity http) throws Exception {
        this.configureBaseHttpSecurity(http);
        UserDto anonymous = this.anonymous();
        ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)http.anonymous().principal((Object)anonymous).authorities(new ArrayList<GrantedAuthority>(anonymous.getAuthorities())).and()).authorizeRequests().antMatchers(new String[]{LOGIN_URL})).permitAll().antMatchers(new String[]{LOGOUT_URL})).permitAll().antMatchers(new String[]{"/api/v1/info/**"})).permitAll().antMatchers(new String[]{API_BASE_URL_PATTERN})).authenticated().antMatchers(new String[]{this.actuatorBaseUrl + "/**"})).hasAuthority(Authorization.ADMIN_ACCESS.name()).anyRequest()).permitAll().and()).httpBasic();
        return (SecurityFilterChain)http.build();
    }

    protected void configureBaseHttpSecurity(HttpSecurity http) throws Exception {
        ((HttpSecurity)((FormLoginConfigurer)((FormLoginConfigurer)((HttpSecurity)((ChannelSecurityConfigurer.RequiresChannelUrl)((HttpSecurity)((HttpSecurity)http.csrf().disable()).exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)new HttpStatusEntryPoint(HttpStatus.UNAUTHORIZED)).and()).requiresChannel().anyRequest()).requiresSecure().and()).formLogin().loginProcessingUrl(LOGIN_URL)).successForwardUrl("/api/v1/user").failureHandler((AuthenticationFailureHandler)new Http401FailureHandler())).and()).logout().logoutUrl(LOGOUT_URL).logoutSuccessHandler((LogoutSuccessHandler)new HttpEmptyLogoutSuccessHandler());
    }

    protected UserDto anonymous() {
        UserDto anonymous = new UserDto();
        anonymous.setId(User.ANONYMOUS.id);
        anonymous.setName(User.ANONYMOUS.id);
        anonymous.grantAuthority("ANONYMOUS");
        return anonymous;
    }
}

