/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.scenario.api.raw.dto;

import com.chutneytesting.scenario.api.raw.dto.RawTestCaseDto;
import com.chutneytesting.server.core.domain.tools.ui.KeyValue;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="RawTestCaseDto", generator="Immutables")
@Immutable
public final class ImmutableRawTestCaseDto
implements RawTestCaseDto {
    private final String scenario;
    @Nullable
    private final String id;
    private final String title;
    @Nullable
    private final String description;
    private final List<String> tags;
    @Nullable
    private final String defaultDataset;
    private final Instant creationDate;
    private final String author;
    private final Instant updateDate;
    private final Integer version;
    private final List<KeyValue> parameters;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableRawTestCaseDto(Builder builder) {
        this.scenario = builder.scenario;
        this.id = builder.id;
        this.title = builder.title;
        this.description = builder.description;
        this.tags = ImmutableRawTestCaseDto.createUnmodifiableList(true, builder.tags);
        this.defaultDataset = builder.defaultDataset;
        if (builder.creationDate != null) {
            this.initShim.creationDate(builder.creationDate);
        }
        if (builder.author != null) {
            this.initShim.author(builder.author);
        }
        if (builder.updateDate != null) {
            this.initShim.updateDate(builder.updateDate);
        }
        if (builder.version != null) {
            this.initShim.version(builder.version);
        }
        if (builder.parametersIsSet()) {
            this.initShim.parameters(ImmutableRawTestCaseDto.createUnmodifiableList(true, builder.parameters));
        }
        this.creationDate = this.initShim.creationDate();
        this.author = this.initShim.author();
        this.updateDate = this.initShim.updateDate();
        this.version = this.initShim.version();
        this.parameters = this.initShim.parameters();
        this.initShim = null;
    }

    private ImmutableRawTestCaseDto(String scenario, @Nullable String id, String title, @Nullable String description, List<String> tags, @Nullable String defaultDataset, Instant creationDate, String author, Instant updateDate, Integer version, List<KeyValue> parameters) {
        this.scenario = scenario;
        this.id = id;
        this.title = title;
        this.description = description;
        this.tags = tags;
        this.defaultDataset = defaultDataset;
        this.creationDate = creationDate;
        this.author = author;
        this.updateDate = updateDate;
        this.version = version;
        this.parameters = parameters;
        this.initShim = null;
    }

    private Instant creationDateInitialize() {
        return RawTestCaseDto.super.creationDate();
    }

    private String authorInitialize() {
        return RawTestCaseDto.super.author();
    }

    private Instant updateDateInitialize() {
        return RawTestCaseDto.super.updateDate();
    }

    private Integer versionInitialize() {
        return RawTestCaseDto.super.version();
    }

    private List<KeyValue> parametersInitialize() {
        return RawTestCaseDto.super.parameters();
    }

    @Override
    @JsonProperty(value="content")
    public String scenario() {
        return this.scenario;
    }

    @Override
    @JsonProperty(value="id")
    public Optional<String> id() {
        return Optional.ofNullable(this.id);
    }

    @Override
    @JsonProperty(value="title")
    public String title() {
        return this.title;
    }

    @Override
    @JsonProperty(value="description")
    public Optional<String> description() {
        return Optional.ofNullable(this.description);
    }

    @Override
    @JsonProperty(value="tags")
    public List<String> tags() {
        return this.tags;
    }

    @Override
    @JsonProperty(value="defaultDataset")
    public Optional<String> defaultDataset() {
        return Optional.ofNullable(this.defaultDataset);
    }

    @Override
    @JsonProperty(value="creationDate")
    public Instant creationDate() {
        InitShim shim = this.initShim;
        return shim != null ? shim.creationDate() : this.creationDate;
    }

    @Override
    @JsonProperty(value="author")
    public String author() {
        InitShim shim = this.initShim;
        return shim != null ? shim.author() : this.author;
    }

    @Override
    @JsonProperty(value="updateDate")
    public Instant updateDate() {
        InitShim shim = this.initShim;
        return shim != null ? shim.updateDate() : this.updateDate;
    }

    @Override
    @JsonProperty(value="version")
    public Integer version() {
        InitShim shim = this.initShim;
        return shim != null ? shim.version() : this.version;
    }

    @Override
    @JsonProperty(value="computedParameters")
    public List<KeyValue> parameters() {
        InitShim shim = this.initShim;
        return shim != null ? shim.parameters() : this.parameters;
    }

    public final ImmutableRawTestCaseDto withScenario(String value) {
        String newValue = Objects.requireNonNull(value, "scenario");
        if (this.scenario.equals(newValue)) {
            return this;
        }
        return new ImmutableRawTestCaseDto(newValue, this.id, this.title, this.description, this.tags, this.defaultDataset, this.creationDate, this.author, this.updateDate, this.version, this.parameters);
    }

    public final ImmutableRawTestCaseDto withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (Objects.equals(this.id, newValue)) {
            return this;
        }
        return new ImmutableRawTestCaseDto(this.scenario, newValue, this.title, this.description, this.tags, this.defaultDataset, this.creationDate, this.author, this.updateDate, this.version, this.parameters);
    }

    public final ImmutableRawTestCaseDto withId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return new ImmutableRawTestCaseDto(this.scenario, value, this.title, this.description, this.tags, this.defaultDataset, this.creationDate, this.author, this.updateDate, this.version, this.parameters);
    }

    public final ImmutableRawTestCaseDto withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (this.title.equals(newValue)) {
            return this;
        }
        return new ImmutableRawTestCaseDto(this.scenario, this.id, newValue, this.description, this.tags, this.defaultDataset, this.creationDate, this.author, this.updateDate, this.version, this.parameters);
    }

    public final ImmutableRawTestCaseDto withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (Objects.equals(this.description, newValue)) {
            return this;
        }
        return new ImmutableRawTestCaseDto(this.scenario, this.id, this.title, newValue, this.tags, this.defaultDataset, this.creationDate, this.author, this.updateDate, this.version, this.parameters);
    }

    public final ImmutableRawTestCaseDto withDescription(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new ImmutableRawTestCaseDto(this.scenario, this.id, this.title, value, this.tags, this.defaultDataset, this.creationDate, this.author, this.updateDate, this.version, this.parameters);
    }

    public final ImmutableRawTestCaseDto withTags(String ... elements) {
        List<String> newValue = ImmutableRawTestCaseDto.createUnmodifiableList(false, ImmutableRawTestCaseDto.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableRawTestCaseDto(this.scenario, this.id, this.title, this.description, newValue, this.defaultDataset, this.creationDate, this.author, this.updateDate, this.version, this.parameters);
    }

    public final ImmutableRawTestCaseDto withTags(Iterable<String> elements) {
        if (this.tags == elements) {
            return this;
        }
        List<String> newValue = ImmutableRawTestCaseDto.createUnmodifiableList(false, ImmutableRawTestCaseDto.createSafeList(elements, true, false));
        return new ImmutableRawTestCaseDto(this.scenario, this.id, this.title, this.description, newValue, this.defaultDataset, this.creationDate, this.author, this.updateDate, this.version, this.parameters);
    }

    public final ImmutableRawTestCaseDto withDefaultDataset(String value) {
        String newValue = Objects.requireNonNull(value, "defaultDataset");
        if (Objects.equals(this.defaultDataset, newValue)) {
            return this;
        }
        return new ImmutableRawTestCaseDto(this.scenario, this.id, this.title, this.description, this.tags, newValue, this.creationDate, this.author, this.updateDate, this.version, this.parameters);
    }

    public final ImmutableRawTestCaseDto withDefaultDataset(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.defaultDataset, value)) {
            return this;
        }
        return new ImmutableRawTestCaseDto(this.scenario, this.id, this.title, this.description, this.tags, value, this.creationDate, this.author, this.updateDate, this.version, this.parameters);
    }

    public final ImmutableRawTestCaseDto withCreationDate(Instant value) {
        if (this.creationDate == value) {
            return this;
        }
        Instant newValue = Objects.requireNonNull(value, "creationDate");
        return new ImmutableRawTestCaseDto(this.scenario, this.id, this.title, this.description, this.tags, this.defaultDataset, newValue, this.author, this.updateDate, this.version, this.parameters);
    }

    public final ImmutableRawTestCaseDto withAuthor(String value) {
        String newValue = Objects.requireNonNull(value, "author");
        if (this.author.equals(newValue)) {
            return this;
        }
        return new ImmutableRawTestCaseDto(this.scenario, this.id, this.title, this.description, this.tags, this.defaultDataset, this.creationDate, newValue, this.updateDate, this.version, this.parameters);
    }

    public final ImmutableRawTestCaseDto withUpdateDate(Instant value) {
        if (this.updateDate == value) {
            return this;
        }
        Instant newValue = Objects.requireNonNull(value, "updateDate");
        return new ImmutableRawTestCaseDto(this.scenario, this.id, this.title, this.description, this.tags, this.defaultDataset, this.creationDate, this.author, newValue, this.version, this.parameters);
    }

    public final ImmutableRawTestCaseDto withVersion(Integer value) {
        Integer newValue = Objects.requireNonNull(value, "version");
        if (this.version.equals(newValue)) {
            return this;
        }
        return new ImmutableRawTestCaseDto(this.scenario, this.id, this.title, this.description, this.tags, this.defaultDataset, this.creationDate, this.author, this.updateDate, newValue, this.parameters);
    }

    public final ImmutableRawTestCaseDto withParameters(KeyValue ... elements) {
        List<KeyValue> newValue = ImmutableRawTestCaseDto.createUnmodifiableList(false, ImmutableRawTestCaseDto.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableRawTestCaseDto(this.scenario, this.id, this.title, this.description, this.tags, this.defaultDataset, this.creationDate, this.author, this.updateDate, this.version, newValue);
    }

    public final ImmutableRawTestCaseDto withParameters(Iterable<? extends KeyValue> elements) {
        if (this.parameters == elements) {
            return this;
        }
        List<KeyValue> newValue = ImmutableRawTestCaseDto.createUnmodifiableList(false, ImmutableRawTestCaseDto.createSafeList(elements, true, false));
        return new ImmutableRawTestCaseDto(this.scenario, this.id, this.title, this.description, this.tags, this.defaultDataset, this.creationDate, this.author, this.updateDate, this.version, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRawTestCaseDto && this.equalTo(0, (ImmutableRawTestCaseDto)another);
    }

    private boolean equalTo(int synthetic, ImmutableRawTestCaseDto another) {
        return this.scenario.equals(another.scenario) && Objects.equals(this.id, another.id) && this.title.equals(another.title) && Objects.equals(this.description, another.description) && this.tags.equals(another.tags) && Objects.equals(this.defaultDataset, another.defaultDataset) && this.creationDate.equals(another.creationDate) && this.author.equals(another.author) && this.updateDate.equals(another.updateDate) && this.version.equals(another.version) && this.parameters.equals(another.parameters);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.scenario.hashCode();
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + this.title.hashCode();
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + this.tags.hashCode();
        h += (h << 5) + Objects.hashCode(this.defaultDataset);
        h += (h << 5) + this.creationDate.hashCode();
        h += (h << 5) + this.author.hashCode();
        h += (h << 5) + this.updateDate.hashCode();
        h += (h << 5) + this.version.hashCode();
        h += (h << 5) + this.parameters.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("RawTestCaseDto{");
        builder.append("scenario=").append(this.scenario);
        if (this.id != null) {
            builder.append(", ");
            builder.append("id=").append(this.id);
        }
        builder.append(", ");
        builder.append("title=").append(this.title);
        if (this.description != null) {
            builder.append(", ");
            builder.append("description=").append(this.description);
        }
        builder.append(", ");
        builder.append("tags=").append(this.tags);
        if (this.defaultDataset != null) {
            builder.append(", ");
            builder.append("defaultDataset=").append(this.defaultDataset);
        }
        builder.append(", ");
        builder.append("creationDate=").append(this.creationDate);
        builder.append(", ");
        builder.append("author=").append(this.author);
        builder.append(", ");
        builder.append("updateDate=").append(this.updateDate);
        builder.append(", ");
        builder.append("version=").append(this.version);
        builder.append(", ");
        builder.append("parameters=").append(this.parameters);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableRawTestCaseDto fromJson(Json json) {
        Builder builder = ImmutableRawTestCaseDto.builder();
        if (json.scenario != null) {
            builder.scenario(json.scenario);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.title != null) {
            builder.title(json.title);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.tags != null) {
            builder.addAllTags(json.tags);
        }
        if (json.defaultDataset != null) {
            builder.defaultDataset(json.defaultDataset);
        }
        if (json.creationDate != null) {
            builder.creationDate(json.creationDate);
        }
        if (json.author != null) {
            builder.author(json.author);
        }
        if (json.updateDate != null) {
            builder.updateDate(json.updateDate);
        }
        if (json.version != null) {
            builder.version(json.version);
        }
        if (json.parametersIsSet) {
            builder.addAllParameters(json.parameters);
        }
        return builder.build();
    }

    public static ImmutableRawTestCaseDto copyOf(RawTestCaseDto instance) {
        if (instance instanceof ImmutableRawTestCaseDto) {
            return (ImmutableRawTestCaseDto)instance;
        }
        return ImmutableRawTestCaseDto.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="RawTestCaseDto", generator="Immutables")
    private final class InitShim {
        private byte creationDateBuildStage = 0;
        private Instant creationDate;
        private byte authorBuildStage = 0;
        private String author;
        private byte updateDateBuildStage = 0;
        private Instant updateDate;
        private byte versionBuildStage = 0;
        private Integer version;
        private byte parametersBuildStage = 0;
        private List<KeyValue> parameters;

        private InitShim() {
        }

        Instant creationDate() {
            if (this.creationDateBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.creationDateBuildStage == 0) {
                this.creationDateBuildStage = (byte)-1;
                this.creationDate = Objects.requireNonNull(ImmutableRawTestCaseDto.this.creationDateInitialize(), "creationDate");
                this.creationDateBuildStage = 1;
            }
            return this.creationDate;
        }

        void creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            this.creationDateBuildStage = 1;
        }

        String author() {
            if (this.authorBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.authorBuildStage == 0) {
                this.authorBuildStage = (byte)-1;
                this.author = Objects.requireNonNull(ImmutableRawTestCaseDto.this.authorInitialize(), "author");
                this.authorBuildStage = 1;
            }
            return this.author;
        }

        void author(String author) {
            this.author = author;
            this.authorBuildStage = 1;
        }

        Instant updateDate() {
            if (this.updateDateBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.updateDateBuildStage == 0) {
                this.updateDateBuildStage = (byte)-1;
                this.updateDate = Objects.requireNonNull(ImmutableRawTestCaseDto.this.updateDateInitialize(), "updateDate");
                this.updateDateBuildStage = 1;
            }
            return this.updateDate;
        }

        void updateDate(Instant updateDate) {
            this.updateDate = updateDate;
            this.updateDateBuildStage = 1;
        }

        Integer version() {
            if (this.versionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.versionBuildStage == 0) {
                this.versionBuildStage = (byte)-1;
                this.version = Objects.requireNonNull(ImmutableRawTestCaseDto.this.versionInitialize(), "version");
                this.versionBuildStage = 1;
            }
            return this.version;
        }

        void version(Integer version) {
            this.version = version;
            this.versionBuildStage = 1;
        }

        List<KeyValue> parameters() {
            if (this.parametersBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.parametersBuildStage == 0) {
                this.parametersBuildStage = (byte)-1;
                this.parameters = ImmutableRawTestCaseDto.createUnmodifiableList(false, ImmutableRawTestCaseDto.createSafeList(ImmutableRawTestCaseDto.this.parametersInitialize(), true, false));
                this.parametersBuildStage = 1;
            }
            return this.parameters;
        }

        void parameters(List<KeyValue> parameters) {
            this.parameters = parameters;
            this.parametersBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.creationDateBuildStage == -1) {
                attributes.add("creationDate");
            }
            if (this.authorBuildStage == -1) {
                attributes.add("author");
            }
            if (this.updateDateBuildStage == -1) {
                attributes.add("updateDate");
            }
            if (this.versionBuildStage == -1) {
                attributes.add("version");
            }
            if (this.parametersBuildStage == -1) {
                attributes.add("parameters");
            }
            return "Cannot build RawTestCaseDto, attribute initializers form cycle " + attributes;
        }
    }

    @Generated(from="RawTestCaseDto", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SCENARIO = 1L;
        private static final long INIT_BIT_TITLE = 2L;
        private static final long OPT_BIT_PARAMETERS = 1L;
        private long initBits = 3L;
        private long optBits;
        @Nullable
        private String scenario;
        @Nullable
        private String id;
        @Nullable
        private String title;
        @Nullable
        private String description;
        private List<String> tags = new ArrayList<String>();
        @Nullable
        private String defaultDataset;
        @Nullable
        private Instant creationDate;
        @Nullable
        private String author;
        @Nullable
        private Instant updateDate;
        @Nullable
        private Integer version;
        private List<KeyValue> parameters = new ArrayList<KeyValue>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(RawTestCaseDto instance) {
            Objects.requireNonNull(instance, "instance");
            this.scenario(instance.scenario());
            Optional<String> idOptional = instance.id();
            if (idOptional.isPresent()) {
                this.id(idOptional);
            }
            this.title(instance.title());
            Optional<String> descriptionOptional = instance.description();
            if (descriptionOptional.isPresent()) {
                this.description(descriptionOptional);
            }
            this.addAllTags(instance.tags());
            Optional<String> defaultDatasetOptional = instance.defaultDataset();
            if (defaultDatasetOptional.isPresent()) {
                this.defaultDataset(defaultDatasetOptional);
            }
            this.creationDate(instance.creationDate());
            this.author(instance.author());
            this.updateDate(instance.updateDate());
            this.version(instance.version());
            this.addAllParameters(instance.parameters());
            return this;
        }

        @JsonProperty(value="content")
        @CanIgnoreReturnValue
        public final Builder scenario(String scenario) {
            this.scenario = Objects.requireNonNull(scenario, "scenario");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            return this;
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder id(Optional<String> id) {
            this.id = id.orElse(null);
            return this;
        }

        @JsonProperty(value="title")
        @CanIgnoreReturnValue
        public final Builder title(String title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            return this;
        }

        @JsonProperty(value="description")
        @CanIgnoreReturnValue
        public final Builder description(Optional<String> description) {
            this.description = description.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTags(String element) {
            this.tags.add(Objects.requireNonNull(element, "tags element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTags(String ... elements) {
            for (String element : elements) {
                this.tags.add(Objects.requireNonNull(element, "tags element"));
            }
            return this;
        }

        @JsonProperty(value="tags")
        @CanIgnoreReturnValue
        public final Builder tags(Iterable<String> elements) {
            this.tags.clear();
            return this.addAllTags(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllTags(Iterable<String> elements) {
            for (String element : elements) {
                this.tags.add(Objects.requireNonNull(element, "tags element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder defaultDataset(String defaultDataset) {
            this.defaultDataset = Objects.requireNonNull(defaultDataset, "defaultDataset");
            return this;
        }

        @JsonProperty(value="defaultDataset")
        @CanIgnoreReturnValue
        public final Builder defaultDataset(Optional<String> defaultDataset) {
            this.defaultDataset = defaultDataset.orElse(null);
            return this;
        }

        @JsonProperty(value="creationDate")
        @CanIgnoreReturnValue
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = Objects.requireNonNull(creationDate, "creationDate");
            return this;
        }

        @JsonProperty(value="author")
        @CanIgnoreReturnValue
        public final Builder author(String author) {
            this.author = Objects.requireNonNull(author, "author");
            return this;
        }

        @JsonProperty(value="updateDate")
        @CanIgnoreReturnValue
        public final Builder updateDate(Instant updateDate) {
            this.updateDate = Objects.requireNonNull(updateDate, "updateDate");
            return this;
        }

        @JsonProperty(value="version")
        @CanIgnoreReturnValue
        public final Builder version(Integer version) {
            this.version = Objects.requireNonNull(version, "version");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addParameters(KeyValue element) {
            this.parameters.add(Objects.requireNonNull(element, "parameters element"));
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addParameters(KeyValue ... elements) {
            for (KeyValue element : elements) {
                this.parameters.add(Objects.requireNonNull(element, "parameters element"));
            }
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="computedParameters")
        @CanIgnoreReturnValue
        public final Builder parameters(Iterable<? extends KeyValue> elements) {
            this.parameters.clear();
            return this.addAllParameters(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllParameters(Iterable<? extends KeyValue> elements) {
            for (KeyValue keyValue : elements) {
                this.parameters.add(Objects.requireNonNull(keyValue, "parameters element"));
            }
            this.optBits |= 1L;
            return this;
        }

        public ImmutableRawTestCaseDto build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRawTestCaseDto(this);
        }

        private boolean parametersIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("scenario");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("title");
            }
            return "Cannot build RawTestCaseDto, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="RawTestCaseDto", generator="Immutables")
    static final class Json
    implements RawTestCaseDto {
        @Nullable
        String scenario;
        @Nullable
        Optional<String> id = Optional.empty();
        @Nullable
        String title;
        @Nullable
        Optional<String> description = Optional.empty();
        @Nullable
        List<String> tags = Collections.emptyList();
        @Nullable
        Optional<String> defaultDataset = Optional.empty();
        @Nullable
        Instant creationDate;
        @Nullable
        String author;
        @Nullable
        Instant updateDate;
        @Nullable
        Integer version;
        @Nullable
        List<KeyValue> parameters = Collections.emptyList();
        boolean parametersIsSet;

        Json() {
        }

        @JsonProperty(value="content")
        public void setScenario(String scenario) {
            this.scenario = scenario;
        }

        @JsonProperty(value="id")
        public void setId(Optional<String> id) {
            this.id = id;
        }

        @JsonProperty(value="title")
        public void setTitle(String title) {
            this.title = title;
        }

        @JsonProperty(value="description")
        public void setDescription(Optional<String> description) {
            this.description = description;
        }

        @JsonProperty(value="tags")
        public void setTags(List<String> tags) {
            this.tags = tags;
        }

        @JsonProperty(value="defaultDataset")
        public void setDefaultDataset(Optional<String> defaultDataset) {
            this.defaultDataset = defaultDataset;
        }

        @JsonProperty(value="creationDate")
        public void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @JsonProperty(value="author")
        public void setAuthor(String author) {
            this.author = author;
        }

        @JsonProperty(value="updateDate")
        public void setUpdateDate(Instant updateDate) {
            this.updateDate = updateDate;
        }

        @JsonProperty(value="version")
        public void setVersion(Integer version) {
            this.version = version;
        }

        @JsonProperty(value="computedParameters")
        public void setParameters(List<KeyValue> parameters) {
            this.parameters = parameters;
            this.parametersIsSet = true;
        }

        @Override
        public String scenario() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String title() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> description() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> tags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> defaultDataset() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant creationDate() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String author() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant updateDate() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer version() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<KeyValue> parameters() {
            throw new UnsupportedOperationException();
        }
    }
}

