/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.execution.api;

import com.chutneytesting.execution.api.ExecutionSummaryDto;
import com.chutneytesting.server.core.domain.execution.history.ExecutionHistory;
import com.chutneytesting.server.core.domain.execution.history.ExecutionHistoryRepository;
import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin(origins={"*"})
class ScenarioExecutionHistoryController {
    private final ExecutionHistoryRepository executionHistoryRepository;

    ScenarioExecutionHistoryController(ExecutionHistoryRepository executionHistoryRepository) {
        this.executionHistoryRepository = executionHistoryRepository;
    }

    @PreAuthorize(value="hasAuthority('SCENARIO_READ')")
    @GetMapping(path={"/api/ui/scenario/{scenarioId}/execution/v1"}, produces={"application/json"})
    public List<ExecutionSummaryDto> listExecutions(@PathVariable(value="scenarioId") String scenarioId) {
        return ExecutionSummaryDto.toDto(this.executionHistoryRepository.getExecutions(scenarioId));
    }

    @PreAuthorize(value="hasAuthority('SCENARIO_READ')")
    @GetMapping(path={"/api/ui/scenario/execution/{executionId}/summary/v1"}, produces={"application/json"})
    public ExecutionSummaryDto getExecutionSummary(@PathVariable(value="executionId") Long executionId) {
        return ExecutionSummaryDto.toDto(this.executionHistoryRepository.getExecutionSummary(executionId));
    }

    @PreAuthorize(value="hasAuthority('SCENARIO_READ')")
    @GetMapping(path={"/api/ui/scenario/{scenarioId}/execution/{executionId}/v1"}, produces={"application/json"})
    public ExecutionHistory.Execution getExecutionReport(@PathVariable(value="scenarioId") String scenarioId, @PathVariable(value="executionId") Long executionId) {
        return this.executionHistoryRepository.getExecution(scenarioId, executionId);
    }
}

