/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.scenario.infra.raw;

import com.chutneytesting.scenario.infra.jpa.Scenario;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import javax.persistence.criteria.Expression;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.query.Param;

public interface ScenarioJpaRepository
extends CrudRepository<Scenario, Long>,
JpaSpecificationExecutor<Scenario> {
    @Query(value="SELECT s.version FROM SCENARIO s WHERE s.id = :id")
    public Optional<Integer> lastVersion(@Param(value="id") Long var1);

    public Optional<Scenario> findByIdAndActivated(Long var1, Boolean var2);

    @Query(value="SELECT new com.chutneytesting.scenario.infra.jpa.Scenario(s.id, s.title, s.description, s.tags, s.creationDate, s.dataset, s.activated, s.userId, s.updateDate, s.version, s.defaultDataset)\nFROM SCENARIO s\nWHERE s.id = :id\n  AND s.activated = :activated\n")
    public Optional<Scenario> findMetaDataByIdAndActivated(@Param(value="id") Long var1, @Param(value="activated") Boolean var2);

    @Query(value="SELECT new com.chutneytesting.scenario.infra.jpa.Scenario(s.id, s.title, s.description, s.tags, s.creationDate, s.dataset, s.activated, s.userId, s.updateDate, s.version, s.defaultDataset)\nFROM SCENARIO s\nWHERE s.activated = true\n")
    public List<Scenario> findMetaDataByActivatedTrue();

    public static Specification<Scenario> contentContains(String searchWord) {
        return (Specification & Serializable)(root, query, builder) -> {
            Expression content = builder.lower((Expression)root.get("content"));
            return builder.like(content, "%" + searchWord.toLowerCase() + "%");
        };
    }
}

