/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.dataset.api;

import com.chutneytesting.dataset.api.ImmutableDataSetDto;
import com.chutneytesting.server.core.domain.tools.ui.KeyValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.immutables.value.Value;

@JsonSerialize(as=ImmutableDataSetDto.class)
@JsonDeserialize(as=ImmutableDataSetDto.class)
@Value.Immutable
@Value.Style(jdkOnly=true)
public interface DataSetDto {
    public Optional<String> id();

    public String name();

    @Value.Default
    default public Integer version() {
        return 0;
    }

    @Value.Default
    default public String description() {
        return "";
    }

    @Value.Default
    default public Instant lastUpdated() {
        return Instant.now();
    }

    @Value.Default
    default public List<String> tags() {
        return Collections.emptyList();
    }

    @JsonProperty(value="uniqueValues")
    @Value.Default
    default public List<KeyValue> constants() {
        return Collections.emptyList();
    }

    @JsonProperty(value="multipleValues")
    @Value.Default
    default public List<List<KeyValue>> datatable() {
        return Collections.emptyList();
    }

    default public List<String> duplicatedHeaders() {
        if (!this.datatable().isEmpty()) {
            List<String> headers = this.datatable().get(0).stream().map(KeyValue::key).toList();
            return headers.stream().collect(Collectors.groupingBy(h -> h, Collectors.counting())).entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).map(Map.Entry::getKey).toList();
        }
        return Collections.emptyList();
    }
}

