/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting;

import io.undertow.servlet.api.SecurityConstraint;
import io.undertow.servlet.api.SecurityInfo;
import io.undertow.servlet.api.TransportGuaranteeType;
import io.undertow.servlet.api.WebResourceCollection;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.embedded.undertow.UndertowServletWebServerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Configuration
@Profile(value={"undertow-https-redirect"})
public class UndertowConfig {
    @Value(value="${server.port}")
    private int securePort;
    @Value(value="${server.http.port}")
    private int httpPort;
    @Value(value="${server.http.interface}")
    private String httpInterface;

    @Bean
    public UndertowServletWebServerFactory servletWebServerFactory() {
        UndertowServletWebServerFactory factory = new UndertowServletWebServerFactory();
        factory.getBuilderCustomizers().add(builder -> builder.addHttpListener(this.httpPort, this.httpInterface));
        factory.getDeploymentInfoCustomizers().add(deploymentInfo -> deploymentInfo.addSecurityConstraint((SecurityConstraint)((SecurityConstraint)new SecurityConstraint().addWebResourceCollection(new WebResourceCollection().addUrlPattern("/*")).setTransportGuaranteeType(TransportGuaranteeType.CONFIDENTIAL)).setEmptyRoleSemantic(SecurityInfo.EmptyRoleSemantic.PERMIT)).setConfidentialPortManager(exchange -> this.securePort));
        return factory;
    }
}

