/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.dataset.api;

import com.chutneytesting.dataset.api.DataSetDto;
import com.chutneytesting.dataset.api.DataSetMapper;
import com.chutneytesting.dataset.domain.DatasetService;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/datasets"})
@CrossOrigin(origins={"*"})
@ConditionalOnMissingClass(value={"com.chutneytesting.component.dataset.api.ComponentDataSetController"})
public class DataSetController {
    public static final String BASE_URL = "/api/v1/datasets";
    private final DatasetService datasetService;

    public DataSetController(DatasetService datasetService) {
        this.datasetService = datasetService;
    }

    @PreAuthorize(value="hasAuthority('DATASET_READ') or hasAuthority('SCENARIO_WRITE') or hasAuthority('CAMPAIGN_WRITE')")
    @GetMapping(path={""}, produces={"application/json"})
    public List<DataSetDto> findAll() {
        return this.datasetService.findAll().stream().map(DataSetMapper::toDto).collect(Collectors.toList());
    }

    @PreAuthorize(value="hasAuthority('DATASET_WRITE')")
    @PostMapping(path={""}, produces={"application/json"})
    public DataSetDto save(@RequestBody DataSetDto datasetDto) {
        return DataSetMapper.toDto(this.datasetService.save(DataSetMapper.fromDto(datasetDto)));
    }

    @PreAuthorize(value="hasAuthority('DATASET_WRITE')")
    @PutMapping(path={""}, produces={"application/json"})
    public DataSetDto update(@RequestBody DataSetDto dataSetDto, @RequestParam Optional<String> oldId) {
        return DataSetMapper.toDto(this.datasetService.update(oldId, DataSetMapper.fromDto(dataSetDto)));
    }

    @PreAuthorize(value="hasAuthority('DATASET_WRITE')")
    @DeleteMapping(path={"/{datasetName}"})
    public void deleteById(@PathVariable String datasetName) {
        this.datasetService.remove(datasetName);
    }

    @PreAuthorize(value="hasAuthority('DATASET_READ')")
    @GetMapping(path={"/{id}"}, produces={"application/json"})
    public DataSetDto findById(@PathVariable String id) {
        return DataSetMapper.toDto(this.datasetService.findById(id));
    }
}

