/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.scenario.api.raw.dto;

import com.chutneytesting.scenario.api.raw.dto.ImmutableRawTestCaseDto;
import com.chutneytesting.server.core.domain.security.User;
import com.chutneytesting.server.core.domain.tools.ui.KeyValue;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.immutables.value.Value;

@JsonSerialize(as=ImmutableRawTestCaseDto.class)
@JsonDeserialize(as=ImmutableRawTestCaseDto.class)
@JsonIgnoreProperties(ignoreUnknown=true)
@Value.Immutable
@Value.Style(jdkOnly=true)
public interface RawTestCaseDto {
    @JsonProperty(value="content")
    public String scenario();

    public Optional<String> id();

    public String title();

    public Optional<String> description();

    public List<String> tags();

    @Value.Default
    default public Instant creationDate() {
        return Instant.now();
    }

    @Value.Default
    default public String author() {
        return User.ANONYMOUS.id;
    }

    @Value.Default
    default public Instant updateDate() {
        return Instant.now();
    }

    @Value.Default
    default public Integer version() {
        return 1;
    }

    @JsonProperty(value="computedParameters")
    @Value.Default
    default public List<KeyValue> parameters() {
        return Collections.emptyList();
    }
}

