/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.design.infra.storage.plugins.linkifier;

import com.chutneytesting.design.domain.plugins.linkifier.Linkifier;
import com.chutneytesting.design.domain.plugins.linkifier.Linkifiers;
import com.chutneytesting.design.infra.storage.plugins.linkifier.LinkifierDto;
import com.chutneytesting.tools.file.FileUtils;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class LinkifierFileRepository
implements Linkifiers {
    private static final Path ROOT_DIRECTORY_NAME = Paths.get("plugins", new String[0]);
    private static final String LINKIFIER_FILE = "linkifiers.json";
    private final Path storeFolderPath;
    private final Path resolvedFilePath;
    private final ObjectMapper objectMapper = new ObjectMapper().findAndRegisterModules().enable(SerializationFeature.INDENT_OUTPUT).setSerializationInclusion(JsonInclude.Include.NON_EMPTY);

    LinkifierFileRepository(@Value(value="${chutney.configuration-folder:~/.chutney/conf}") String storeFolderPath) throws UncheckedIOException {
        this.storeFolderPath = Paths.get(storeFolderPath, new String[0]).resolve(ROOT_DIRECTORY_NAME);
        this.resolvedFilePath = this.storeFolderPath.resolve(LINKIFIER_FILE);
        FileUtils.initFolder((Path)this.storeFolderPath);
    }

    @Override
    public List<Linkifier> getAll() {
        return this.getAll(this.resolvedFilePath);
    }

    private List<Linkifier> getAll(Path filePath) {
        return this.readFile(filePath).entrySet().stream().map(e -> this.fromDto((String)e.getKey(), (LinkifierDto)e.getValue())).collect(Collectors.toList());
    }

    @Override
    public Linkifier add(Linkifier linkifier) {
        Map<String, LinkifierDto> linkifiers = this.readDefaultFile();
        linkifiers.put(linkifier.id, this.toDto(linkifier));
        this.writeOnDisk(this.resolvedFilePath, linkifiers);
        return linkifier;
    }

    @Override
    public void remove(String id) {
        Map<String, LinkifierDto> linkifiers = this.readDefaultFile();
        linkifiers.remove(id);
        this.writeOnDisk(this.resolvedFilePath, linkifiers);
    }

    private Map<String, LinkifierDto> readDefaultFile() {
        return this.readFile(this.resolvedFilePath);
    }

    private Map<String, LinkifierDto> readFile(Path filePath) {
        HashMap<String, LinkifierDto> linkifiers = new HashMap<String, LinkifierDto>();
        try {
            if (Files.exists(filePath, new LinkOption[0])) {
                byte[] bytes = Files.readAllBytes(filePath);
                linkifiers.putAll((Map)this.objectMapper.readValue(bytes, (TypeReference)new TypeReference<HashMap<String, LinkifierDto>>(){}));
            }
        }
        catch (IOException e) {
            throw new UnsupportedOperationException("Cannot read configuration file: " + filePath, e);
        }
        return linkifiers;
    }

    private void writeOnDisk(Path filePath, Map<String, LinkifierDto> linkifiers) {
        try {
            byte[] bytes = this.objectMapper.writeValueAsBytes(linkifiers);
            try {
                Files.write(filePath, bytes, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new UnsupportedOperationException("Cannot write in configuration directory: " + this.storeFolderPath, e);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot serialize " + linkifiers, e);
        }
    }

    public Linkifier fromDto(String id, LinkifierDto dto) {
        return new Linkifier(dto.pattern, dto.link, id);
    }

    public LinkifierDto toDto(Linkifier linkifier) {
        return new LinkifierDto(linkifier.pattern, linkifier.link);
    }
}

