/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.campaign.infra;

import com.chutneytesting.scenario.domain.TestCaseRepositoryAggregator;
import com.chutneytesting.server.core.domain.execution.history.ExecutionHistory;
import com.chutneytesting.server.core.domain.execution.history.ImmutableExecutionHistory;
import com.chutneytesting.server.core.domain.execution.report.ServerReportStatus;
import com.chutneytesting.server.core.domain.scenario.ScenarioNotFoundException;
import com.chutneytesting.server.core.domain.scenario.campaign.CampaignExecutionReport;
import com.chutneytesting.server.core.domain.scenario.campaign.ScenarioExecutionReportCampaign;
import com.google.common.collect.Lists;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Component;

@Component
public class CampaignExecutionReportMapper
implements ResultSetExtractor<List<CampaignExecutionReport>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CampaignExecutionReportMapper.class);
    private final TestCaseRepositoryAggregator repository;

    public CampaignExecutionReportMapper(TestCaseRepositoryAggregator repository) {
        this.repository = repository;
    }

    public List<CampaignExecutionReport> extractData(ResultSet resultset) throws SQLException {
        HashMap<Long, ArrayList> scenarioByCampaignId = new HashMap<Long, ArrayList>();
        HashMap<Long, CampaignExecutionHolder> campaignExecutionReportByCampaignId = new HashMap<Long, CampaignExecutionHolder>();
        while (resultset.next()) {
            long campaignExecutionId = resultset.getLong("ID");
            String scenarioId = resultset.getString("SCENARIO_ID");
            String title = resultset.getString("CAMPAIGN_TITLE");
            boolean partialExecution = resultset.getBoolean("PARTIAL_EXECUTION");
            String executionEnvironment = resultset.getString("EXECUTION_ENVIRONMENT");
            String userId = resultset.getString("USER_ID");
            String testCaseTitle = resultset.getString("TEST_CASE_TITLE");
            Long campaignId = resultset.getLong("CAMPAIGN_ID");
            String dataSetId = resultset.getString("EXECUTION_DATASET_ID");
            Integer dataSetVersion = Optional.ofNullable(resultset.getString("EXECUTION_DATASET_VERSION")).map(Integer::valueOf).orElse(null);
            try {
                if (testCaseTitle == null || testCaseTitle.isEmpty()) {
                    testCaseTitle = this.repository.findById(scenarioId).orElseThrow(() -> new ScenarioNotFoundException(scenarioId)).metadata().title();
                }
                ScenarioExecutionReportCampaign scenarioExecutionReport = this.readScenarioExecutionReport(resultset, scenarioId, testCaseTitle);
                scenarioByCampaignId.putIfAbsent(campaignExecutionId, Lists.newArrayList());
                campaignExecutionReportByCampaignId.putIfAbsent(campaignExecutionId, new CampaignExecutionHolder(campaignExecutionId, title, partialExecution, executionEnvironment, userId, campaignId, dataSetId, dataSetVersion));
                ((List)scenarioByCampaignId.get(campaignExecutionId)).add(scenarioExecutionReport);
            }
            catch (ScenarioNotFoundException snfe) {
                LOGGER.warn("Campaign history reference a no longer existing scenario[" + scenarioId + "]");
            }
        }
        return scenarioByCampaignId.entrySet().stream().map(entry -> {
            Long campaignExecutionId = (Long)entry.getKey();
            CampaignExecutionHolder campaignExecutionHolder = (CampaignExecutionHolder)campaignExecutionReportByCampaignId.get(campaignExecutionId);
            return new CampaignExecutionReport(campaignExecutionId, campaignExecutionHolder.campaignId, (List)entry.getValue(), campaignExecutionHolder.title, campaignExecutionHolder.partialExecution, campaignExecutionHolder.executionEnvironment, campaignExecutionHolder.dataSetId, campaignExecutionHolder.dataSetVersion, campaignExecutionHolder.userId);
        }).collect(Collectors.toList());
    }

    private ScenarioExecutionReportCampaign readScenarioExecutionReport(ResultSet resultset, String scenarioId, String testCaseTitle) throws SQLException {
        Object execution = resultset.getLong("SCENARIO_EXECUTION_ID") == -1L ? ImmutableExecutionHistory.ExecutionSummary.builder().executionId(Long.valueOf(-1L)).testCaseTitle(testCaseTitle).time(LocalDateTime.now()).status(ServerReportStatus.NOT_EXECUTED).duration(0L).environment("").user("").build() : this.mapExecutionWithoutReport(resultset, testCaseTitle);
        ScenarioExecutionReportCampaign scenarioExecutionReportCampaign = new ScenarioExecutionReportCampaign(scenarioId, testCaseTitle, execution);
        return scenarioExecutionReportCampaign;
    }

    private ExecutionHistory.ExecutionSummary mapExecutionWithoutReport(ResultSet rs, String testCaseTitle) throws SQLException {
        return ImmutableExecutionHistory.ExecutionSummary.builder().executionId(Long.valueOf(rs.getLong("SCENARIO_EXECUTION_ID"))).time(Instant.ofEpochMilli(rs.getLong("EXECUTION_TIME")).atZone(ZoneId.systemDefault()).toLocalDateTime()).duration(rs.getLong("DURATION")).status(ServerReportStatus.valueOf((String)rs.getString("STATUS"))).info(Optional.ofNullable(rs.getString("INFORMATION"))).error(Optional.ofNullable(rs.getString("ERROR"))).testCaseTitle(testCaseTitle).environment(rs.getString("ENVIRONMENT")).datasetId(Optional.ofNullable(rs.getString("DATASET_ID"))).datasetVersion(Optional.ofNullable(rs.getString("DATASET_VERSION")).map(Integer::valueOf)).user(rs.getString("USER_ID")).build();
    }

    private static class CampaignExecutionHolder {
        public final Long id;
        public final String title;
        public final boolean partialExecution;
        public final String executionEnvironment;
        public final String userId;
        public final Long campaignId;
        public final String dataSetId;
        public final Integer dataSetVersion;

        public CampaignExecutionHolder(Long id, String title, boolean partialExecution, String executionEnvironment, String userId, Long campaignId, String dataSetId, Integer dataSetVersion) {
            this.id = id;
            this.title = title;
            this.partialExecution = partialExecution;
            this.executionEnvironment = executionEnvironment;
            this.userId = userId;
            this.campaignId = campaignId;
            this.dataSetId = dataSetId;
            this.dataSetVersion = dataSetVersion;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CampaignExecutionHolder that = (CampaignExecutionHolder)o;
            return Objects.equals(this.id, that.id);
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }
    }
}

