/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.security.infra.handlers;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.minidev.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;

public class Http401FailureHandler
implements AuthenticationFailureHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(Http401FailureHandler.class);

    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        String username = request.getParameter("username");
        LOGGER.debug("Authentication failure for user [{}]", (Object)username);
        HashMap<String, String> message = new HashMap<String, String>();
        message.put("message", this.extractMessageFromException((Exception)exception));
        response.setStatus(401);
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setContentType("application/json");
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        response.getOutputStream().write(JSONObject.toJSONString(message).getBytes());
    }

    private String extractMessageFromException(Exception exception) {
        String msg = exception.getCause() != null ? exception.getCause().getMessage() : exception.getMessage();
        return new String(msg.getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8);
    }
}

