/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.scenario.infra.raw;

import com.chutneytesting.scenario.infra.jpa.ScenarioDao;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import javax.persistence.criteria.Expression;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.query.Param;

public interface DatabaseTestCaseRepositoryDao
extends CrudRepository<ScenarioDao, Long>,
JpaSpecificationExecutor<ScenarioDao> {
    @Query(value="SELECT s FROM SCENARIO s WHERE s.id = :id and s.activated = true")
    public Optional<ScenarioDao> findById(@Param(value="id") Long var1);

    @Query(value="SELECT s FROM SCENARIO s WHERE s.activated = true")
    public List<ScenarioDao> findAll();

    @Modifying
    @Query(value="UPDATE FROM SCENARIO s SET s.activated = false WHERE s.id = :id")
    public void deactivateScenario(@Param(value="id") Long var1);

    @Query(value="SELECT s.version FROM  SCENARIO s WHERE s.id = :id")
    public Optional<Integer> getLastVersion(@Param(value="id") Long var1);

    public static Specification<ScenarioDao> contentContains(String searchWord) {
        return (Specification & Serializable)(root, query, builder) -> {
            Expression content = builder.lower((Expression)root.get("content"));
            return builder.like(content, "%" + searchWord.toLowerCase() + "%");
        };
    }
}

