/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.scenario.infra.raw;

import com.chutneytesting.scenario.domain.gwt.GwtTestCase;
import com.chutneytesting.scenario.infra.jpa.ScenarioDao;
import com.chutneytesting.scenario.infra.raw.DatabaseTestCaseRepositoryDao;
import com.chutneytesting.scenario.infra.raw.TestCaseData;
import com.chutneytesting.scenario.infra.raw.TestCaseDataMapper;
import com.chutneytesting.server.core.domain.scenario.AggregatedRepository;
import com.chutneytesting.server.core.domain.scenario.ScenarioNotFoundException;
import com.chutneytesting.server.core.domain.scenario.TestCase;
import com.chutneytesting.server.core.domain.scenario.TestCaseMetadata;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.orm.ObjectOptimisticLockingFailureException;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class DatabaseTestCaseRepository
implements AggregatedRepository<GwtTestCase> {
    private final NamedParameterJdbcTemplate uiNamedParameterJdbcTemplate;
    private final DatabaseTestCaseRepositoryDao jpa;

    public DatabaseTestCaseRepository(NamedParameterJdbcTemplate uiNamedParameterJdbcTemplate, DatabaseTestCaseRepositoryDao jpa) {
        this.uiNamedParameterJdbcTemplate = uiNamedParameterJdbcTemplate;
        this.jpa = jpa;
    }

    public String save(GwtTestCase testCase) {
        TestCaseData testCaseData = TestCaseDataMapper.toDto(testCase);
        return this.doSave(testCaseData).toString();
    }

    public Optional<GwtTestCase> findById(String scenarioId) {
        if (this.checkIdInput(scenarioId)) {
            return Optional.empty();
        }
        try {
            Optional<ScenarioDao> scenarioDao = this.jpa.findById(Long.valueOf(scenarioId));
            return scenarioDao.map(ScenarioDao::toGwtTestCase);
        }
        catch (IncorrectResultSizeDataAccessException e) {
            return Optional.empty();
        }
    }

    public Optional<TestCase> findExecutableById(String id) {
        if (this.checkIdInput(id)) {
            return Optional.empty();
        }
        Optional<GwtTestCase> byId = this.findById(id);
        if (byId.isPresent()) {
            return Optional.of((TestCase)byId.get());
        }
        return Optional.empty();
    }

    public Optional<TestCaseMetadata> findMetadataById(String testCaseId) {
        return this.findById(testCaseId).map(t -> t.metadata());
    }

    public List<TestCaseMetadata> findAll() {
        return this.jpa.findAll().stream().map(ScenarioDao::toTestCaseMetadata).collect(Collectors.toList());
    }

    @Transactional
    public void removeById(String scenarioId) {
        if (this.checkIdInput(scenarioId)) {
            return;
        }
        this.uiNamedParameterJdbcTemplate.update("DELETE FROM CAMPAIGN_EXECUTION_HISTORY WHERE SCENARIO_ID = :id", this.buildIdParameterMap(scenarioId));
        this.uiNamedParameterJdbcTemplate.update("DELETE FROM CAMPAIGN_SCENARIOS WHERE SCENARIO_ID = :id", this.buildIdParameterMap(scenarioId));
        this.jpa.deactivateScenario(Long.valueOf(scenarioId));
    }

    public Optional<Integer> lastVersion(String scenarioId) {
        if (this.checkIdInput(scenarioId)) {
            return Optional.empty();
        }
        try {
            return this.jpa.getLastVersion(Long.valueOf(scenarioId));
        }
        catch (IncorrectResultSizeDataAccessException e) {
            return Optional.empty();
        }
    }

    public List<TestCaseMetadata> search(String textFilter) {
        if (!textFilter.isEmpty()) {
            String[] words = DatabaseTestCaseRepository.escapeSql(textFilter).split("\\s");
            Specification<ScenarioDao> scenarioDaoSpecification = this.buildLikeSpecificationOnContent(words);
            List all = this.jpa.findAll(scenarioDaoSpecification);
            return all.stream().map(ScenarioDao::toTestCaseMetadata).collect(Collectors.toList());
        }
        return this.findAll();
    }

    private static String escapeSql(String str) {
        if (str == null) {
            return null;
        }
        return str.replace("'", "''");
    }

    private Specification<ScenarioDao> buildLikeSpecificationOnContent(String[] words) {
        Specification scenarioDaoSpecification = null;
        for (String word : words) {
            Specification wordSpecification = DatabaseTestCaseRepositoryDao.contentContains(word);
            scenarioDaoSpecification = scenarioDaoSpecification == null ? wordSpecification : scenarioDaoSpecification.or(wordSpecification);
        }
        return scenarioDaoSpecification;
    }

    private Long doSave(TestCaseData scenario) {
        try {
            return ((ScenarioDao)this.jpa.save(ScenarioDao.fromTestCaseData(scenario))).getId();
        }
        catch (ObjectOptimisticLockingFailureException e) {
            throw new ScenarioNotFoundException(scenario.id, scenario.version);
        }
    }

    private ImmutableMap<String, Object> buildIdParameterMap(String scenarioId) {
        return ImmutableMap.builder().put((Object)"id", (Object)scenarioId).build();
    }

    private boolean checkIdInput(String scenarioId) {
        return Strings.isNullOrEmpty((String)scenarioId) || !StringUtils.isNumeric((CharSequence)scenarioId);
    }
}

