/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.scenario.api.raw.dto;

import com.chutneytesting.execution.api.ExecutionSummaryDto;
import com.chutneytesting.scenario.api.raw.dto.GwtTestCaseMetadataDto;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="GwtTestCaseMetadataDto", generator="Immutables")
@Immutable
public final class ImmutableGwtTestCaseMetadataDto
implements GwtTestCaseMetadataDto {
    @Nullable
    private final String id;
    private final String title;
    @Nullable
    private final String description;
    @Nullable
    private final String repositorySource;
    private final ImmutableList<String> tags;
    private final ImmutableList<ExecutionSummaryDto> executions;
    private final Instant creationDate;
    private final Instant updateDate;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableGwtTestCaseMetadataDto(Builder builder) {
        this.id = builder.id;
        this.title = builder.title;
        this.description = builder.description;
        this.repositorySource = builder.repositorySource;
        this.tags = builder.tags.build();
        this.executions = builder.executions.build();
        if (builder.creationDate != null) {
            this.initShim.creationDate(builder.creationDate);
        }
        if (builder.updateDate != null) {
            this.initShim.updateDate(builder.updateDate);
        }
        this.creationDate = this.initShim.creationDate();
        this.updateDate = this.initShim.updateDate();
        this.initShim = null;
    }

    private ImmutableGwtTestCaseMetadataDto(@Nullable String id, String title, @Nullable String description, @Nullable String repositorySource, ImmutableList<String> tags, ImmutableList<ExecutionSummaryDto> executions, Instant creationDate, Instant updateDate) {
        this.id = id;
        this.title = title;
        this.description = description;
        this.repositorySource = repositorySource;
        this.tags = tags;
        this.executions = executions;
        this.creationDate = creationDate;
        this.updateDate = updateDate;
        this.initShim = null;
    }

    private Instant creationDateInitialize() {
        return GwtTestCaseMetadataDto.super.creationDate();
    }

    private Instant updateDateInitialize() {
        return GwtTestCaseMetadataDto.super.updateDate();
    }

    @Override
    @JsonProperty(value="id")
    public Optional<String> id() {
        return Optional.ofNullable(this.id);
    }

    @Override
    @JsonProperty(value="title")
    public String title() {
        return this.title;
    }

    @Override
    @JsonProperty(value="description")
    public Optional<String> description() {
        return Optional.ofNullable(this.description);
    }

    @Override
    @JsonProperty(value="repositorySource")
    public Optional<String> repositorySource() {
        return Optional.ofNullable(this.repositorySource);
    }

    @JsonProperty(value="tags")
    public ImmutableList<String> tags() {
        return this.tags;
    }

    @JsonProperty(value="executions")
    public ImmutableList<ExecutionSummaryDto> executions() {
        return this.executions;
    }

    @Override
    @JsonProperty(value="creationDate")
    public Instant creationDate() {
        InitShim shim = this.initShim;
        return shim != null ? shim.creationDate() : this.creationDate;
    }

    @Override
    @JsonProperty(value="updateDate")
    public Instant updateDate() {
        InitShim shim = this.initShim;
        return shim != null ? shim.updateDate() : this.updateDate;
    }

    public final ImmutableGwtTestCaseMetadataDto withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (Objects.equals(this.id, newValue)) {
            return this;
        }
        return new ImmutableGwtTestCaseMetadataDto(newValue, this.title, this.description, this.repositorySource, this.tags, this.executions, this.creationDate, this.updateDate);
    }

    public final ImmutableGwtTestCaseMetadataDto withId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return new ImmutableGwtTestCaseMetadataDto(value, this.title, this.description, this.repositorySource, this.tags, this.executions, this.creationDate, this.updateDate);
    }

    public final ImmutableGwtTestCaseMetadataDto withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (this.title.equals(newValue)) {
            return this;
        }
        return new ImmutableGwtTestCaseMetadataDto(this.id, newValue, this.description, this.repositorySource, this.tags, this.executions, this.creationDate, this.updateDate);
    }

    public final ImmutableGwtTestCaseMetadataDto withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (Objects.equals(this.description, newValue)) {
            return this;
        }
        return new ImmutableGwtTestCaseMetadataDto(this.id, this.title, newValue, this.repositorySource, this.tags, this.executions, this.creationDate, this.updateDate);
    }

    public final ImmutableGwtTestCaseMetadataDto withDescription(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new ImmutableGwtTestCaseMetadataDto(this.id, this.title, value, this.repositorySource, this.tags, this.executions, this.creationDate, this.updateDate);
    }

    public final ImmutableGwtTestCaseMetadataDto withRepositorySource(String value) {
        String newValue = Objects.requireNonNull(value, "repositorySource");
        if (Objects.equals(this.repositorySource, newValue)) {
            return this;
        }
        return new ImmutableGwtTestCaseMetadataDto(this.id, this.title, this.description, newValue, this.tags, this.executions, this.creationDate, this.updateDate);
    }

    public final ImmutableGwtTestCaseMetadataDto withRepositorySource(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.repositorySource, value)) {
            return this;
        }
        return new ImmutableGwtTestCaseMetadataDto(this.id, this.title, this.description, value, this.tags, this.executions, this.creationDate, this.updateDate);
    }

    public final ImmutableGwtTestCaseMetadataDto withTags(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableGwtTestCaseMetadataDto(this.id, this.title, this.description, this.repositorySource, (ImmutableList<String>)newValue, this.executions, this.creationDate, this.updateDate);
    }

    public final ImmutableGwtTestCaseMetadataDto withTags(Iterable<String> elements) {
        if (this.tags == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableGwtTestCaseMetadataDto(this.id, this.title, this.description, this.repositorySource, (ImmutableList<String>)newValue, this.executions, this.creationDate, this.updateDate);
    }

    public final ImmutableGwtTestCaseMetadataDto withExecutions(ExecutionSummaryDto ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableGwtTestCaseMetadataDto(this.id, this.title, this.description, this.repositorySource, this.tags, (ImmutableList<ExecutionSummaryDto>)newValue, this.creationDate, this.updateDate);
    }

    public final ImmutableGwtTestCaseMetadataDto withExecutions(Iterable<? extends ExecutionSummaryDto> elements) {
        if (this.executions == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableGwtTestCaseMetadataDto(this.id, this.title, this.description, this.repositorySource, this.tags, (ImmutableList<ExecutionSummaryDto>)newValue, this.creationDate, this.updateDate);
    }

    public final ImmutableGwtTestCaseMetadataDto withCreationDate(Instant value) {
        if (this.creationDate == value) {
            return this;
        }
        Instant newValue = Objects.requireNonNull(value, "creationDate");
        return new ImmutableGwtTestCaseMetadataDto(this.id, this.title, this.description, this.repositorySource, this.tags, this.executions, newValue, this.updateDate);
    }

    public final ImmutableGwtTestCaseMetadataDto withUpdateDate(Instant value) {
        if (this.updateDate == value) {
            return this;
        }
        Instant newValue = Objects.requireNonNull(value, "updateDate");
        return new ImmutableGwtTestCaseMetadataDto(this.id, this.title, this.description, this.repositorySource, this.tags, this.executions, this.creationDate, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGwtTestCaseMetadataDto && this.equalTo(0, (ImmutableGwtTestCaseMetadataDto)another);
    }

    private boolean equalTo(int synthetic, ImmutableGwtTestCaseMetadataDto another) {
        return Objects.equals(this.id, another.id) && this.title.equals(another.title) && Objects.equals(this.description, another.description) && Objects.equals(this.repositorySource, another.repositorySource) && this.tags.equals(another.tags) && this.executions.equals(another.executions) && this.creationDate.equals(another.creationDate) && this.updateDate.equals(another.updateDate);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + this.title.hashCode();
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + Objects.hashCode(this.repositorySource);
        h += (h << 5) + this.tags.hashCode();
        h += (h << 5) + this.executions.hashCode();
        h += (h << 5) + this.creationDate.hashCode();
        h += (h << 5) + this.updateDate.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"GwtTestCaseMetadataDto").omitNullValues().add("id", (Object)this.id).add("title", (Object)this.title).add("description", (Object)this.description).add("repositorySource", (Object)this.repositorySource).add("tags", this.tags).add("executions", this.executions).add("creationDate", (Object)this.creationDate).add("updateDate", (Object)this.updateDate).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableGwtTestCaseMetadataDto fromJson(Json json) {
        Builder builder = ImmutableGwtTestCaseMetadataDto.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.title != null) {
            builder.title(json.title);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.repositorySource != null) {
            builder.repositorySource(json.repositorySource);
        }
        if (json.tags != null) {
            builder.addAllTags(json.tags);
        }
        if (json.executions != null) {
            builder.addAllExecutions(json.executions);
        }
        if (json.creationDate != null) {
            builder.creationDate(json.creationDate);
        }
        if (json.updateDate != null) {
            builder.updateDate(json.updateDate);
        }
        return builder.build();
    }

    public static ImmutableGwtTestCaseMetadataDto copyOf(GwtTestCaseMetadataDto instance) {
        if (instance instanceof ImmutableGwtTestCaseMetadataDto) {
            return (ImmutableGwtTestCaseMetadataDto)instance;
        }
        return ImmutableGwtTestCaseMetadataDto.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="GwtTestCaseMetadataDto", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TITLE = 1L;
        private long initBits = 1L;
        @Nullable
        private String id;
        @Nullable
        private String title;
        @Nullable
        private String description;
        @Nullable
        private String repositorySource;
        private ImmutableList.Builder<String> tags = ImmutableList.builder();
        private ImmutableList.Builder<ExecutionSummaryDto> executions = ImmutableList.builder();
        @Nullable
        private Instant creationDate;
        @Nullable
        private Instant updateDate;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(GwtTestCaseMetadataDto instance) {
            Optional<String> repositorySourceOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<String> idOptional = instance.id();
            if (idOptional.isPresent()) {
                this.id(idOptional);
            }
            this.title(instance.title());
            Optional<String> descriptionOptional = instance.description();
            if (descriptionOptional.isPresent()) {
                this.description(descriptionOptional);
            }
            if ((repositorySourceOptional = instance.repositorySource()).isPresent()) {
                this.repositorySource(repositorySourceOptional);
            }
            this.addAllTags(instance.tags());
            this.addAllExecutions(instance.executions());
            this.creationDate(instance.creationDate());
            this.updateDate(instance.updateDate());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            return this;
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder id(Optional<String> id) {
            this.id = id.orElse(null);
            return this;
        }

        @JsonProperty(value="title")
        @CanIgnoreReturnValue
        public final Builder title(String title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            return this;
        }

        @JsonProperty(value="description")
        @CanIgnoreReturnValue
        public final Builder description(Optional<String> description) {
            this.description = description.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder repositorySource(String repositorySource) {
            this.repositorySource = Objects.requireNonNull(repositorySource, "repositorySource");
            return this;
        }

        @JsonProperty(value="repositorySource")
        @CanIgnoreReturnValue
        public final Builder repositorySource(Optional<String> repositorySource) {
            this.repositorySource = repositorySource.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTags(String element) {
            this.tags.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTags(String ... elements) {
            this.tags.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="tags")
        @CanIgnoreReturnValue
        public final Builder tags(Iterable<String> elements) {
            this.tags = ImmutableList.builder();
            return this.addAllTags(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllTags(Iterable<String> elements) {
            this.tags.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addExecutions(ExecutionSummaryDto element) {
            this.executions.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addExecutions(ExecutionSummaryDto ... elements) {
            this.executions.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="executions")
        @CanIgnoreReturnValue
        public final Builder executions(Iterable<? extends ExecutionSummaryDto> elements) {
            this.executions = ImmutableList.builder();
            return this.addAllExecutions(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllExecutions(Iterable<? extends ExecutionSummaryDto> elements) {
            this.executions.addAll(elements);
            return this;
        }

        @JsonProperty(value="creationDate")
        @CanIgnoreReturnValue
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = Objects.requireNonNull(creationDate, "creationDate");
            return this;
        }

        @JsonProperty(value="updateDate")
        @CanIgnoreReturnValue
        public final Builder updateDate(Instant updateDate) {
            this.updateDate = Objects.requireNonNull(updateDate, "updateDate");
            return this;
        }

        public ImmutableGwtTestCaseMetadataDto build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGwtTestCaseMetadataDto(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("title");
            }
            return "Cannot build GwtTestCaseMetadataDto, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="GwtTestCaseMetadataDto", generator="Immutables")
    static final class Json
    implements GwtTestCaseMetadataDto {
        @Nullable
        Optional<String> id = Optional.empty();
        @Nullable
        String title;
        @Nullable
        Optional<String> description = Optional.empty();
        @Nullable
        Optional<String> repositorySource = Optional.empty();
        @Nullable
        List<String> tags = ImmutableList.of();
        @Nullable
        List<ExecutionSummaryDto> executions = ImmutableList.of();
        @Nullable
        Instant creationDate;
        @Nullable
        Instant updateDate;

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(Optional<String> id) {
            this.id = id;
        }

        @JsonProperty(value="title")
        public void setTitle(String title) {
            this.title = title;
        }

        @JsonProperty(value="description")
        public void setDescription(Optional<String> description) {
            this.description = description;
        }

        @JsonProperty(value="repositorySource")
        public void setRepositorySource(Optional<String> repositorySource) {
            this.repositorySource = repositorySource;
        }

        @JsonProperty(value="tags")
        public void setTags(List<String> tags) {
            this.tags = tags;
        }

        @JsonProperty(value="executions")
        public void setExecutions(List<ExecutionSummaryDto> executions) {
            this.executions = executions;
        }

        @JsonProperty(value="creationDate")
        public void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @JsonProperty(value="updateDate")
        public void setUpdateDate(Instant updateDate) {
            this.updateDate = updateDate;
        }

        @Override
        public Optional<String> id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String title() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> description() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> repositorySource() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> tags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<ExecutionSummaryDto> executions() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant creationDate() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant updateDate() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="GwtTestCaseMetadataDto", generator="Immutables")
    private final class InitShim {
        private byte creationDateBuildStage = 0;
        private Instant creationDate;
        private byte updateDateBuildStage = 0;
        private Instant updateDate;

        private InitShim() {
        }

        Instant creationDate() {
            if (this.creationDateBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.creationDateBuildStage == 0) {
                this.creationDateBuildStage = (byte)-1;
                this.creationDate = Objects.requireNonNull(ImmutableGwtTestCaseMetadataDto.this.creationDateInitialize(), "creationDate");
                this.creationDateBuildStage = 1;
            }
            return this.creationDate;
        }

        void creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            this.creationDateBuildStage = 1;
        }

        Instant updateDate() {
            if (this.updateDateBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.updateDateBuildStage == 0) {
                this.updateDateBuildStage = (byte)-1;
                this.updateDate = Objects.requireNonNull(ImmutableGwtTestCaseMetadataDto.this.updateDateInitialize(), "updateDate");
                this.updateDateBuildStage = 1;
            }
            return this.updateDate;
        }

        void updateDate(Instant updateDate) {
            this.updateDate = updateDate;
            this.updateDateBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.creationDateBuildStage == -1) {
                attributes.add("creationDate");
            }
            if (this.updateDateBuildStage == -1) {
                attributes.add("updateDate");
            }
            return "Cannot build GwtTestCaseMetadataDto, attribute initializers form cycle " + attributes;
        }
    }
}

