/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.campaign.infra;

import com.chutneytesting.campaign.infra.CampaignExecutionReportMapper;
import com.chutneytesting.execution.domain.campaign.CampaignExecutionNotFoundException;
import com.chutneytesting.server.core.domain.scenario.campaign.CampaignExecutionReport;
import com.chutneytesting.server.core.domain.scenario.campaign.ScenarioExecutionReportCampaign;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class CampaignExecutionRepository {
    private final CampaignExecutionReportMapper campaignExecutionReportMapper;
    private final NamedParameterJdbcTemplate uiNamedParameterJdbcTemplate;
    private static final int LIMIT_BLOC_SIZE = 20;
    private static final String QUERY_FIND_CAMPAIGN_EXECUTION_HISTORY = "SELECT C.CAMPAIGN_ID, C.ID, C.SCENARIO_ID, C.SCENARIO_EXECUTION_ID, C.PARTIAL_EXECUTION, C.EXECUTION_ENVIRONMENT, C.DATASET_ID as EXECUTION_DATASET_ID, C.DATASET_VERSION as EXECUTION_DATASET_VERSION, C.USER_ID, SEH.TEST_CASE_TITLE, SEH.EXECUTION_TIME, SEH.DURATION, SEH.STATUS, SEH.INFORMATION, SEH.ERROR, SEH.ENVIRONMENT, SEH.DATASET_ID, SEH.DATASET_VERSION, CA.TITLE as CAMPAIGN_TITLE FROM CAMPAIGN_EXECUTION_HISTORY C LEFT OUTER JOIN SCENARIO_EXECUTION_HISTORY SEH ON SEH.ID = C.SCENARIO_EXECUTION_ID INNER JOIN CAMPAIGN CA ON CA.ID = C.CAMPAIGN_ID WHERE C.CAMPAIGN_ID = :idCampaign AND C.ID IN (SELECT DISTINCT CC.ID as ID FROM CAMPAIGN_EXECUTION_HISTORY CC WHERE CC.CAMPAIGN_ID = :idCampaign ORDER BY 1 DESC FETCH FIRST 20 ROWS ONLY) ORDER BY C.ID DESC, SEH.ID DESC";
    private static final String QUERY_FIND_LAST_EXECUTION_HISTORY = "select distinct C.ID from CAMPAIGN_EXECUTION_HISTORY C order by C.ID desc LIMIT :numberexec";
    private static final String QUERY_FIND_EXECUTION_BY_EXEC_ID = "SELECT C.CAMPAIGN_ID, C.ID, C.SCENARIO_ID, C.SCENARIO_EXECUTION_ID, C.PARTIAL_EXECUTION, C.EXECUTION_ENVIRONMENT, C.DATASET_ID as EXECUTION_DATASET_ID, C.DATASET_VERSION as EXECUTION_DATASET_VERSION, C.USER_ID, SEH.TEST_CASE_TITLE, SEH.EXECUTION_TIME, SEH.DURATION, SEH.STATUS, SEH.INFORMATION, SEH.ERROR, SEH.ENVIRONMENT, SEH.DATASET_ID, SEH.DATASET_VERSION, CA.TITLE as CAMPAIGN_TITLE FROM CAMPAIGN_EXECUTION_HISTORY C INNER JOIN SCENARIO_EXECUTION_HISTORY SEH ON SEH.ID = C.SCENARIO_EXECUTION_ID INNER JOIN CAMPAIGN CA ON CA.ID = C.CAMPAIGN_ID WHERE C.ID in (:idCampaignExecution) ORDER BY C.ID DESC";
    private static final String QUERY_DELETE_ALL_CAMPAIGN_EXECUTION_HISTORY = "DELETE FROM CAMPAIGN_EXECUTION_HISTORY WHERE CAMPAIGN_ID = :idCampaign";
    private static final String QUERY_SAVE_CAMPAIGN_EXECUTION_HISTORY = "INSERT INTO CAMPAIGN_EXECUTION_HISTORY(CAMPAIGN_ID, ID, SCENARIO_ID, SCENARIO_EXECUTION_ID, PARTIAL_EXECUTION, EXECUTION_ENVIRONMENT, DATASET_ID, DATASET_VERSION, USER_ID) VALUES (:idCampaign, :idCampaignExecution, :idScenario, :idScenarioExecution, :partialExecution, :executionEnvironment, :dataSetId, :dataSetVersion, :user)";

    public CampaignExecutionRepository(NamedParameterJdbcTemplate uiNamedParameterJdbcTemplate, CampaignExecutionReportMapper repository) {
        this.uiNamedParameterJdbcTemplate = uiNamedParameterJdbcTemplate;
        this.campaignExecutionReportMapper = repository;
    }

    List<CampaignExecutionReport> findExecutionHistory(Long campaignId) {
        return (List)this.uiNamedParameterJdbcTemplate.query(QUERY_FIND_CAMPAIGN_EXECUTION_HISTORY, (Map)ImmutableMap.of((Object)"idCampaign", (Object)campaignId), (ResultSetExtractor)this.campaignExecutionReportMapper);
    }

    void saveCampaignReport(Long campaignId, CampaignExecutionReport report) {
        report.scenarioExecutionReports().forEach(scenarioExecutionReport -> this.saveScenarioExecutionReport(campaignId, report.executionId, report.partialExecution, (ScenarioExecutionReportCampaign)scenarioExecutionReport, report.executionEnvironment, report.dataSetId.orElse(null), report.dataSetVersion.orElse(null), report.userId));
    }

    List<CampaignExecutionReport> findLastExecutions(Long numberOfExecution) {
        List campaignExecIds = this.uiNamedParameterJdbcTemplate.query(QUERY_FIND_LAST_EXECUTION_HISTORY.replace(":numberexec", numberOfExecution.toString()), Collections.emptyMap(), (RowMapper)new SingleColumnRowMapper());
        if (campaignExecIds.isEmpty()) {
            return Collections.emptyList();
        }
        return this.getCampaignExecutionReportsById(campaignExecIds);
    }

    CampaignExecutionReport getCampaignExecutionReportsById(Long campaignExecId) {
        List<CampaignExecutionReport> campaignExecutionReportsById = this.getCampaignExecutionReportsById(Collections.singletonList(campaignExecId));
        if (campaignExecutionReportsById.isEmpty()) {
            throw new CampaignExecutionNotFoundException(campaignExecId);
        }
        return campaignExecutionReportsById.get(0);
    }

    private List<CampaignExecutionReport> getCampaignExecutionReportsById(List<Long> campaignExecIds) {
        return (List)this.uiNamedParameterJdbcTemplate.query(QUERY_FIND_EXECUTION_BY_EXEC_ID, (Map)ImmutableMap.of((Object)"idCampaignExecution", campaignExecIds), (ResultSetExtractor)this.campaignExecutionReportMapper);
    }

    void clearAllExecutionHistory(Long campaignId) {
        this.uiNamedParameterJdbcTemplate.update(QUERY_DELETE_ALL_CAMPAIGN_EXECUTION_HISTORY, (Map)ImmutableMap.of((Object)"idCampaign", (Object)campaignId));
    }

    private int saveScenarioExecutionReport(Long campaignId, Long campaignExecutionId, boolean partialExecution, ScenarioExecutionReportCampaign scenarioExecutionReport, String executionEnvironment, String dataSetId, Integer dataSetVersion, String userId) {
        HashMap parameters = Maps.newHashMap();
        parameters.put("idCampaign", campaignId);
        parameters.put("idCampaignExecution", campaignExecutionId);
        parameters.put("idScenario", scenarioExecutionReport.scenarioId);
        parameters.put("idScenarioExecution", scenarioExecutionReport.execution.executionId());
        parameters.put("partialExecution", partialExecution);
        parameters.put("executionEnvironment", executionEnvironment);
        parameters.put("dataSetId", dataSetId);
        parameters.put("dataSetVersion", dataSetVersion);
        parameters.put("user", userId);
        return this.uiNamedParameterJdbcTemplate.update(QUERY_SAVE_CAMPAIGN_EXECUTION_HISTORY, (Map)parameters);
    }

    Long generateCampaignExecutionId() {
        return (Long)this.uiNamedParameterJdbcTemplate.queryForObject("SELECT nextval('CAMPAIGN_EXECUTION_SEQ')", Collections.emptyMap(), Long.class);
    }
}

