/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.agent.domain.configure;

import com.chutneytesting.agent.domain.configure.NetworkConfiguration;
import com.chutneytesting.engine.domain.delegation.NamedHostAndPort;
import com.chutneytesting.environment.api.dto.EnvironmentDto;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="NetworkConfiguration", generator="Immutables")
@Immutable
public final class ImmutableNetworkConfiguration
implements NetworkConfiguration {
    private final Instant creationDate;
    private final NetworkConfiguration.AgentNetworkConfiguration agentNetworkConfiguration;
    private final NetworkConfiguration.EnvironmentConfiguration environmentConfiguration;

    private ImmutableNetworkConfiguration(Instant creationDate, NetworkConfiguration.AgentNetworkConfiguration agentNetworkConfiguration, NetworkConfiguration.EnvironmentConfiguration environmentConfiguration) {
        this.creationDate = creationDate;
        this.agentNetworkConfiguration = agentNetworkConfiguration;
        this.environmentConfiguration = environmentConfiguration;
    }

    @Override
    public Instant creationDate() {
        return this.creationDate;
    }

    @Override
    public NetworkConfiguration.AgentNetworkConfiguration agentNetworkConfiguration() {
        return this.agentNetworkConfiguration;
    }

    @Override
    public NetworkConfiguration.EnvironmentConfiguration environmentConfiguration() {
        return this.environmentConfiguration;
    }

    public final ImmutableNetworkConfiguration withCreationDate(Instant value) {
        if (this.creationDate == value) {
            return this;
        }
        Instant newValue = Objects.requireNonNull(value, "creationDate");
        return new ImmutableNetworkConfiguration(newValue, this.agentNetworkConfiguration, this.environmentConfiguration);
    }

    public final ImmutableNetworkConfiguration withAgentNetworkConfiguration(NetworkConfiguration.AgentNetworkConfiguration value) {
        if (this.agentNetworkConfiguration == value) {
            return this;
        }
        NetworkConfiguration.AgentNetworkConfiguration newValue = Objects.requireNonNull(value, "agentNetworkConfiguration");
        return new ImmutableNetworkConfiguration(this.creationDate, newValue, this.environmentConfiguration);
    }

    public final ImmutableNetworkConfiguration withEnvironmentConfiguration(NetworkConfiguration.EnvironmentConfiguration value) {
        if (this.environmentConfiguration == value) {
            return this;
        }
        NetworkConfiguration.EnvironmentConfiguration newValue = Objects.requireNonNull(value, "environmentConfiguration");
        return new ImmutableNetworkConfiguration(this.creationDate, this.agentNetworkConfiguration, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNetworkConfiguration && this.equalTo(0, (ImmutableNetworkConfiguration)another);
    }

    private boolean equalTo(int synthetic, ImmutableNetworkConfiguration another) {
        return this.creationDate.equals(another.creationDate) && this.agentNetworkConfiguration.equals(another.agentNetworkConfiguration) && this.environmentConfiguration.equals(another.environmentConfiguration);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.creationDate.hashCode();
        h += (h << 5) + this.agentNetworkConfiguration.hashCode();
        h += (h << 5) + this.environmentConfiguration.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"NetworkConfiguration").omitNullValues().add("creationDate", (Object)this.creationDate).add("agentNetworkConfiguration", (Object)this.agentNetworkConfiguration).add("environmentConfiguration", (Object)this.environmentConfiguration).toString();
    }

    public static ImmutableNetworkConfiguration copyOf(NetworkConfiguration instance) {
        if (instance instanceof ImmutableNetworkConfiguration) {
            return (ImmutableNetworkConfiguration)instance;
        }
        return ImmutableNetworkConfiguration.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @CheckReturnValue
    @Generated(from="NetworkConfiguration.EnvironmentConfiguration", generator="Immutables")
    @Immutable
    public static final class EnvironmentConfiguration
    implements NetworkConfiguration.EnvironmentConfiguration {
        private final ImmutableSet<EnvironmentDto> environments;

        private EnvironmentConfiguration(Iterable<? extends EnvironmentDto> environments) {
            this.environments = ImmutableSet.copyOf(environments);
        }

        private EnvironmentConfiguration(EnvironmentConfiguration original, ImmutableSet<EnvironmentDto> environments) {
            this.environments = environments;
        }

        public ImmutableSet<EnvironmentDto> environments() {
            return this.environments;
        }

        public final EnvironmentConfiguration withEnvironments(EnvironmentDto ... elements) {
            ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
            return new EnvironmentConfiguration(this, (ImmutableSet<EnvironmentDto>)newValue);
        }

        public final EnvironmentConfiguration withEnvironments(Iterable<? extends EnvironmentDto> elements) {
            if (this.environments == elements) {
                return this;
            }
            ImmutableSet newValue = ImmutableSet.copyOf(elements);
            return new EnvironmentConfiguration(this, (ImmutableSet<EnvironmentDto>)newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof EnvironmentConfiguration && this.equalTo(0, (EnvironmentConfiguration)another);
        }

        private boolean equalTo(int synthetic, EnvironmentConfiguration another) {
            return this.environments.equals(another.environments);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.environments.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"EnvironmentConfiguration").omitNullValues().add("environments", this.environments).toString();
        }

        public static EnvironmentConfiguration of(Set<EnvironmentDto> environments) {
            return EnvironmentConfiguration.of(environments);
        }

        public static EnvironmentConfiguration of(Iterable<? extends EnvironmentDto> environments) {
            return new EnvironmentConfiguration(environments);
        }

        public static EnvironmentConfiguration copyOf(NetworkConfiguration.EnvironmentConfiguration instance) {
            if (instance instanceof EnvironmentConfiguration) {
                return (EnvironmentConfiguration)instance;
            }
            return EnvironmentConfiguration.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="NetworkConfiguration.EnvironmentConfiguration", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private ImmutableSet.Builder<EnvironmentDto> environments = ImmutableSet.builder();

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(NetworkConfiguration.EnvironmentConfiguration instance) {
                Objects.requireNonNull(instance, "instance");
                this.addAllEnvironments(instance.environments());
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder addEnvironments(EnvironmentDto element) {
                this.environments.add((Object)element);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder addEnvironments(EnvironmentDto ... elements) {
                this.environments.add((Object[])elements);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder environments(Iterable<? extends EnvironmentDto> elements) {
                this.environments = ImmutableSet.builder();
                return this.addAllEnvironments(elements);
            }

            @CanIgnoreReturnValue
            public final Builder addAllEnvironments(Iterable<? extends EnvironmentDto> elements) {
                this.environments.addAll(elements);
                return this;
            }

            public EnvironmentConfiguration build() {
                return new EnvironmentConfiguration(null, (ImmutableSet<EnvironmentDto>)this.environments.build());
            }
        }
    }

    @CheckReturnValue
    @Generated(from="NetworkConfiguration.AgentNetworkConfiguration", generator="Immutables")
    @Immutable
    public static final class AgentNetworkConfiguration
    implements NetworkConfiguration.AgentNetworkConfiguration {
        private final ImmutableSet<NamedHostAndPort> agentInfos;

        private AgentNetworkConfiguration(Iterable<? extends NamedHostAndPort> agentInfos) {
            this.agentInfos = ImmutableSet.copyOf(agentInfos);
        }

        private AgentNetworkConfiguration(AgentNetworkConfiguration original, ImmutableSet<NamedHostAndPort> agentInfos) {
            this.agentInfos = agentInfos;
        }

        public ImmutableSet<NamedHostAndPort> agentInfos() {
            return this.agentInfos;
        }

        public final AgentNetworkConfiguration withAgentInfos(NamedHostAndPort ... elements) {
            ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
            return new AgentNetworkConfiguration(this, (ImmutableSet<NamedHostAndPort>)newValue);
        }

        public final AgentNetworkConfiguration withAgentInfos(Iterable<? extends NamedHostAndPort> elements) {
            if (this.agentInfos == elements) {
                return this;
            }
            ImmutableSet newValue = ImmutableSet.copyOf(elements);
            return new AgentNetworkConfiguration(this, (ImmutableSet<NamedHostAndPort>)newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof AgentNetworkConfiguration && this.equalTo(0, (AgentNetworkConfiguration)another);
        }

        private boolean equalTo(int synthetic, AgentNetworkConfiguration another) {
            return this.agentInfos.equals(another.agentInfos);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.agentInfos.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"AgentNetworkConfiguration").omitNullValues().add("agentInfos", this.agentInfos).toString();
        }

        public static AgentNetworkConfiguration of(Set<NamedHostAndPort> agentInfos) {
            return AgentNetworkConfiguration.of(agentInfos);
        }

        public static AgentNetworkConfiguration of(Iterable<? extends NamedHostAndPort> agentInfos) {
            return new AgentNetworkConfiguration(agentInfos);
        }

        public static AgentNetworkConfiguration copyOf(NetworkConfiguration.AgentNetworkConfiguration instance) {
            if (instance instanceof AgentNetworkConfiguration) {
                return (AgentNetworkConfiguration)instance;
            }
            return AgentNetworkConfiguration.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="NetworkConfiguration.AgentNetworkConfiguration", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private ImmutableSet.Builder<NamedHostAndPort> agentInfos = ImmutableSet.builder();

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(NetworkConfiguration.AgentNetworkConfiguration instance) {
                Objects.requireNonNull(instance, "instance");
                this.addAllAgentInfos(instance.agentInfos());
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder addAgentInfos(NamedHostAndPort element) {
                this.agentInfos.add((Object)element);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder addAgentInfos(NamedHostAndPort ... elements) {
                this.agentInfos.add((Object[])elements);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder agentInfos(Iterable<? extends NamedHostAndPort> elements) {
                this.agentInfos = ImmutableSet.builder();
                return this.addAllAgentInfos(elements);
            }

            @CanIgnoreReturnValue
            public final Builder addAllAgentInfos(Iterable<? extends NamedHostAndPort> elements) {
                this.agentInfos.addAll(elements);
                return this;
            }

            public AgentNetworkConfiguration build() {
                return new AgentNetworkConfiguration(null, (ImmutableSet<NamedHostAndPort>)this.agentInfos.build());
            }
        }
    }

    @Generated(from="NetworkConfiguration", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CREATION_DATE = 1L;
        private static final long INIT_BIT_AGENT_NETWORK_CONFIGURATION = 2L;
        private static final long INIT_BIT_ENVIRONMENT_CONFIGURATION = 4L;
        private long initBits = 7L;
        @Nullable
        private Instant creationDate;
        @Nullable
        private NetworkConfiguration.AgentNetworkConfiguration agentNetworkConfiguration;
        @Nullable
        private NetworkConfiguration.EnvironmentConfiguration environmentConfiguration;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(NetworkConfiguration instance) {
            Objects.requireNonNull(instance, "instance");
            this.creationDate(instance.creationDate());
            this.agentNetworkConfiguration(instance.agentNetworkConfiguration());
            this.environmentConfiguration(instance.environmentConfiguration());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = Objects.requireNonNull(creationDate, "creationDate");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder agentNetworkConfiguration(NetworkConfiguration.AgentNetworkConfiguration agentNetworkConfiguration) {
            this.agentNetworkConfiguration = Objects.requireNonNull(agentNetworkConfiguration, "agentNetworkConfiguration");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder environmentConfiguration(NetworkConfiguration.EnvironmentConfiguration environmentConfiguration) {
            this.environmentConfiguration = Objects.requireNonNull(environmentConfiguration, "environmentConfiguration");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableNetworkConfiguration build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNetworkConfiguration(this.creationDate, this.agentNetworkConfiguration, this.environmentConfiguration);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("creationDate");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("agentNetworkConfiguration");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("environmentConfiguration");
            }
            return "Cannot build NetworkConfiguration, some of required attributes are not set " + attributes;
        }
    }
}

