/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.scenario.api.raw.mapper;

import com.chutneytesting.execution.domain.GwtScenarioMarshaller;
import com.chutneytesting.scenario.api.raw.dto.GwtScenarioDto;
import com.chutneytesting.scenario.api.raw.dto.GwtStepDto;
import com.chutneytesting.scenario.api.raw.dto.GwtStepImplementationDto;
import com.chutneytesting.scenario.api.raw.dto.ImmutableGwtScenarioDto;
import com.chutneytesting.scenario.api.raw.dto.ImmutableGwtStepDto;
import com.chutneytesting.scenario.api.raw.dto.ImmutableGwtStepImplementationDto;
import com.chutneytesting.scenario.api.raw.dto.StrategyDto;
import com.chutneytesting.scenario.domain.gwt.GwtScenario;
import com.chutneytesting.scenario.domain.gwt.GwtStep;
import com.chutneytesting.scenario.domain.gwt.GwtStepImplementation;
import com.chutneytesting.scenario.domain.gwt.Strategy;
import com.chutneytesting.server.core.domain.execution.ScenarioConversionException;
import com.chutneytesting.server.core.domain.scenario.ScenarioNotParsableException;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hjson.JsonValue;
import org.hjson.Stringify;
import org.springframework.stereotype.Component;

@Component
public class GwtScenarioMapper
implements GwtScenarioMarshaller {
    public static ObjectMapper mapper = new ObjectMapper().findAndRegisterModules().setSerializationInclusion(JsonInclude.Include.NON_EMPTY).setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY).setVisibility(PropertyAccessor.GETTER, JsonAutoDetect.Visibility.NONE).setVisibility(PropertyAccessor.SETTER, JsonAutoDetect.Visibility.NONE).setVisibility(PropertyAccessor.CREATOR, JsonAutoDetect.Visibility.NONE).addMixIn(GwtScenario.class, GwtScenarioMixin.class).addMixIn(GwtStep.class, GwtStepMixin.class).addMixIn(GwtStep.GwtStepBuilder.class, GwtStepBuilderMixin.class).addMixIn(GwtStepImplementation.class, GwtStepImplementationMixin.class).addMixIn(Strategy.class, StrategyMixin.class);

    public static GwtScenario fromDto(String title, String desc, GwtScenarioDto dto) {
        return GwtScenario.builder().withTitle(title).withDescription(desc).withGivens(dto.givens().stream().map(GwtScenarioMapper::fromDto).collect(Collectors.toList())).withWhen(GwtScenarioMapper.fromDto(dto.when())).withThens(dto.thens().stream().map(GwtScenarioMapper::fromDto).collect(Collectors.toList())).build();
    }

    private static GwtStep fromDto(GwtStepDto dto) {
        GwtStep.GwtStepBuilder builder = GwtStep.builder();
        dto.sentence().ifPresent(builder::withDescription);
        dto.xRef().ifPresent(builder::withXRef);
        builder.withSubSteps(dto.subSteps().stream().map(GwtScenarioMapper::fromDto).collect(Collectors.toList()));
        dto.implementation().ifPresent(i -> builder.withImplementation(GwtScenarioMapper.fromDto(i)));
        dto.strategy().ifPresent(s -> builder.withStrategy(new Strategy(s.getType(), s.getParameters())));
        return builder.build();
    }

    private static GwtStepImplementation fromDto(GwtStepImplementationDto dto) {
        if (dto.task().isEmpty()) {
            return new GwtStepImplementation(dto.type(), dto.target(), dto.inputs(), dto.outputs(), dto.validations(), dto.xRef());
        }
        try {
            return (GwtStepImplementation)mapper.readValue(JsonValue.readHjson((String)dto.task()).toString(), GwtStepImplementation.class);
        }
        catch (IOException e) {
            throw new ScenarioConversionException((Exception)e);
        }
    }

    public static GwtScenarioDto toDto(GwtScenario scenario) {
        return ImmutableGwtScenarioDto.builder().givens(GwtScenarioMapper.toDto(scenario.givens)).when(GwtScenarioMapper.toDto(scenario.when)).thens(GwtScenarioMapper.toDto(scenario.thens)).build();
    }

    private static List<GwtStepDto> toDto(List<GwtStep> givens) {
        return givens.stream().map(GwtScenarioMapper::toDto).collect(Collectors.toList());
    }

    private static GwtStepDto toDto(GwtStep step) {
        ImmutableGwtStepDto.Builder builder = ImmutableGwtStepDto.builder();
        builder.sentence(step.description);
        step.implementation.ifPresent(i -> builder.implementation(GwtScenarioMapper.toDto(i)));
        step.strategy.ifPresent(s -> builder.strategy(GwtScenarioMapper.toDto(s)));
        step.xRef.ifPresent(builder::xRef);
        builder.subSteps(GwtScenarioMapper.toDto(step.subSteps));
        return builder.build();
    }

    private static GwtStepImplementationDto toDto(GwtStepImplementation implementation) {
        try {
            return ImmutableGwtStepImplementationDto.builder().task(JsonValue.readHjson((String)mapper.writeValueAsString((Object)implementation)).toString(Stringify.HJSON)).type(implementation.type).target(implementation.target).xRef(implementation.xRef).inputs(implementation.inputs).outputs(implementation.outputs).build();
        }
        catch (Exception e) {
            throw new ScenarioNotParsableException("Cannot deserialize action implementation", e);
        }
    }

    private static StrategyDto toDto(Strategy strategy) {
        return new StrategyDto(strategy.type, strategy.parameters);
    }

    @Override
    public String serialize(GwtScenario scenario) {
        try {
            return mapper.writeValueAsString((Object)scenario);
        }
        catch (JsonProcessingException e) {
            throw new ScenarioNotParsableException("Cannot serialize scenario: " + e.getMessage(), (Exception)((Object)e));
        }
    }

    @Override
    public GwtScenario deserialize(String title, String description, String jsonScenario) {
        try {
            return (GwtScenario)mapper.readValue(jsonScenario, GwtScenario.class);
        }
        catch (IOException e) {
            throw new ScenarioNotParsableException("Cannot deserialize scenario: ", (Exception)e);
        }
    }

    private static class StrategyMixin {
        @JsonCreator
        public StrategyMixin(String type, Map<String, Object> parameters) {
        }
    }

    private static class GwtStepImplementationMixin {
        @JsonProperty(value="x-$ref")
        String xRef;

        @JsonCreator
        public GwtStepImplementationMixin(String type, String target, @JsonInclude(value=JsonInclude.Include.ALWAYS) Map<String, Object> inputs, Map<String, Object> outputs, Map<String, Object> validations, String xRef) {
        }
    }

    private static class GwtStepBuilderMixin {
        @JsonProperty(value="x-$ref")
        String xRef;

        private GwtStepBuilderMixin() {
        }
    }

    @JsonDeserialize(builder=GwtStep.GwtStepBuilder.class)
    private static class GwtStepMixin {
        private GwtStepMixin() {
        }
    }

    @JsonDeserialize(builder=GwtScenario.GwtScenarioBuilder.class)
    private static class GwtScenarioMixin {
        private GwtScenarioMixin() {
        }
    }
}

