/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.execution.infra.storage;

import com.chutneytesting.execution.infra.storage.ExecutionRowMapper;
import com.chutneytesting.execution.infra.storage.ExecutionSummaryRowMapper;
import com.chutneytesting.server.core.domain.execution.history.ExecutionHistory;
import com.chutneytesting.server.core.domain.execution.history.ExecutionHistoryRepository;
import com.chutneytesting.server.core.domain.execution.history.ImmutableExecutionHistory;
import com.chutneytesting.server.core.domain.execution.report.ReportNotFoundException;
import com.chutneytesting.server.core.domain.execution.report.ServerReportStatus;
import com.google.common.collect.ImmutableMap;
import java.time.ZoneId;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Component;

@Component
class DatabaseExecutionHistoryRepository
implements ExecutionHistoryRepository {
    private static final int LIMIT_BLOC_SIZE = 20;
    private final ExecutionRowMapper executionRowMapper = new ExecutionRowMapper();
    private final ExecutionSummaryRowMapper executionSummaryRowMapper = new ExecutionSummaryRowMapper();
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    DatabaseExecutionHistoryRepository(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }

    public List<ExecutionHistory.ExecutionSummary> getExecutions(String scenarioId) {
        return this.namedParameterJdbcTemplate.query("SELECT SCENARIO_HIST.ID, SCENARIO_HIST.EXECUTION_TIME, SCENARIO_HIST.DURATION, SCENARIO_HIST.STATUS, SCENARIO_HIST.INFORMATION, SCENARIO_HIST.ERROR, SCENARIO_HIST.TEST_CASE_TITLE, SCENARIO_HIST.ENVIRONMENT,SCENARIO_HIST.DATASET_ID, SCENARIO_HIST.DATASET_VERSION, SCENARIO_HIST.USER_ID, CAMP.TITLE AS CAMPAIGN_TITLE, CAMP.ID AS CAMPAIGN_ID, CAMP_HIST.ID AS CAMPAIGN_EXECUTION_ID FROM SCENARIO_EXECUTION_HISTORY SCENARIO_HIST LEFT JOIN CAMPAIGN_EXECUTION_HISTORY CAMP_HIST ON CAMP_HIST.SCENARIO_EXECUTION_ID = SCENARIO_HIST.ID LEFT JOIN CAMPAIGN CAMP ON CAMP.ID = CAMP_HIST .CAMPAIGN_ID WHERE SCENARIO_HIST.SCENARIO_ID = :scenarioId ORDER BY SCENARIO_HIST.ID DESC LIMIT 20", (Map)ImmutableMap.builder().put((Object)"scenarioId", (Object)scenarioId).build(), (RowMapper)this.executionSummaryRowMapper);
    }

    public ExecutionHistory.ExecutionSummary getExecutionSummary(Long executionId) {
        try {
            return (ExecutionHistory.ExecutionSummary)this.namedParameterJdbcTemplate.queryForObject("SELECT SCENARIO_HIST.ID, SCENARIO_HIST.EXECUTION_TIME, SCENARIO_HIST.DURATION, SCENARIO_HIST.STATUS, SCENARIO_HIST.INFORMATION, SCENARIO_HIST.ERROR, SCENARIO_HIST.TEST_CASE_TITLE, SCENARIO_HIST.ENVIRONMENT,SCENARIO_HIST.DATASET_ID, SCENARIO_HIST.DATASET_VERSION, SCENARIO_HIST.USER_ID, CAMP.TITLE AS CAMPAIGN_TITLE, CAMP.ID AS CAMPAIGN_ID, CAMP_HIST.ID AS CAMPAIGN_EXECUTION_ID FROM SCENARIO_EXECUTION_HISTORY SCENARIO_HIST LEFT JOIN CAMPAIGN_EXECUTION_HISTORY CAMP_HIST ON CAMP_HIST.SCENARIO_EXECUTION_ID = SCENARIO_HIST.ID LEFT JOIN CAMPAIGN CAMP ON CAMP.ID = CAMP_HIST .CAMPAIGN_ID WHERE SCENARIO_HIST.ID = :executionId", (Map)ImmutableMap.builder().put((Object)"executionId", (Object)executionId).build(), (RowMapper)this.executionSummaryRowMapper);
        }
        catch (EmptyResultDataAccessException e) {
            throw new ReportNotFoundException(executionId);
        }
    }

    public ExecutionHistory.Execution store(String scenarioId, ExecutionHistory.DetachedExecution detachedExecution) throws IllegalStateException {
        long nextId = (Long)this.namedParameterJdbcTemplate.queryForObject("SELECT nextval('SCENARIO_EXECUTION_HISTORY_SEQ')", Collections.emptyMap(), Long.TYPE);
        ExecutionHistory.Execution execution = detachedExecution.attach(nextId);
        Map<String, Object> executionParameters = this.executionParameters(execution);
        executionParameters.put("scenarioId", scenarioId);
        executionParameters.put("id", nextId);
        this.namedParameterJdbcTemplate.update("INSERT INTO SCENARIO_EXECUTION_HISTORY(ID, SCENARIO_ID, EXECUTION_TIME, DURATION, STATUS, INFORMATION, ERROR, REPORT, TEST_CASE_TITLE, ENVIRONMENT, DATASET_ID, DATASET_VERSION, USER_ID) VALUES (:id, :scenarioId, :executionTime, :duration, :status, :information, :error, :report, :title, :environment, :datasetId, :datasetVersion, :user)", executionParameters);
        return ImmutableExecutionHistory.Execution.builder().from(execution).executionId(Long.valueOf(nextId)).build();
    }

    public ExecutionHistory.Execution getExecution(String scenarioId, Long reportId) throws ReportNotFoundException {
        try {
            return (ExecutionHistory.Execution)this.namedParameterJdbcTemplate.queryForObject("SELECT ID, EXECUTION_TIME, DURATION, STATUS, INFORMATION, ERROR, REPORT, TEST_CASE_TITLE, ENVIRONMENT, DATASET_ID, DATASET_VERSION, USER_ID FROM SCENARIO_EXECUTION_HISTORY WHERE ID = :reportId AND SCENARIO_ID = :scenarioId", (Map)ImmutableMap.builder().put((Object)"reportId", (Object)reportId).put((Object)"scenarioId", (Object)scenarioId).build(), (RowMapper)this.executionRowMapper);
        }
        catch (EmptyResultDataAccessException e) {
            throw new ReportNotFoundException(scenarioId, reportId);
        }
    }

    public void update(String scenarioId, ExecutionHistory.Execution updatedExecution) throws ReportNotFoundException {
        int updatedEntries = this.update(updatedExecution);
        if (updatedEntries == 0) {
            throw new ReportNotFoundException(scenarioId, updatedExecution.executionId());
        }
    }

    private int update(ExecutionHistory.Execution updatedExecution) throws ReportNotFoundException {
        Map<String, Object> executionParameters = this.executionParameters(updatedExecution);
        executionParameters.put("id", updatedExecution.executionId());
        return this.namedParameterJdbcTemplate.update("UPDATE SCENARIO_EXECUTION_HISTORY SET EXECUTION_TIME = :executionTime, DURATION = :duration, STATUS = :status, INFORMATION = :information, ERROR = :error, REPORT = :report WHERE ID = :id", executionParameters);
    }

    public int setAllRunningExecutionsToKO() {
        List<ExecutionHistory.ExecutionSummary> runningExecutions = this.getExecutionsWithStatus(ServerReportStatus.RUNNING);
        this.updateExecutionsToKO(runningExecutions);
        List<ExecutionHistory.ExecutionSummary> pausedExecutions = this.getExecutionsWithStatus(ServerReportStatus.PAUSED);
        this.updateExecutionsToKO(pausedExecutions);
        return runningExecutions.size() + pausedExecutions.size();
    }

    public List<ExecutionHistory.ExecutionSummary> getExecutionsWithStatus(ServerReportStatus status) {
        return this.namedParameterJdbcTemplate.query("SELECT ID, EXECUTION_TIME, DURATION, STATUS, INFORMATION, ERROR, TEST_CASE_TITLE, ENVIRONMENT, DATASET_ID, DATASET_VERSION, USER_ID FROM SCENARIO_EXECUTION_HISTORY WHERE STATUS = :status", (Map)ImmutableMap.builder().put((Object)"status", (Object)status.name()).build(), (RowMapper)this.executionSummaryRowMapper);
    }

    private void updateExecutionsToKO(List<ExecutionHistory.ExecutionSummary> executions) {
        executions.stream().map(this::buildKnockoutExecutionFrom).forEach(this::update);
    }

    private ImmutableExecutionHistory.Execution buildKnockoutExecutionFrom(ExecutionHistory.ExecutionSummary executionSummary) {
        return ImmutableExecutionHistory.Execution.builder().executionId(executionSummary.executionId()).status(ServerReportStatus.FAILURE).time(executionSummary.time()).duration(executionSummary.duration()).info(executionSummary.info()).error("Execution was interrupted !").report("").testCaseTitle(executionSummary.testCaseTitle()).environment(executionSummary.environment()).user(executionSummary.user()).build();
    }

    private Map<String, Object> executionParameters(ExecutionHistory.Execution execution) {
        HashMap<String, Object> executionParameters = new HashMap<String, Object>();
        executionParameters.put("executionTime", execution.time().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
        executionParameters.put("duration", execution.duration());
        executionParameters.put("status", execution.status().name());
        executionParameters.put("information", execution.info().map(info -> StringUtils.substring((String)info, (int)0, (int)512)).orElse(null));
        executionParameters.put("error", execution.error().map(error -> StringUtils.substring((String)error, (int)0, (int)512)).orElse(null));
        executionParameters.put("report", execution.report());
        executionParameters.put("title", execution.testCaseTitle());
        executionParameters.put("environment", execution.environment());
        executionParameters.put("datasetId", execution.datasetId().orElse(null));
        executionParameters.put("datasetVersion", execution.datasetVersion().orElse(null));
        executionParameters.put("user", execution.user());
        return executionParameters;
    }
}

