/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.admin.infra;

import com.chutneytesting.admin.domain.Backup;
import com.chutneytesting.admin.domain.BackupNotFoundException;
import com.chutneytesting.admin.domain.BackupRepository;
import com.chutneytesting.agent.domain.explore.CurrentNetworkDescription;
import com.chutneytesting.component.scenario.infra.orient.OrientComponentDB;
import com.chutneytesting.environment.api.EmbeddedEnvironmentApi;
import com.chutneytesting.environment.api.EnvironmentApi;
import com.chutneytesting.environment.api.dto.EnvironmentDto;
import com.chutneytesting.jira.domain.JiraRepository;
import com.chutneytesting.server.core.domain.admin.Backupable;
import com.chutneytesting.server.core.domain.globalvar.GlobalvarRepository;
import com.chutneytesting.tools.Try;
import com.chutneytesting.tools.ZipUtils;
import com.chutneytesting.tools.file.FileUtils;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.FileSystemUtils;

@Component
public class FileSystemBackupRepository
implements BackupRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSystemBackupRepository.class);
    static final Path ROOT_DIRECTORY_NAME = Paths.get("backups", "zip");
    static final String ENVIRONMENTS_BACKUP_NAME = "environments.zip";
    static final String AGENTS_BACKUP_NAME = "agents.zip";
    static final String GLOBAL_VARS_BACKUP_NAME = "globalvars.zip";
    static final String COMPONENTS_BACKUP_NAME = "orient.zip";
    static final String JIRA_BACKUP_NAME = "jiralinks.zip";
    private final Path backupsRootPath;
    private final OrientComponentDB orientComponentDB;
    private final EnvironmentApi embeddedEnvironmentApi;
    private final GlobalvarRepository globalvarRepository;
    private final CurrentNetworkDescription currentNetworkDescription;
    private final JiraRepository jiraRepository;
    private final ObjectMapper om = new ObjectMapper().findAndRegisterModules().disable(new JsonGenerator.Feature[]{JsonGenerator.Feature.AUTO_CLOSE_TARGET}).enable(SerializationFeature.INDENT_OUTPUT).setSerializationInclusion(JsonInclude.Include.NON_EMPTY);

    public FileSystemBackupRepository(@Value(value="${chutney.configuration-folder:~/.chutney/conf}") String backupsRootPath, OrientComponentDB orientComponentDB, EmbeddedEnvironmentApi embeddedEnvironmentApi, GlobalvarRepository globalvarRepository, CurrentNetworkDescription currentNetworkDescription, JiraRepository jiraRepository) {
        this.backupsRootPath = Paths.get(backupsRootPath, new String[0]).resolve(ROOT_DIRECTORY_NAME).toAbsolutePath();
        FileUtils.initFolder((Path)this.backupsRootPath);
        this.orientComponentDB = orientComponentDB;
        this.embeddedEnvironmentApi = embeddedEnvironmentApi;
        this.globalvarRepository = globalvarRepository;
        this.currentNetworkDescription = currentNetworkDescription;
        this.jiraRepository = jiraRepository;
    }

    @Override
    public void getBackupData(String backupId, OutputStream outputStream) throws IOException {
        Path backupPath = this.backupsRootPath.resolve(backupId);
        try (ZipOutputStream zipOutPut = new ZipOutputStream(new BufferedOutputStream(outputStream, 4096));){
            ZipUtils.compressDirectoryToZipfile(backupPath.getParent(), Paths.get(backupId, new String[0]), zipOutPut);
        }
        catch (FileNotFoundException fnfe) {
            throw new BackupNotFoundException(backupId);
        }
    }

    @Override
    public String save(Backup backup) {
        String backupId = backup.id();
        LOGGER.info("Backup [{}] initiating", (Object)backupId);
        Path backupPath = this.backupsRootPath.resolve(backupId);
        Try.exec(() -> Files.createDirectory(backupPath, new FileAttribute[0])).runtime();
        if (backup.environments) {
            this.backup(backupPath.resolve(ENVIRONMENTS_BACKUP_NAME), "environments", this::backupEnvironments);
        }
        if (backup.agentsNetwork) {
            this.backup(this.currentNetworkDescription, backupPath.resolve(AGENTS_BACKUP_NAME), "agents network");
        }
        if (backup.globalVars) {
            this.backup((Backupable)this.globalvarRepository, backupPath.resolve(GLOBAL_VARS_BACKUP_NAME), "global vars");
        }
        if (backup.components) {
            this.backup(backupPath.resolve(COMPONENTS_BACKUP_NAME), "orient", this::backupOrient);
        }
        if (backup.jiraLinks) {
            this.backup(backupPath.resolve(JIRA_BACKUP_NAME), "jira links", this::backupJira);
        }
        LOGGER.info("Backup [{}] completed", (Object)backupId);
        return backup.id();
    }

    @Override
    public Backup read(String backupId) {
        Path backupPath = this.backupsRootPath.resolve(backupId);
        if (backupPath.toFile().exists()) {
            try {
                return new Backup(backupId, backupPath.resolve(AGENTS_BACKUP_NAME).toFile().exists(), backupPath.resolve(ENVIRONMENTS_BACKUP_NAME).toFile().exists(), backupPath.resolve(COMPONENTS_BACKUP_NAME).toFile().exists(), backupPath.resolve(GLOBAL_VARS_BACKUP_NAME).toFile().exists(), backupPath.resolve(JIRA_BACKUP_NAME).toFile().exists());
            }
            catch (RuntimeException re) {
                throw new BackupNotFoundException(backupId);
            }
        }
        throw new BackupNotFoundException(backupId);
    }

    @Override
    public void delete(String backupId) {
        Path backupPath = this.backupsRootPath.resolve(backupId);
        if (!Files.exists(backupPath, new LinkOption[0])) {
            throw new BackupNotFoundException(backupId);
        }
        Try.exec(() -> FileSystemUtils.deleteRecursively((Path)backupPath)).runtime();
        LOGGER.info("Backup [{}] deleted", (Object)backupId);
    }

    @Override
    public List<Backup> list() {
        ArrayList<Backup> backups = new ArrayList<Backup>();
        FileUtils.doOnListFiles((Path)this.backupsRootPath, pathStream -> {
            pathStream.forEach(path -> {
                try {
                    backups.add(this.read(path.getFileName().toString()));
                }
                catch (BackupNotFoundException bnfe) {
                    LOGGER.warn("Ignoring unparsable backup [{}]", (Object)path.getFileName().toString(), (Object)bnfe);
                }
            });
            return Void.TYPE;
        });
        backups.sort(Comparator.comparing(b -> ((Backup)b).time).reversed());
        return backups;
    }

    private void backup(Backupable backupable, Path backupPath, String backupName) {
        this.backup(backupPath, backupName, arg_0 -> ((Backupable)backupable).backup(arg_0));
    }

    private void backup(Path backupPath, String backupName, Consumer<OutputStream> backupInStream) {
        try (OutputStream outputStream = Files.newOutputStream(backupPath, new OpenOption[0]);){
            backupInStream.accept(outputStream);
        }
        catch (Exception e) {
            LOGGER.error("Cannot backup [{}]", (Object)backupName, (Object)e);
        }
        LOGGER.info("Backup [{}] completed", (Object)backupName);
    }

    private void backupEnvironments(OutputStream outputStream) {
        try (ZipOutputStream zipOutPut = new ZipOutputStream(new BufferedOutputStream(outputStream, 4096));){
            for (EnvironmentDto env : this.embeddedEnvironmentApi.listEnvironments()) {
                zipOutPut.putNextEntry(new ZipEntry(env.name + ".json"));
                this.om.writeValue((OutputStream)zipOutPut, (Object)env);
            }
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
    }

    private void backupJira(OutputStream outputStream) {
        Path fp;
        Optional<Path> folderPath = Optional.ofNullable(this.jiraRepository.getFolderPath());
        if (folderPath.isPresent() && StringUtils.isNotBlank((CharSequence)(fp = folderPath.get()).toString())) {
            try (ZipOutputStream zipOutPut = new ZipOutputStream(new BufferedOutputStream(outputStream, 4096));){
                ZipUtils.compressDirectoryToZipfile(fp.getParent(), fp.getFileName(), zipOutPut);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private void backupOrient(OutputStream outputStream) {
        this.orientComponentDB.backup(outputStream);
    }
}

