/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.security.infra.ldap.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.SocketFactory;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class CustomSSLSocketFactory
extends SSLSocketFactory {
    private static SSLSocketFactory theFactory;
    private final SSLSocketFactory defaultFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();

    public static synchronized SocketFactory getDefault() {
        if (theFactory == null) {
            theFactory = new CustomSSLSocketFactory();
        }
        return theFactory;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.defaultFactory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.defaultFactory.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
        return this.updateProtocol((SSLSocket)this.defaultFactory.createSocket(socket, host, port, autoClose));
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        return this.updateProtocol((SSLSocket)this.defaultFactory.createSocket(host, port));
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        return this.updateProtocol((SSLSocket)this.defaultFactory.createSocket(host, port, localHost, localPort));
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        return this.updateProtocol((SSLSocket)this.defaultFactory.createSocket(host, port));
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.updateProtocol((SSLSocket)this.defaultFactory.createSocket(address, port, localAddress, localPort));
    }

    private SSLSocket updateProtocol(SSLSocket socket) {
        SSLParameters params = new SSLParameters();
        params.setProtocols(new String[]{"TLSv1.1"});
        socket.setSSLParameters(params);
        return socket;
    }
}

