/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.security.infra.ldap;

import com.chutneytesting.security.api.UserDto;
import com.chutneytesting.security.domain.AuthenticationService;
import com.chutneytesting.security.infra.ldap.LdapAttributesProperties;
import com.chutneytesting.server.core.domain.security.Authorization;
import com.chutneytesting.server.core.domain.security.Role;
import com.chutneytesting.server.core.domain.security.RoleNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ldap.core.AttributesMapper;

public class LdapAttributesMapper
implements AttributesMapper<UserDto> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LdapAttributesMapper.class);
    private final Pattern ldapGroupPattern;
    private final LdapAttributesProperties ldapAttributesProperties;
    private final AuthenticationService authenticationService;

    LdapAttributesMapper(LdapAttributesProperties ldapAttributesProperties, String ldapGroupsPattern, AuthenticationService authenticationService) {
        this.ldapGroupPattern = Pattern.compile(ldapGroupsPattern);
        this.ldapAttributesProperties = ldapAttributesProperties;
        this.authenticationService = authenticationService;
    }

    public UserDto mapFromAttributes(Attributes attributes) throws NamingException {
        UserDto user = new UserDto();
        user.setId(this.extractAttributeMonoValue(attributes.get(this.ldapAttributesProperties.getId())));
        user.setName(this.extractAttributeMonoValue(attributes.get(this.ldapAttributesProperties.getName())));
        user.setFirstname(this.extractAttributeMonoValue(attributes.get(this.ldapAttributesProperties.getFirstname())));
        user.setLastname(this.extractAttributeMonoValue(attributes.get(this.ldapAttributesProperties.getLastname())));
        user.setMail(this.extractAttributeMonoValue(attributes.get(this.ldapAttributesProperties.getMail())));
        List groups = this.extractAttributeMultiValue(attributes.get(this.ldapAttributesProperties.getGroups()));
        groups.stream().map(this::applyLdapGroupMatcher).filter(Objects::nonNull).forEach(user::addRole);
        return this.readRole(user);
    }

    private UserDto readRole(UserDto userDto) {
        UserDto dto = new UserDto(userDto);
        if (dto.getRoles().contains("ADMIN")) {
            Arrays.stream(Authorization.values()).map(Enum::name).forEach(dto::grantAuthority);
        } else {
            try {
                Role role = this.authenticationService.userRoleById(dto.getId());
                dto.addRole(role.name);
                role.authorizations.stream().map(Enum::name).forEach(dto::grantAuthority);
            }
            catch (RoleNotFoundException rnfe) {
                LOGGER.warn("User {} has no role defined", (Object)dto.getId());
                throw rnfe;
            }
        }
        return dto;
    }

    private String applyLdapGroupMatcher(String ldapGroup) {
        Matcher ldapGroupMatcher = this.ldapGroupPattern.matcher(ldapGroup);
        if (ldapGroupMatcher.matches()) {
            return ldapGroupMatcher.group(1);
        }
        return null;
    }

    private String extractAttributeMonoValue(Attribute attribute) throws NamingException {
        String value = null;
        if (attribute != null) {
            Object attrValue = attribute.get();
            value = attrValue instanceof String ? (String)attrValue : Objects.toString(attrValue);
        }
        return value;
    }

    private <T> List<T> extractAttributeMultiValue(Attribute attribute) throws NamingException {
        ArrayList values = new ArrayList();
        if (attribute != null) {
            NamingEnumeration<?> nameValues = attribute.getAll();
            while (nameValues.hasMoreElements()) {
                Object v = nameValues.nextElement();
                if (v == null) continue;
                values.add(v);
            }
        }
        return values;
    }
}

