/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.globalvar.api;

import com.chutneytesting.globalvar.infra.FileGlobalVarRepository;
import com.chutneytesting.server.core.domain.globalvar.GlobalvarRepository;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Set;
import org.hjson.JsonValue;
import org.hjson.Stringify;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin(origins={"*"})
@RequestMapping(value={"/api/ui/globalvar/v1"})
public class GlobalVarController {
    private final GlobalvarRepository globalVarRepository;

    public GlobalVarController(FileGlobalVarRepository globalVarRepository) {
        this.globalVarRepository = globalVarRepository;
    }

    @PreAuthorize(value="hasAuthority('GLOBAL_VAR_READ')")
    @GetMapping(path={""}, produces={"application/json"})
    public Set<String> list() {
        return this.globalVarRepository.list();
    }

    @PreAuthorize(value="hasAuthority('GLOBAL_VAR_WRITE')")
    @PostMapping(path={"/{fileName}"}, consumes={"application/json"}, produces={"application/json"})
    public void save(@PathVariable(value="fileName") String fileName, @RequestBody TextDto textContent) {
        try {
            this.globalVarRepository.saveFile(fileName, JsonValue.readHjson((String)textContent.getMessage()).toString(Stringify.HJSON));
        }
        catch (Exception e) {
            throw new RuntimeException("Not valid hjson", e);
        }
    }

    @PreAuthorize(value="hasAuthority('GLOBAL_VAR_WRITE')")
    @DeleteMapping(path={"/{fileName}"})
    public void delete(@PathVariable(value="fileName") String fileName) {
        this.globalVarRepository.deleteFile(fileName);
    }

    @PreAuthorize(value="hasAuthority('GLOBAL_VAR_READ')")
    @GetMapping(path={"/{fileName}"}, produces={"application/json"})
    public TextDto getFile(@PathVariable(value="fileName") String fileName) {
        return new TextDto(this.globalVarRepository.getFileContent(fileName));
    }

    public static class TextDto {
        private final String message;

        public TextDto(@JsonProperty(value="message") String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

