/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.campaign.infra;

import com.chutneytesting.campaign.infra.CampaignParameter;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
class CampaignParameterRepository {
    private final RowMapper<CampaignParameter> campaignParamaterRowMapper;
    private final NamedParameterJdbcTemplate uiNamedParameterJdbcTemplate;
    private static final String QUERY_FIND_CAMPAIGN_PARAMETERS = "SELECT CAMPAIGN_ID, PARAMETER, PARAMETER_VALUE FROM CAMPAIGN_PARAMETER WHERE CAMPAIGN_ID = :campaignId ORDER BY ID DESC";
    private static final String QUERY_SAVE_CAMPAIGN_PARAMETER = "INSERT INTO CAMPAIGN_PARAMETER(ID, CAMPAIGN_ID, PARAMETER, PARAMETER_VALUE) VALUES (:id, :campaignId, :parameter, :value)";

    CampaignParameterRepository(NamedParameterJdbcTemplate uiNamedParameterJdbcTemplate) {
        this.uiNamedParameterJdbcTemplate = uiNamedParameterJdbcTemplate;
        this.campaignParamaterRowMapper = (resultSet, i) -> {
            Long campaignId = resultSet.getLong(1);
            String parameter = resultSet.getString(2);
            String value = resultSet.getString(3);
            return new CampaignParameter(campaignId, parameter, value);
        };
    }

    List<CampaignParameter> findCampaignParameters(Long campaignId) {
        return this.uiNamedParameterJdbcTemplate.query(QUERY_FIND_CAMPAIGN_PARAMETERS, (Map)ImmutableMap.of((Object)"campaignId", (Object)campaignId), this.campaignParamaterRowMapper);
    }

    public void updateCampaignParameter(Long campaignId, Map<String, String> data) {
        this.clearAllCampaignParameters(campaignId);
        data.forEach((k, v) -> this.saveCampaignParameter(new CampaignParameter(campaignId, (String)k, (String)v)));
    }

    void clearAllCampaignParameters(Long campaignId) {
        this.uiNamedParameterJdbcTemplate.update("DELETE FROM CAMPAIGN_PARAMETER WHERE CAMPAIGN_ID = :campaignId", (Map)ImmutableMap.of((Object)"campaignId", (Object)campaignId));
    }

    private int saveCampaignParameter(CampaignParameter campaignParameter) {
        return this.uiNamedParameterJdbcTemplate.update(QUERY_SAVE_CAMPAIGN_PARAMETER, (Map)ImmutableMap.of((Object)"id", (Object)this.generateCampaignParameterId(), (Object)"campaignId", (Object)campaignParameter.campaignId, (Object)"parameter", (Object)campaignParameter.parameter, (Object)"value", (Object)(campaignParameter.value == null ? "" : campaignParameter.value)));
    }

    private Long generateCampaignParameterId() {
        return (Long)this.uiNamedParameterJdbcTemplate.queryForObject("SELECT nextval('CAMPAIGN_PARAMETER_SEQ')", Collections.emptyMap(), Long.class);
    }
}

