/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.tools;

import com.chutneytesting.tools.PaginationRequestParametersDto;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Immutable
public final class ImmutablePaginationRequestParametersDto
implements PaginationRequestParametersDto {
    private final Long start;
    private final Long limit;
    private static final int STAGE_INITIALIZING = -1;
    private static final int STAGE_UNINITIALIZED = 0;
    private static final int STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutablePaginationRequestParametersDto(Builder builder) {
        if (builder.start != null) {
            this.initShim.start(builder.start);
        }
        if (builder.limit != null) {
            this.initShim.limit(builder.limit);
        }
        this.start = this.initShim.start();
        this.limit = this.initShim.limit();
        this.initShim = null;
    }

    private ImmutablePaginationRequestParametersDto(Long start, Long limit) {
        this.start = start;
        this.limit = limit;
        this.initShim = null;
    }

    private Long startInitialize() {
        return PaginationRequestParametersDto.super.start();
    }

    private Long limitInitialize() {
        return PaginationRequestParametersDto.super.limit();
    }

    @Override
    @JsonProperty(value="start")
    public Long start() {
        InitShim shim = this.initShim;
        return shim != null ? shim.start() : this.start;
    }

    @Override
    @JsonProperty(value="limit")
    public Long limit() {
        InitShim shim = this.initShim;
        return shim != null ? shim.limit() : this.limit;
    }

    public final ImmutablePaginationRequestParametersDto withStart(Long value) {
        if (this.start.equals(value)) {
            return this;
        }
        Long newValue = Objects.requireNonNull(value, "start");
        return new ImmutablePaginationRequestParametersDto(newValue, this.limit);
    }

    public final ImmutablePaginationRequestParametersDto withLimit(Long value) {
        if (this.limit.equals(value)) {
            return this;
        }
        Long newValue = Objects.requireNonNull(value, "limit");
        return new ImmutablePaginationRequestParametersDto(this.start, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePaginationRequestParametersDto && this.equalTo((ImmutablePaginationRequestParametersDto)another);
    }

    private boolean equalTo(ImmutablePaginationRequestParametersDto another) {
        return this.start.equals(another.start) && this.limit.equals(another.limit);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.start.hashCode();
        h += (h << 5) + this.limit.hashCode();
        return h;
    }

    public String toString() {
        return "PaginationRequestParametersDto{start=" + this.start + ", limit=" + this.limit + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePaginationRequestParametersDto fromJson(Json json) {
        Builder builder = ImmutablePaginationRequestParametersDto.builder();
        if (json.start != null) {
            builder.start(json.start);
        }
        if (json.limit != null) {
            builder.limit(json.limit);
        }
        return builder.build();
    }

    public static ImmutablePaginationRequestParametersDto copyOf(PaginationRequestParametersDto instance) {
        if (instance instanceof ImmutablePaginationRequestParametersDto) {
            return (ImmutablePaginationRequestParametersDto)instance;
        }
        return ImmutablePaginationRequestParametersDto.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Long start;
        @Nullable
        private Long limit;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(PaginationRequestParametersDto instance) {
            Objects.requireNonNull(instance, "instance");
            this.start(instance.start());
            this.limit(instance.limit());
            return this;
        }

        @JsonProperty(value="start")
        @CanIgnoreReturnValue
        public final Builder start(Long start) {
            this.start = Objects.requireNonNull(start, "start");
            return this;
        }

        @JsonProperty(value="limit")
        @CanIgnoreReturnValue
        public final Builder limit(Long limit) {
            this.limit = Objects.requireNonNull(limit, "limit");
            return this;
        }

        public ImmutablePaginationRequestParametersDto build() {
            return new ImmutablePaginationRequestParametersDto(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements PaginationRequestParametersDto {
        @Nullable
        Long start;
        @Nullable
        Long limit;

        Json() {
        }

        @JsonProperty(value="start")
        public void setStart(Long start) {
            this.start = start;
        }

        @JsonProperty(value="limit")
        public void setLimit(Long limit) {
            this.limit = limit;
        }

        @Override
        public Long start() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long limit() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private Long start;
        private int startBuildStage;
        private Long limit;
        private int limitBuildStage;

        private InitShim() {
        }

        Long start() {
            if (this.startBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.startBuildStage == 0) {
                this.startBuildStage = -1;
                this.start = Objects.requireNonNull(ImmutablePaginationRequestParametersDto.this.startInitialize(), "start");
                this.startBuildStage = 1;
            }
            return this.start;
        }

        void start(Long start) {
            this.start = start;
            this.startBuildStage = 1;
        }

        Long limit() {
            if (this.limitBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.limitBuildStage == 0) {
                this.limitBuildStage = -1;
                this.limit = Objects.requireNonNull(ImmutablePaginationRequestParametersDto.this.limitInitialize(), "limit");
                this.limitBuildStage = 1;
            }
            return this.limit;
        }

        void limit(Long limit) {
            this.limit = limit;
            this.limitBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.startBuildStage == -1) {
                attributes.add("start");
            }
            if (this.limitBuildStage == -1) {
                attributes.add("limit");
            }
            return "Cannot build PaginationRequestParametersDto, attribute initializers form cycle" + attributes;
        }
    }
}

