/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.security.infra.memory;

import com.chutneytesting.security.infra.memory.InMemoryUsersProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class InMemoryUserDetailsService
implements UserDetailsService {
    private Map<String, UserDetails> users = new HashMap<String, UserDetails>();

    public InMemoryUserDetailsService(InMemoryUsersProperties inMemoryUsersProperties) {
        inMemoryUsersProperties.getUsers().forEach(user -> this.users.put(user.getUsername(), (UserDetails)user));
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        Optional<UserDetails> user = Optional.ofNullable(this.users.get(username));
        return user.orElseThrow(() -> new UsernameNotFoundException("Username not found."));
    }
}

