/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.security.infra.ldap;

import com.chutneytesting.security.domain.User;
import com.chutneytesting.security.infra.ldap.LdapAttributesProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.springframework.ldap.core.AttributesMapper;

public class LdapAttributesMapper
implements AttributesMapper<User> {
    private final Pattern ldapGroupPattern;
    private final LdapAttributesProperties ldapAttributesProperties;

    LdapAttributesMapper(LdapAttributesProperties ldapAttributesProperties, String ldapGroupsPattern) {
        this.ldapGroupPattern = Pattern.compile(ldapGroupsPattern);
        this.ldapAttributesProperties = ldapAttributesProperties;
    }

    public User mapFromAttributes(Attributes attributes) throws NamingException {
        User user = new User();
        user.setId(this.extractAttributeMonoValue(attributes.get(this.ldapAttributesProperties.getId())));
        user.setName(this.extractAttributeMonoValue(attributes.get(this.ldapAttributesProperties.getName())));
        user.setFirstname(this.extractAttributeMonoValue(attributes.get(this.ldapAttributesProperties.getFirstname())));
        user.setLastname(this.extractAttributeMonoValue(attributes.get(this.ldapAttributesProperties.getLastname())));
        user.setMail(this.extractAttributeMonoValue(attributes.get(this.ldapAttributesProperties.getMail())));
        List groups = this.extractAttributeMultiValue(attributes.get(this.ldapAttributesProperties.getGroups()));
        groups.stream().map(this::mapLdapGroupToProfile).filter(Objects::nonNull).forEach(s -> this.updateUserProfiles(user, (Profiles)((Object)s)));
        if (user.getProfiles() == null || user.getProfiles().isEmpty()) {
            user.grantAuthority("ANONYMOUS");
        }
        return user;
    }

    private void updateUserProfiles(User user, Profiles profile) {
        user.addProfile(profile.name());
        user.grantAuthority(profile.name());
    }

    private Profiles mapLdapGroupToProfile(String ldapGroup) {
        Matcher ldapGroupMatcher = this.ldapGroupPattern.matcher(ldapGroup);
        if (ldapGroupMatcher.matches()) {
            return Profiles.valueOf(ldapGroupMatcher.group(1));
        }
        return null;
    }

    private String extractAttributeMonoValue(Attribute attribute) throws NamingException {
        String value = null;
        if (attribute != null) {
            Object attrValue = attribute.get();
            value = attrValue instanceof String ? (String)attrValue : Objects.toString(attrValue);
        }
        return value;
    }

    private <T> List<T> extractAttributeMultiValue(Attribute attribute) throws NamingException {
        ArrayList values = new ArrayList();
        if (attribute != null) {
            NamingEnumeration<?> nameValues = attribute.getAll();
            while (nameValues.hasMoreElements()) {
                Object v = nameValues.nextElement();
                if (v == null) continue;
                values.add(v);
            }
        }
        return values;
    }

    private static enum Profiles {
        USER,
        ADMIN;

    }
}

