/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.security.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

public class User
implements UserDetails {
    public static final User ANONYMOUS_USER = new User();
    private static final String ROLE_PREFIX = "ROLE_";
    private String id;
    private String name;
    private String firstname;
    private String lastname;
    private String mail;
    @JsonIgnore
    private Set<String> profiles;
    private Set<GrantedAuthority> authorities;
    @JsonIgnore
    private String password;
    @JsonIgnore
    private boolean accountExpired = false;
    @JsonIgnore
    private boolean locked = false;
    @JsonIgnore
    private boolean credentialExpired = false;
    @JsonIgnore
    private boolean enabled = false;

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    public String getPassword() {
        return this.password;
    }

    @JsonIgnore
    public String getUsername() {
        return this.id;
    }

    @JsonIgnore
    public boolean isAccountNonExpired() {
        return !this.accountExpired;
    }

    @JsonIgnore
    public boolean isAccountNonLocked() {
        return !this.locked;
    }

    @JsonIgnore
    public boolean isCredentialsNonExpired() {
        return !this.credentialExpired;
    }

    @JsonIgnore
    public boolean isEnabled() {
        return !this.enabled;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFirstname() {
        return this.firstname;
    }

    public void setFirstname(String firstname) {
        this.firstname = firstname;
    }

    public String getLastname() {
        return this.lastname;
    }

    public void setLastname(String lastname) {
        this.lastname = lastname;
    }

    public String getMail() {
        return this.mail;
    }

    public void setMail(String mail) {
        this.mail = mail;
    }

    public Set<String> getProfiles() {
        return this.profiles;
    }

    public void setProfiles(Set<String> profiles) {
        this.profiles = profiles;
    }

    public void addProfile(String profile) {
        if (this.profiles == null) {
            this.profiles = new HashSet<String>();
        }
        this.profiles.add(profile);
    }

    public void grantAuthority(String authority) {
        if (this.authorities == null) {
            this.authorities = new HashSet<GrantedAuthority>();
        }
        this.authorities.add((GrantedAuthority)new SimpleGrantedAuthority(ROLE_PREFIX + authority));
    }

    public void setAccountExpired(boolean accountExpired) {
        this.accountExpired = accountExpired;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public void setCredentialExpired(boolean credentialExpired) {
        this.credentialExpired = credentialExpired;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public static boolean isAnonymous(String userId) {
        return userId == null || ANONYMOUS_USER.getId().equals(userId);
    }

    static {
        ANONYMOUS_USER.setId("guest");
        ANONYMOUS_USER.setName("guest");
    }
}

