/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.security;

import com.chutneytesting.security.infra.handlers.Http401FailureHandler;
import com.chutneytesting.security.infra.handlers.HttpEmptyLogoutSuccessHandler;
import com.chutneytesting.security.infra.handlers.HttpStatusInvalidSessionStrategy;
import com.chutneytesting.security.infra.memory.InMemoryConfiguration;
import com.chutneytesting.security.infra.memory.InMemoryUsersProperties;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.http.HttpStatus;
import org.springframework.ldap.core.support.BaseLdapPathContextSource;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ChannelSecurityConfigurer;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.ldap.authentication.NullLdapAuthoritiesPopulator;
import org.springframework.security.ldap.userdetails.LdapAuthoritiesPopulator;
import org.springframework.security.ldap.userdetails.UserDetailsContextMapper;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.HttpStatusEntryPoint;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.session.InvalidSessionStrategy;

@Configuration
@EnableWebSecurity
public class ChutneySecurityConfig
extends WebSecurityConfigurerAdapter {
    @Value(value="${server.servlet.session.cookie.http-only:true}")
    private boolean sessionCookieHttpOnly;
    @Value(value="${server.servlet.session.cookie.secure:true}")
    private boolean sessionCookieSecure;

    protected void configure(HttpSecurity http) throws Exception {
        this.configureBaseHttpSecurity(http);
        ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(new String[]{"/api/v1/user/login"})).permitAll().antMatchers(new String[]{"/api/v1/user/logout"})).permitAll().antMatchers(new String[]{"/api/**"})).authenticated().anyRequest()).permitAll().and()).httpBasic();
    }

    protected void configureBaseHttpSecurity(HttpSecurity http) throws Exception {
        HashMap<String, String> invalidSessionHeaders = new HashMap<String, String>();
        invalidSessionHeaders.put("Access-Control-Allow-Origin", "*");
        ((HttpSecurity)((FormLoginConfigurer)((FormLoginConfigurer)((HttpSecurity)((ChannelSecurityConfigurer.RequiresChannelUrl)((HttpSecurity)((HttpSecurity)((HttpSecurity)http.sessionManagement().invalidSessionStrategy((InvalidSessionStrategy)new HttpStatusInvalidSessionStrategy(HttpStatus.UNAUTHORIZED, invalidSessionHeaders, this.sessionCookieHttpOnly, this.sessionCookieSecure)).and()).csrf().disable()).exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)new HttpStatusEntryPoint(HttpStatus.UNAUTHORIZED)).and()).requiresChannel().anyRequest()).requiresSecure().and()).formLogin().loginProcessingUrl("/api/v1/user/login")).successForwardUrl("/api/v1/user").failureHandler((AuthenticationFailureHandler)new Http401FailureHandler())).and()).logout().logoutUrl("/api/v1/user/logout").logoutSuccessHandler((LogoutSuccessHandler)new HttpEmptyLogoutSuccessHandler());
    }

    @Configuration
    @Profile(value={"ldap-auth", "ldap-auth-tls1-1"})
    public static class SecSecurityLDAPConfig {
        @Autowired
        protected void configure(AuthenticationManagerBuilder auth, LdapContextSource ldapContextSource, UserDetailsContextMapper userDetailsContextMapper) throws Exception {
            auth.ldapAuthentication().userSearchFilter("(uid={0})").ldapAuthoritiesPopulator((LdapAuthoritiesPopulator)new NullLdapAuthoritiesPopulator()).userDetailsContextMapper(userDetailsContextMapper).contextSource((BaseLdapPathContextSource)ldapContextSource);
        }
    }

    @Configuration
    @Profile(value={"mem-auth"})
    public static class SecSecurityMemoryConfig {
        @Autowired
        InMemoryConfiguration inMemoryConfiguration;

        @Autowired
        protected void configure(AuthenticationManagerBuilder auth) throws Exception {
            InMemoryUsersProperties users = this.inMemoryConfiguration.users();
            PasswordEncoder passwordEncoder = this.inMemoryConfiguration.passwordEncoder();
            users.getUsers().forEach(user -> {
                user.setPassword(passwordEncoder.encode((CharSequence)user.getPassword()));
                user.getProfiles().forEach(user::grantAuthority);
            });
            auth.userDetailsService((UserDetailsService)this.inMemoryConfiguration.inMemoryUserDetailsService()).passwordEncoder(passwordEncoder);
        }
    }
}

