/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.instrument.infra;

import com.chutneytesting.design.domain.campaign.Campaign;
import com.chutneytesting.design.domain.campaign.CampaignExecutionReport;
import com.chutneytesting.design.domain.scenario.TestCase;
import com.chutneytesting.execution.domain.history.ExecutionHistory;
import com.chutneytesting.execution.domain.report.ServerReportStatus;
import com.chutneytesting.instrument.domain.ChutneyMetrics;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
class MicrometerMetrics
implements ChutneyMetrics {
    private final MeterRegistry meterRegistry;
    private final Map<String, Map<ServerReportStatus, AtomicLong>> statusCountCache = new HashMap<String, Map<ServerReportStatus, AtomicLong>>();

    MicrometerMetrics(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    @Override
    public void onScenarioExecutionEnded(TestCase testCase, ExecutionHistory.Execution execution) {
        String scenarioId = testCase.metadata().id();
        List<String> tags = testCase.metadata().tags();
        ServerReportStatus status = execution.status();
        long duration = execution.duration();
        String tagsAsString = StringUtils.join(tags, (String)"|");
        Counter scenarioExecutionCount = this.meterRegistry.counter("scenario_execution_count", Arrays.asList(Tag.of((String)"scenarioId", (String)scenarioId), Tag.of((String)"status", (String)status.name()), Tag.of((String)"tags", (String)tagsAsString)));
        scenarioExecutionCount.increment();
        Timer scenarioExecutionTimer = this.meterRegistry.timer("scenario_execution_timer", Arrays.asList(Tag.of((String)"scenarioId", (String)scenarioId), Tag.of((String)"status", (String)status.name()), Tag.of((String)"tags", (String)tagsAsString)));
        scenarioExecutionTimer.record(duration, TimeUnit.MILLISECONDS);
    }

    @Override
    public void onCampaignExecutionEnded(Campaign campaign, CampaignExecutionReport campaignExecutionReport) {
        String campaignId = campaign.id.toString();
        Map<ServerReportStatus, Long> scenarioCountByStatus = campaignExecutionReport.scenarioExecutionReports().stream().collect(Collectors.groupingBy(s -> s.execution.status(), Collectors.counting()));
        ServerReportStatus status = campaignExecutionReport.status();
        long campaignDuration = campaignExecutionReport.getDuration();
        Counter scenarioExecutionCount = this.meterRegistry.counter("campaign_execution_count", Arrays.asList(Tag.of((String)"campaignId", (String)campaignId), Tag.of((String)"campaignTitle", (String)campaign.title), Tag.of((String)"status", (String)status.name())));
        scenarioExecutionCount.increment();
        Timer scenarioExecutionTimer = this.meterRegistry.timer("campaign_execution_timer", Collections.singleton(Tag.of((String)"campaignId", (String)campaignId)));
        scenarioExecutionTimer.record(campaignDuration, TimeUnit.MILLISECONDS);
        Map<ServerReportStatus, AtomicLong> cachedMetrics = this.getMetricsInCache(campaignId);
        this.updateMetrics(scenarioCountByStatus, cachedMetrics);
    }

    private void updateMetrics(Map<ServerReportStatus, Long> scenarioCountByStatus, Map<ServerReportStatus, AtomicLong> cachedMetrics) {
        cachedMetrics.entrySet().stream().forEach(e -> {
            Long valueInCache = (Long)scenarioCountByStatus.get(e.getKey());
            if (valueInCache != null) {
                ((AtomicLong)e.getValue()).set(valueInCache);
            } else {
                ((AtomicLong)e.getValue()).set(0L);
            }
        });
    }

    private Map<ServerReportStatus, AtomicLong> getMetricsInCache(String campaignId) {
        Map<ServerReportStatus, AtomicLong> cachedMetrics = this.statusCountCache.get(campaignId);
        if (cachedMetrics == null) {
            Map<ServerReportStatus, AtomicLong> tmp = cachedMetrics = new HashMap<ServerReportStatus, AtomicLong>();
            Arrays.asList(ServerReportStatus.values()).stream().forEach(s -> {
                AtomicLong initialValue = new AtomicLong(0L);
                this.meterRegistry.gauge("scenario_in_campaign_gauge", Arrays.asList(Tag.of((String)"campaignId", (String)campaignId), Tag.of((String)"scenarioStatus", (String)s.name())), (Number)initialValue);
                tmp.put((ServerReportStatus)((Object)s), initialValue);
            });
            cachedMetrics.putAll(tmp);
            this.statusCountCache.put(campaignId, cachedMetrics);
        }
        return cachedMetrics;
    }
}

