/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.execution.infra.execution;

import com.chutneytesting.engine.api.execution.ExecutionRequestDto;
import com.chutneytesting.engine.api.execution.StepExecutionReportDto;
import com.chutneytesting.engine.api.execution.TestEngine;
import com.chutneytesting.execution.domain.ExecutionRequest;
import com.chutneytesting.execution.domain.report.StepExecutionReportCore;
import com.chutneytesting.execution.domain.scenario.ServerTestEngine;
import com.chutneytesting.execution.infra.execution.ExecutionRequestMapper;
import com.chutneytesting.execution.infra.execution.StepExecutionReportMapperCore;
import io.reactivex.Observable;
import org.apache.commons.lang3.tuple.Pair;

public class ServerTestEngineJavaImpl
implements ServerTestEngine {
    private final TestEngine executionEngine;
    private final ExecutionRequestMapper executionRequestMapper;

    public ServerTestEngineJavaImpl(TestEngine executionEngine, ExecutionRequestMapper executionRequestMapper) {
        this.executionEngine = executionEngine;
        this.executionRequestMapper = executionRequestMapper;
    }

    @Override
    public StepExecutionReportCore execute(ExecutionRequest executionRequest) {
        ExecutionRequestDto executionRequestDto = this.executionRequestMapper.toDto(executionRequest);
        StepExecutionReportDto stepExecutionReportDto = this.executionEngine.execute(executionRequestDto);
        return StepExecutionReportMapperCore.fromDto(stepExecutionReportDto);
    }

    @Override
    public Pair<Observable<StepExecutionReportCore>, Long> executeAndFollow(ExecutionRequest executionRequest) {
        ExecutionRequestDto executionRequestDto = this.executionRequestMapper.toDto(executionRequest);
        Long executionId = this.executionEngine.executeAsync(executionRequestDto);
        return Pair.of((Object)this.executionEngine.receiveNotification(executionId).map(StepExecutionReportMapperCore::fromDto), (Object)executionId);
    }

    @Override
    public void stop(Long executionHash) {
        this.executionEngine.stopExecution(executionHash);
    }

    @Override
    public void pause(Long executionHash) {
        this.executionEngine.pauseExecution(executionHash);
    }

    @Override
    public void resume(Long executionHash) {
        this.executionEngine.resumeExecution(executionHash);
    }
}

