/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.execution.infra.execution;

import com.chutneytesting.agent.domain.explore.CurrentNetworkDescription;
import com.chutneytesting.agent.domain.network.Agent;
import com.chutneytesting.agent.domain.network.NetworkDescription;
import com.chutneytesting.design.domain.scenario.gwt.GwtStep;
import com.chutneytesting.design.domain.scenario.gwt.GwtTestCase;
import com.chutneytesting.design.domain.scenario.gwt.Strategy;
import com.chutneytesting.design.domain.scenario.raw.RawTestCase;
import com.chutneytesting.engine.api.execution.CredentialExecutionDto;
import com.chutneytesting.engine.api.execution.ExecutionRequestDto;
import com.chutneytesting.engine.api.execution.SecurityInfoExecutionDto;
import com.chutneytesting.engine.api.execution.TargetExecutionDto;
import com.chutneytesting.engine.domain.delegation.NamedHostAndPort;
import com.chutneytesting.environment.api.EmbeddedEnvironmentApi;
import com.chutneytesting.environment.api.dto.NoTargetDto;
import com.chutneytesting.environment.api.dto.TargetDto;
import com.chutneytesting.execution.domain.ExecutionRequest;
import com.chutneytesting.execution.domain.compiler.ScenarioConversionException;
import com.chutneytesting.execution.domain.scenario.composed.ExecutableComposedStep;
import com.chutneytesting.execution.domain.scenario.composed.ExecutableComposedTestCase;
import com.chutneytesting.execution.infra.execution.ScenarioContent;
import com.chutneytesting.execution.infra.execution.UnmarshalledStepDefinition;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hjson.JsonValue;
import org.springframework.stereotype.Component;

@Component
public class ExecutionRequestMapper {
    private final ObjectMapper objectMapper;
    private final EmbeddedEnvironmentApi environmentApplication;
    private final CurrentNetworkDescription currentNetworkDescription;

    public ExecutionRequestMapper(ObjectMapper objectMapper, EmbeddedEnvironmentApi environmentApplication, CurrentNetworkDescription currentNetworkDescription) {
        this.objectMapper = objectMapper;
        this.environmentApplication = environmentApplication;
        this.currentNetworkDescription = currentNetworkDescription;
    }

    public ExecutionRequestDto toDto(ExecutionRequest executionRequest) {
        ExecutionRequestDto.StepDefinitionRequestDto stepDefinitionRequestDto = this.convertToStepDef(executionRequest);
        return new ExecutionRequestDto(stepDefinitionRequestDto);
    }

    private ExecutionRequestDto.StepDefinitionRequestDto convertToStepDef(ExecutionRequest executionRequest) {
        if (executionRequest.testCase instanceof RawTestCase) {
            return this.convertRaw(executionRequest);
        }
        if (executionRequest.testCase instanceof GwtTestCase) {
            return this.convertGwt(executionRequest);
        }
        if (executionRequest.testCase instanceof ExecutableComposedTestCase) {
            return this.convertComposed(executionRequest);
        }
        throw new ScenarioConversionException(executionRequest.testCase.metadata().id(), "Cannot create an executable StepDefinition from a " + executionRequest.testCase.getClass().getCanonicalName());
    }

    private ExecutionRequestDto.StepDefinitionRequestDto convertRaw(ExecutionRequest executionRequest) {
        RawTestCase rawTestCase = (RawTestCase)executionRequest.testCase;
        try {
            ScenarioContent scenarioContent = (ScenarioContent)this.objectMapper.readValue(JsonValue.readHjson((String)rawTestCase.content).toString(), ScenarioContent.class);
            return this.getStepDefinitionRequestFromStepDef(scenarioContent.scenario, executionRequest.environment);
        }
        catch (IOException e) {
            throw new ScenarioConversionException(rawTestCase.metadata().id(), e);
        }
    }

    private ExecutionRequestDto.StepDefinitionRequestDto getStepDefinitionRequestFromStepDef(UnmarshalledStepDefinition definition, String env) {
        ExecutionRequestDto.StepStrategyDefinitionRequestDto retryStrategy = Optional.ofNullable(definition.strategy).map(s -> new ExecutionRequestDto.StepStrategyDefinitionRequestDto(s.type, s.parameters)).orElse(null);
        List steps = definition.steps.stream().map(d -> this.getStepDefinitionRequestFromStepDef((UnmarshalledStepDefinition)d, env)).collect(Collectors.toList());
        return new ExecutionRequestDto.StepDefinitionRequestDto(definition.name, this.toExecutionTargetDto(this.getTargetForExecution(env, definition.target), env), retryStrategy, definition.type, definition.inputs, steps, definition.outputs, env);
    }

    private ExecutionRequestDto.StepDefinitionRequestDto convertGwt(ExecutionRequest executionRequest) {
        GwtTestCase gwtTestCase = (GwtTestCase)executionRequest.testCase;
        return new ExecutionRequestDto.StepDefinitionRequestDto(gwtTestCase.metadata.title, null, null, null, Collections.emptyMap(), this.convert(gwtTestCase.scenario.steps(), executionRequest.environment), Collections.emptyMap(), executionRequest.environment);
    }

    private List<ExecutionRequestDto.StepDefinitionRequestDto> convert(List<GwtStep> steps, String env) {
        return steps.stream().map(s -> this.convert((GwtStep)s, env)).collect(Collectors.toList());
    }

    private ExecutionRequestDto.StepDefinitionRequestDto convert(GwtStep step, String env) {
        return new ExecutionRequestDto.StepDefinitionRequestDto(step.description, step.implementation.map(i -> this.toExecutionTargetDto(this.getTargetForExecution(env, i.target), env)).orElse(this.toExecutionTargetDto(NoTargetDto.NO_TARGET_DTO, env)), (ExecutionRequestDto.StepStrategyDefinitionRequestDto)step.strategy.map(this::mapStrategy).orElse(null), step.implementation.map(i -> i.type).orElse(""), step.implementation.map(i -> i.inputs).orElse(Collections.emptyMap()), this.convert(step.subSteps, env), step.implementation.map(i -> i.outputs).orElse(Collections.emptyMap()), env);
    }

    private ExecutionRequestDto.StepStrategyDefinitionRequestDto mapStrategy(Strategy strategy) {
        return new ExecutionRequestDto.StepStrategyDefinitionRequestDto(strategy.type, strategy.parameters);
    }

    private ExecutionRequestDto.StepStrategyDefinitionRequestDto mapStrategy(com.chutneytesting.design.domain.scenario.compose.Strategy strategy) {
        return new ExecutionRequestDto.StepStrategyDefinitionRequestDto(strategy.type, strategy.parameters);
    }

    private TargetExecutionDto toExecutionTargetDto(TargetDto targetDto, String env) {
        if (targetDto == null || NoTargetDto.NO_TARGET_DTO.equals(targetDto)) {
            targetDto = NoTargetDto.NO_TARGET_DTO;
        }
        return new TargetExecutionDto(targetDto.name, targetDto.url, targetDto.propertiesToMap(), ExecutionRequestMapper.toSecurityInfoDto(targetDto), this.getAgents(targetDto, env));
    }

    private static SecurityInfoExecutionDto toSecurityInfoDto(TargetDto targetDto) {
        return new SecurityInfoExecutionDto(ExecutionRequestMapper.toCredentialDto(targetDto), null, null, targetDto.keyStore, targetDto.keyStorePassword, targetDto.privateKey);
    }

    private static CredentialExecutionDto toCredentialDto(TargetDto targetDto) {
        if (targetDto.hasCredential()) {
            return new CredentialExecutionDto(targetDto.username, targetDto.password);
        }
        return null;
    }

    private ExecutionRequestDto.StepDefinitionRequestDto convertComposed(ExecutionRequest executionRequest) {
        ExecutableComposedTestCase composedTestCase = (ExecutableComposedTestCase)executionRequest.testCase;
        try {
            return new ExecutionRequestDto.StepDefinitionRequestDto(composedTestCase.metadata.title(), this.toExecutionTargetDto(NoTargetDto.NO_TARGET_DTO, executionRequest.environment), null, null, null, this.convertComposedSteps(composedTestCase.composedScenario.composedSteps, executionRequest.environment), null, executionRequest.environment);
        }
        catch (Exception e) {
            throw new ScenarioConversionException(composedTestCase.metadata().id(), e);
        }
    }

    private List<ExecutionRequestDto.StepDefinitionRequestDto> convertComposedSteps(List<ExecutableComposedStep> composedSteps, String env) {
        return composedSteps.stream().map(f -> this.convert((ExecutableComposedStep)f, env)).collect(Collectors.toList());
    }

    private ExecutionRequestDto.StepDefinitionRequestDto convert(ExecutableComposedStep composedStep, String env) {
        return new ExecutionRequestDto.StepDefinitionRequestDto(composedStep.name, this.toExecutionTargetDto(this.getTargetForExecution(env, composedStep.stepImplementation.map(si -> si.target).orElse("")), env), this.mapStrategy(composedStep.strategy), composedStep.stepImplementation.map(si -> si.type).orElse(""), composedStep.stepImplementation.map(si -> si.inputs).orElse(Collections.emptyMap()), composedStep.steps.stream().map(f -> this.convert((ExecutableComposedStep)f, env)).collect(Collectors.toList()), composedStep.stepImplementation.map(si -> si.outputs).orElse(Collections.emptyMap()), env);
    }

    private TargetDto getTargetForExecution(String environmentName, String targetName) {
        if (StringUtils.isBlank((CharSequence)targetName)) {
            return NoTargetDto.NO_TARGET_DTO;
        }
        return this.environmentApplication.getTarget(environmentName, targetName);
    }

    private List<NamedHostAndPort> getAgents(TargetDto targetDto, String env) {
        List<Object> nhaps = Collections.emptyList();
        Optional<NetworkDescription> networkDescription = this.currentNetworkDescription.findCurrent();
        if (networkDescription.isPresent() && networkDescription.get().localAgent().isPresent()) {
            Agent localAgent = networkDescription.get().localAgent().get();
            List<Agent> agents = localAgent.findFellowAgentForReaching(targetDto.name, env);
            nhaps = agents.stream().map(a -> a.agentInfo).collect(Collectors.toList());
        }
        return nhaps;
    }
}

