/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.execution.domain.state;

import com.chutneytesting.execution.domain.state.RunningScenarioState;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Immutable
public final class ImmutableRunningScenarioState
implements RunningScenarioState {
    private final String scenarioId;
    private final Instant startTime;

    private ImmutableRunningScenarioState(String scenarioId) {
        this.scenarioId = Objects.requireNonNull(scenarioId, "scenarioId");
        this.startTime = Objects.requireNonNull(RunningScenarioState.super.startTime(), "startTime");
    }

    private ImmutableRunningScenarioState(ImmutableRunningScenarioState original, String scenarioId) {
        this.scenarioId = scenarioId;
        this.startTime = Objects.requireNonNull(RunningScenarioState.super.startTime(), "startTime");
    }

    @Override
    public String scenarioId() {
        return this.scenarioId;
    }

    @Override
    public Instant startTime() {
        return this.startTime;
    }

    public final ImmutableRunningScenarioState withScenarioId(String value) {
        if (this.scenarioId.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "scenarioId");
        return new ImmutableRunningScenarioState(this, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRunningScenarioState && this.equalTo((ImmutableRunningScenarioState)another);
    }

    private boolean equalTo(ImmutableRunningScenarioState another) {
        return this.scenarioId.equals(another.scenarioId) && this.startTime.equals(another.startTime);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.scenarioId.hashCode();
        h += (h << 5) + this.startTime.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RunningScenarioState").omitNullValues().add("scenarioId", (Object)this.scenarioId).add("startTime", (Object)this.startTime).toString();
    }

    public static ImmutableRunningScenarioState of(String scenarioId) {
        return new ImmutableRunningScenarioState(scenarioId);
    }

    public static ImmutableRunningScenarioState copyOf(RunningScenarioState instance) {
        if (instance instanceof ImmutableRunningScenarioState) {
            return (ImmutableRunningScenarioState)instance;
        }
        return ImmutableRunningScenarioState.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SCENARIO_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private String scenarioId;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(RunningScenarioState instance) {
            Objects.requireNonNull(instance, "instance");
            this.scenarioId(instance.scenarioId());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder scenarioId(String scenarioId) {
            this.scenarioId = Objects.requireNonNull(scenarioId, "scenarioId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableRunningScenarioState build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRunningScenarioState(null, this.scenarioId);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("scenarioId");
            }
            return "Cannot build RunningScenarioState, some of required attributes are not set " + attributes;
        }
    }
}

