/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.execution.domain.schedule;

import com.chutneytesting.design.domain.campaign.SchedulingCampaign;
import com.chutneytesting.design.domain.campaign.SchedulingCampaignRepository;
import com.chutneytesting.execution.domain.campaign.CampaignExecutionEngine;
import com.chutneytesting.execution.domain.schedule.SchedulerRepository;
import java.time.Clock;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class CampaignScheduler {
    private static final Logger LOGGER = LoggerFactory.getLogger(CampaignScheduler.class);
    private LocalDateTime lastExecutionDateTime = LocalDateTime.now().minusMinutes(10L);
    private final CampaignExecutionEngine campaignExecutionEngine;
    private final SchedulerRepository schedulerRepository;
    private final Clock clock;
    private final SchedulingCampaignRepository schedulingCampaignRepository;

    public CampaignScheduler(CampaignExecutionEngine campaignExecutionEngine, SchedulerRepository schedulerRepository, Clock clock, SchedulingCampaignRepository schedulingCampaignRepository) {
        this.campaignExecutionEngine = campaignExecutionEngine;
        this.schedulerRepository = schedulerRepository;
        this.clock = clock;
        this.schedulingCampaignRepository = schedulingCampaignRepository;
    }

    @Async
    public void executeScheduledCampaign() {
        List<Long> campaignIds = this.checkCampaignToExecutePeriodically();
        campaignIds.addAll(this.checkScheduleCampaign());
        ((Stream)campaignIds.stream().parallel()).forEach(c -> {
            LOGGER.info("Execute campaign with id [{}]", c);
            try {
                this.campaignExecutionEngine.executeById((Long)c, "auto");
            }
            catch (Exception e) {
                LOGGER.error("Error during campaign execution", (Throwable)e);
            }
        });
    }

    private List<Long> checkScheduleCampaign() {
        List<SchedulingCampaign> ids = this.schedulingCampaignRepository.getALl().stream().filter(sc -> sc.schedulingDate.isBefore(LocalDateTime.now())).collect(Collectors.toList());
        ids.forEach(sc -> this.schedulingCampaignRepository.removeById(sc.id));
        return ids.stream().map(sc -> sc.campaignId).collect(Collectors.toList());
    }

    private List<Long> checkCampaignToExecutePeriodically() {
        LocalDateTime newLocalDateTime = LocalDateTime.now(this.clock);
        List<Long> campaignIdsToExecute = this.schedulerRepository.getCampaignScheduledAfter(this.lastExecutionDateTime);
        this.lastExecutionDateTime = newLocalDateTime;
        return campaignIdsToExecute;
    }
}

