/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.execution.domain.scenario.composed;

import com.chutneytesting.design.domain.scenario.TestCase;
import com.chutneytesting.design.domain.scenario.TestCaseMetadata;
import com.chutneytesting.design.domain.scenario.TestCaseMetadataImpl;
import com.chutneytesting.execution.domain.scenario.composed.ExecutableComposedScenario;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ExecutableComposedTestCase
implements TestCase {
    public final TestCaseMetadata metadata;
    public final ExecutableComposedScenario composedScenario;
    public final Map<String, String> computedParameters;

    public ExecutableComposedTestCase(TestCaseMetadata metadata, ExecutableComposedScenario composedScenario) {
        this.metadata = metadata;
        this.composedScenario = composedScenario;
        this.computedParameters = this.buildDataSet();
    }

    public ExecutableComposedTestCase(TestCaseMetadata metadata, ExecutableComposedScenario composedScenario, Map<String, String> computedParameters) {
        this.metadata = metadata;
        this.composedScenario = composedScenario;
        this.computedParameters = computedParameters;
    }

    @Override
    public TestCaseMetadata metadata() {
        return this.metadata;
    }

    @Override
    public Map<String, String> computedParameters() {
        return this.computedParameters;
    }

    @Override
    public TestCase withDataSet(Map<String, String> dataSet) {
        return new ExecutableComposedTestCase(this.metadata, this.composedScenario, dataSet);
    }

    public TestCase withDataSetId(String dataSetId) {
        return new ExecutableComposedTestCase(TestCaseMetadataImpl.TestCaseMetadataBuilder.from(this.metadata).withDatasetId(dataSetId).build(), this.composedScenario, this.computedParameters);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecutableComposedTestCase that = (ExecutableComposedTestCase)o;
        return Objects.equals(this.metadata, that.metadata) && Objects.equals(this.composedScenario, that.composedScenario) && Objects.equals(this.computedParameters, that.computedParameters);
    }

    public int hashCode() {
        return Objects.hash(this.metadata, this.composedScenario, this.computedParameters);
    }

    private Map<String, String> buildDataSet() {
        HashMap<String, String> dataSet = new HashMap<String, String>();
        this.composedScenario.composedSteps.forEach(composedStep -> dataSet.putAll(composedStep.dataSetGlobalParameters()));
        Optional.ofNullable(this.composedScenario.parameters).ifPresent(dataSet::putAll);
        return dataSet;
    }

    public String toString() {
        return "ExecutableComposedTestCase{, metadata=" + this.metadata + ", ExecutableComposedScenario=" + this.composedScenario + ", dataSet=" + this.computedParameters + "}";
    }
}

