/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.execution.domain.report;

import com.google.common.collect.Ordering;
import java.util.Objects;
import java.util.stream.StreamSupport;

public enum ServerReportStatus {
    SUCCESS,
    WARN,
    FAILURE,
    NOT_EXECUTED,
    STOPPED,
    PAUSED,
    RUNNING,
    EXECUTED;

    private static final Ordering<ServerReportStatus> EXECUTION_STATUS_STATUS_ORDERING;

    public static ServerReportStatus worst(Iterable<ServerReportStatus> severalStatus) {
        return StreamSupport.stream(severalStatus.spliterator(), false).filter(Objects::nonNull).reduce(SUCCESS, (arg_0, arg_1) -> EXECUTION_STATUS_STATUS_ORDERING.min(arg_0, arg_1));
    }

    public boolean isFinal() {
        return this.equals((Object)FAILURE) || this.equals((Object)SUCCESS) || this.equals((Object)STOPPED);
    }

    static {
        EXECUTION_STATUS_STATUS_ORDERING = Ordering.explicit((Object)((Object)PAUSED), (Object[])new ServerReportStatus[]{RUNNING, STOPPED, FAILURE, WARN, NOT_EXECUTED, SUCCESS});
    }

    public static interface HavingStatus {
        public ServerReportStatus getStatus();
    }
}

