/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.execution.domain.history;

import com.chutneytesting.execution.domain.history.ExecutionHistory;
import com.chutneytesting.execution.domain.history.HavingReport;
import com.chutneytesting.execution.domain.report.ServerReportStatus;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Immutable
public final class ImmutableExecutionHistory
implements ExecutionHistory {
    private final String scenarioId;
    private final ImmutableList<ExecutionHistory.Execution> history;

    private ImmutableExecutionHistory(String scenarioId, Iterable<? extends ExecutionHistory.Execution> history) {
        this.scenarioId = Objects.requireNonNull(scenarioId, "scenarioId");
        this.history = ImmutableList.copyOf(history);
    }

    private ImmutableExecutionHistory(ImmutableExecutionHistory original, String scenarioId, ImmutableList<ExecutionHistory.Execution> history) {
        this.scenarioId = scenarioId;
        this.history = history;
    }

    @Override
    @JsonProperty(value="scenarioId")
    public String scenarioId() {
        return this.scenarioId;
    }

    @JsonProperty(value="history")
    public ImmutableList<ExecutionHistory.Execution> history() {
        return this.history;
    }

    public final ImmutableExecutionHistory withScenarioId(String value) {
        if (this.scenarioId.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "scenarioId");
        return new ImmutableExecutionHistory(this, newValue, this.history);
    }

    public final ImmutableExecutionHistory withHistory(ExecutionHistory.Execution ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableExecutionHistory(this, this.scenarioId, (ImmutableList<ExecutionHistory.Execution>)newValue);
    }

    public final ImmutableExecutionHistory withHistory(Iterable<? extends ExecutionHistory.Execution> elements) {
        if (this.history == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableExecutionHistory(this, this.scenarioId, (ImmutableList<ExecutionHistory.Execution>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableExecutionHistory && this.equalTo((ImmutableExecutionHistory)another);
    }

    private boolean equalTo(ImmutableExecutionHistory another) {
        return this.scenarioId.equals(another.scenarioId) && this.history.equals(another.history);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.scenarioId.hashCode();
        h += (h << 5) + this.history.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ExecutionHistory").omitNullValues().add("scenarioId", (Object)this.scenarioId).add("history", this.history).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableExecutionHistory fromJson(Json json) {
        Builder builder = ImmutableExecutionHistory.builder();
        if (json.scenarioId != null) {
            builder.scenarioId(json.scenarioId);
        }
        if (json.history != null) {
            builder.addAllHistory(json.history);
        }
        return builder.build();
    }

    public static ImmutableExecutionHistory of(String scenarioId, List<ExecutionHistory.Execution> history) {
        return ImmutableExecutionHistory.of(scenarioId, history);
    }

    public static ImmutableExecutionHistory of(String scenarioId, Iterable<? extends ExecutionHistory.Execution> history) {
        return new ImmutableExecutionHistory(scenarioId, history);
    }

    public static ImmutableExecutionHistory copyOf(ExecutionHistory instance) {
        if (instance instanceof ImmutableExecutionHistory) {
            return (ImmutableExecutionHistory)instance;
        }
        return ImmutableExecutionHistory.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @CheckReturnValue
    @Immutable
    public static final class ExecutionSummary
    implements ExecutionHistory.ExecutionSummary {
        private final LocalDateTime time;
        private final long duration;
        private final ServerReportStatus status;
        @Nullable
        private final String info;
        @Nullable
        private final String error;
        private final String testCaseTitle;
        private final String environment;
        @Nullable
        private final String datasetId;
        @Nullable
        private final Integer datasetVersion;
        private final String user;
        private final Long executionId;

        private ExecutionSummary(LocalDateTime time, long duration, ServerReportStatus status, @Nullable String info, @Nullable String error, String testCaseTitle, String environment, @Nullable String datasetId, @Nullable Integer datasetVersion, String user, Long executionId) {
            this.time = time;
            this.duration = duration;
            this.status = status;
            this.info = info;
            this.error = error;
            this.testCaseTitle = testCaseTitle;
            this.environment = environment;
            this.datasetId = datasetId;
            this.datasetVersion = datasetVersion;
            this.user = user;
            this.executionId = executionId;
        }

        @Override
        @JsonProperty(value="time")
        public LocalDateTime time() {
            return this.time;
        }

        @Override
        @JsonProperty(value="duration")
        public long duration() {
            return this.duration;
        }

        @Override
        @JsonProperty(value="status")
        public ServerReportStatus status() {
            return this.status;
        }

        @Override
        @JsonProperty(value="info")
        public Optional<String> info() {
            return Optional.ofNullable(this.info);
        }

        @Override
        @JsonProperty(value="error")
        public Optional<String> error() {
            return Optional.ofNullable(this.error);
        }

        @Override
        @JsonProperty(value="testCaseTitle")
        public String testCaseTitle() {
            return this.testCaseTitle;
        }

        @Override
        @JsonProperty(value="environment")
        public String environment() {
            return this.environment;
        }

        @Override
        @JsonProperty(value="datasetId")
        public Optional<String> datasetId() {
            return Optional.ofNullable(this.datasetId);
        }

        @Override
        @JsonProperty(value="datasetVersion")
        public Optional<Integer> datasetVersion() {
            return Optional.ofNullable(this.datasetVersion);
        }

        @Override
        @JsonProperty(value="user")
        public String user() {
            return this.user;
        }

        @Override
        @JsonProperty(value="executionId")
        public Long executionId() {
            return this.executionId;
        }

        public final ExecutionSummary withTime(LocalDateTime value) {
            if (this.time == value) {
                return this;
            }
            LocalDateTime newValue = Objects.requireNonNull(value, "time");
            return new ExecutionSummary(newValue, this.duration, this.status, this.info, this.error, this.testCaseTitle, this.environment, this.datasetId, this.datasetVersion, this.user, this.executionId);
        }

        public final ExecutionSummary withDuration(long value) {
            if (this.duration == value) {
                return this;
            }
            return new ExecutionSummary(this.time, value, this.status, this.info, this.error, this.testCaseTitle, this.environment, this.datasetId, this.datasetVersion, this.user, this.executionId);
        }

        public final ExecutionSummary withStatus(ServerReportStatus value) {
            if (this.status == value) {
                return this;
            }
            ServerReportStatus newValue = Objects.requireNonNull(value, "status");
            return new ExecutionSummary(this.time, this.duration, newValue, this.info, this.error, this.testCaseTitle, this.environment, this.datasetId, this.datasetVersion, this.user, this.executionId);
        }

        public final ExecutionSummary withInfo(String value) {
            String newValue = Objects.requireNonNull(value, "info");
            if (Objects.equals(this.info, newValue)) {
                return this;
            }
            return new ExecutionSummary(this.time, this.duration, this.status, newValue, this.error, this.testCaseTitle, this.environment, this.datasetId, this.datasetVersion, this.user, this.executionId);
        }

        public final ExecutionSummary withInfo(Optional<String> optional) {
            String value = optional.orElse(null);
            if (Objects.equals(this.info, value)) {
                return this;
            }
            return new ExecutionSummary(this.time, this.duration, this.status, value, this.error, this.testCaseTitle, this.environment, this.datasetId, this.datasetVersion, this.user, this.executionId);
        }

        public final ExecutionSummary withError(String value) {
            String newValue = Objects.requireNonNull(value, "error");
            if (Objects.equals(this.error, newValue)) {
                return this;
            }
            return new ExecutionSummary(this.time, this.duration, this.status, this.info, newValue, this.testCaseTitle, this.environment, this.datasetId, this.datasetVersion, this.user, this.executionId);
        }

        public final ExecutionSummary withError(Optional<String> optional) {
            String value = optional.orElse(null);
            if (Objects.equals(this.error, value)) {
                return this;
            }
            return new ExecutionSummary(this.time, this.duration, this.status, this.info, value, this.testCaseTitle, this.environment, this.datasetId, this.datasetVersion, this.user, this.executionId);
        }

        public final ExecutionSummary withTestCaseTitle(String value) {
            if (this.testCaseTitle.equals(value)) {
                return this;
            }
            String newValue = Objects.requireNonNull(value, "testCaseTitle");
            return new ExecutionSummary(this.time, this.duration, this.status, this.info, this.error, newValue, this.environment, this.datasetId, this.datasetVersion, this.user, this.executionId);
        }

        public final ExecutionSummary withEnvironment(String value) {
            if (this.environment.equals(value)) {
                return this;
            }
            String newValue = Objects.requireNonNull(value, "environment");
            return new ExecutionSummary(this.time, this.duration, this.status, this.info, this.error, this.testCaseTitle, newValue, this.datasetId, this.datasetVersion, this.user, this.executionId);
        }

        public final ExecutionSummary withDatasetId(String value) {
            String newValue = Objects.requireNonNull(value, "datasetId");
            if (Objects.equals(this.datasetId, newValue)) {
                return this;
            }
            return new ExecutionSummary(this.time, this.duration, this.status, this.info, this.error, this.testCaseTitle, this.environment, newValue, this.datasetVersion, this.user, this.executionId);
        }

        public final ExecutionSummary withDatasetId(Optional<String> optional) {
            String value = optional.orElse(null);
            if (Objects.equals(this.datasetId, value)) {
                return this;
            }
            return new ExecutionSummary(this.time, this.duration, this.status, this.info, this.error, this.testCaseTitle, this.environment, value, this.datasetVersion, this.user, this.executionId);
        }

        public final ExecutionSummary withDatasetVersion(int value) {
            Integer newValue = value;
            if (Objects.equals(this.datasetVersion, newValue)) {
                return this;
            }
            return new ExecutionSummary(this.time, this.duration, this.status, this.info, this.error, this.testCaseTitle, this.environment, this.datasetId, newValue, this.user, this.executionId);
        }

        public final ExecutionSummary withDatasetVersion(Optional<Integer> optional) {
            Integer value = optional.orElse(null);
            if (Objects.equals(this.datasetVersion, value)) {
                return this;
            }
            return new ExecutionSummary(this.time, this.duration, this.status, this.info, this.error, this.testCaseTitle, this.environment, this.datasetId, value, this.user, this.executionId);
        }

        public final ExecutionSummary withUser(String value) {
            if (this.user.equals(value)) {
                return this;
            }
            String newValue = Objects.requireNonNull(value, "user");
            return new ExecutionSummary(this.time, this.duration, this.status, this.info, this.error, this.testCaseTitle, this.environment, this.datasetId, this.datasetVersion, newValue, this.executionId);
        }

        public final ExecutionSummary withExecutionId(Long value) {
            if (this.executionId.equals(value)) {
                return this;
            }
            Long newValue = Objects.requireNonNull(value, "executionId");
            return new ExecutionSummary(this.time, this.duration, this.status, this.info, this.error, this.testCaseTitle, this.environment, this.datasetId, this.datasetVersion, this.user, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ExecutionSummary && this.equalTo((ExecutionSummary)another);
        }

        private boolean equalTo(ExecutionSummary another) {
            return this.time.equals(another.time) && this.duration == another.duration && this.status.equals((Object)another.status) && Objects.equals(this.info, another.info) && Objects.equals(this.error, another.error) && this.testCaseTitle.equals(another.testCaseTitle) && this.environment.equals(another.environment) && Objects.equals(this.datasetId, another.datasetId) && Objects.equals(this.datasetVersion, another.datasetVersion) && this.user.equals(another.user) && this.executionId.equals(another.executionId);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.time.hashCode();
            h += (h << 5) + Longs.hashCode((long)this.duration);
            h += (h << 5) + this.status.hashCode();
            h += (h << 5) + Objects.hashCode(this.info);
            h += (h << 5) + Objects.hashCode(this.error);
            h += (h << 5) + this.testCaseTitle.hashCode();
            h += (h << 5) + this.environment.hashCode();
            h += (h << 5) + Objects.hashCode(this.datasetId);
            h += (h << 5) + Objects.hashCode(this.datasetVersion);
            h += (h << 5) + this.user.hashCode();
            h += (h << 5) + this.executionId.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"ExecutionSummary").omitNullValues().add("time", (Object)this.time).add("duration", this.duration).add("status", (Object)this.status).add("info", (Object)this.info).add("error", (Object)this.error).add("testCaseTitle", (Object)this.testCaseTitle).add("environment", (Object)this.environment).add("datasetId", (Object)this.datasetId).add("datasetVersion", (Object)this.datasetVersion).add("user", (Object)this.user).add("executionId", (Object)this.executionId).toString();
        }

        @Deprecated
        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        static ExecutionSummary fromJson(Json json) {
            Builder builder = ExecutionSummary.builder();
            if (json.time != null) {
                builder.time(json.time);
            }
            if (json.durationIsSet) {
                builder.duration(json.duration);
            }
            if (json.status != null) {
                builder.status(json.status);
            }
            if (json.info != null) {
                builder.info(json.info);
            }
            if (json.error != null) {
                builder.error(json.error);
            }
            if (json.testCaseTitle != null) {
                builder.testCaseTitle(json.testCaseTitle);
            }
            if (json.environment != null) {
                builder.environment(json.environment);
            }
            if (json.datasetId != null) {
                builder.datasetId(json.datasetId);
            }
            if (json.datasetVersion != null) {
                builder.datasetVersion(json.datasetVersion);
            }
            if (json.user != null) {
                builder.user(json.user);
            }
            if (json.executionId != null) {
                builder.executionId(json.executionId);
            }
            return builder.build();
        }

        public static ExecutionSummary copyOf(ExecutionHistory.ExecutionSummary instance) {
            if (instance instanceof ExecutionSummary) {
                return (ExecutionSummary)instance;
            }
            return ExecutionSummary.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_TIME = 1L;
            private static final long INIT_BIT_DURATION = 2L;
            private static final long INIT_BIT_STATUS = 4L;
            private static final long INIT_BIT_TEST_CASE_TITLE = 8L;
            private static final long INIT_BIT_ENVIRONMENT = 16L;
            private static final long INIT_BIT_USER = 32L;
            private static final long INIT_BIT_EXECUTION_ID = 64L;
            private long initBits = 127L;
            @Nullable
            private LocalDateTime time;
            private long duration;
            @Nullable
            private ServerReportStatus status;
            @Nullable
            private String info;
            @Nullable
            private String error;
            @Nullable
            private String testCaseTitle;
            @Nullable
            private String environment;
            @Nullable
            private String datasetId;
            @Nullable
            private Integer datasetVersion;
            @Nullable
            private String user;
            @Nullable
            private Long executionId;

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(ExecutionHistory.Attached instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder from(ExecutionHistory.ExecutionProperties instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder from(ExecutionHistory.ExecutionSummary instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                Object instance;
                if (object instanceof ExecutionHistory.Attached) {
                    instance = (ExecutionHistory.Attached)object;
                    this.executionId(instance.executionId());
                }
                if (object instanceof ExecutionHistory.ExecutionProperties) {
                    Optional<String> datasetIdOptional;
                    instance = (ExecutionHistory.ExecutionProperties)object;
                    this.duration(instance.duration());
                    this.environment(instance.environment());
                    Optional<Integer> datasetVersionOptional = instance.datasetVersion();
                    if (datasetVersionOptional.isPresent()) {
                        this.datasetVersion(datasetVersionOptional);
                    }
                    if ((datasetIdOptional = instance.datasetId()).isPresent()) {
                        this.datasetId(datasetIdOptional);
                    }
                    this.time(instance.time());
                    Optional<String> errorOptional = instance.error();
                    if (errorOptional.isPresent()) {
                        this.error(errorOptional);
                    }
                    this.testCaseTitle(instance.testCaseTitle());
                    this.user(instance.user());
                    this.status(instance.status());
                    Optional<String> infoOptional = instance.info();
                    if (infoOptional.isPresent()) {
                        this.info(infoOptional);
                    }
                }
            }

            @CanIgnoreReturnValue
            public final Builder time(LocalDateTime time) {
                this.time = Objects.requireNonNull(time, "time");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder duration(long duration) {
                this.duration = duration;
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder status(ServerReportStatus status) {
                this.status = Objects.requireNonNull(status, "status");
                this.initBits &= 0xFFFFFFFFFFFFFFFBL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder info(String info) {
                this.info = Objects.requireNonNull(info, "info");
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder info(Optional<String> info) {
                this.info = info.orElse(null);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder error(String error) {
                this.error = Objects.requireNonNull(error, "error");
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder error(Optional<String> error) {
                this.error = error.orElse(null);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder testCaseTitle(String testCaseTitle) {
                this.testCaseTitle = Objects.requireNonNull(testCaseTitle, "testCaseTitle");
                this.initBits &= 0xFFFFFFFFFFFFFFF7L;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder environment(String environment) {
                this.environment = Objects.requireNonNull(environment, "environment");
                this.initBits &= 0xFFFFFFFFFFFFFFEFL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder datasetId(String datasetId) {
                this.datasetId = Objects.requireNonNull(datasetId, "datasetId");
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder datasetId(Optional<String> datasetId) {
                this.datasetId = datasetId.orElse(null);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder datasetVersion(int datasetVersion) {
                this.datasetVersion = datasetVersion;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder datasetVersion(Optional<Integer> datasetVersion) {
                this.datasetVersion = datasetVersion.orElse(null);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder user(String user) {
                this.user = Objects.requireNonNull(user, "user");
                this.initBits &= 0xFFFFFFFFFFFFFFDFL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder executionId(Long executionId) {
                this.executionId = Objects.requireNonNull(executionId, "executionId");
                this.initBits &= 0xFFFFFFFFFFFFFFBFL;
                return this;
            }

            public ExecutionSummary build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new ExecutionSummary(this.time, this.duration, this.status, this.info, this.error, this.testCaseTitle, this.environment, this.datasetId, this.datasetVersion, this.user, this.executionId);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList attributes = Lists.newArrayList();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("time");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("duration");
                }
                if ((this.initBits & 4L) != 0L) {
                    attributes.add("status");
                }
                if ((this.initBits & 8L) != 0L) {
                    attributes.add("testCaseTitle");
                }
                if ((this.initBits & 0x10L) != 0L) {
                    attributes.add("environment");
                }
                if ((this.initBits & 0x20L) != 0L) {
                    attributes.add("user");
                }
                if ((this.initBits & 0x40L) != 0L) {
                    attributes.add("executionId");
                }
                return "Cannot build ExecutionSummary, some of required attributes are not set " + attributes;
            }
        }

        @Deprecated
        @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
        static final class Json
        implements ExecutionHistory.ExecutionSummary {
            @Nullable
            LocalDateTime time;
            long duration;
            boolean durationIsSet;
            @Nullable
            ServerReportStatus status;
            @Nullable
            Optional<String> info = Optional.empty();
            @Nullable
            Optional<String> error = Optional.empty();
            @Nullable
            String testCaseTitle;
            @Nullable
            String environment;
            @Nullable
            Optional<String> datasetId = Optional.empty();
            @Nullable
            Optional<Integer> datasetVersion = Optional.empty();
            @Nullable
            String user;
            @Nullable
            Long executionId;

            Json() {
            }

            @JsonProperty(value="time")
            public void setTime(LocalDateTime time) {
                this.time = time;
            }

            @JsonProperty(value="duration")
            public void setDuration(long duration) {
                this.duration = duration;
                this.durationIsSet = true;
            }

            @JsonProperty(value="status")
            public void setStatus(ServerReportStatus status) {
                this.status = status;
            }

            @JsonProperty(value="info")
            public void setInfo(Optional<String> info) {
                this.info = info;
            }

            @JsonProperty(value="error")
            public void setError(Optional<String> error) {
                this.error = error;
            }

            @JsonProperty(value="testCaseTitle")
            public void setTestCaseTitle(String testCaseTitle) {
                this.testCaseTitle = testCaseTitle;
            }

            @JsonProperty(value="environment")
            public void setEnvironment(String environment) {
                this.environment = environment;
            }

            @JsonProperty(value="datasetId")
            public void setDatasetId(Optional<String> datasetId) {
                this.datasetId = datasetId;
            }

            @JsonProperty(value="datasetVersion")
            public void setDatasetVersion(Optional<Integer> datasetVersion) {
                this.datasetVersion = datasetVersion;
            }

            @JsonProperty(value="user")
            public void setUser(String user) {
                this.user = user;
            }

            @JsonProperty(value="executionId")
            public void setExecutionId(Long executionId) {
                this.executionId = executionId;
            }

            @Override
            public LocalDateTime time() {
                throw new UnsupportedOperationException();
            }

            @Override
            public long duration() {
                throw new UnsupportedOperationException();
            }

            @Override
            public ServerReportStatus status() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Optional<String> info() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Optional<String> error() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String testCaseTitle() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String environment() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Optional<String> datasetId() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Optional<Integer> datasetVersion() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String user() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Long executionId() {
                throw new UnsupportedOperationException();
            }
        }
    }

    @CheckReturnValue
    @Immutable
    public static final class DetachedExecution
    implements ExecutionHistory.DetachedExecution {
        private final LocalDateTime time;
        private final long duration;
        private final ServerReportStatus status;
        @Nullable
        private final String info;
        @Nullable
        private final String error;
        private final String testCaseTitle;
        private final String environment;
        @Nullable
        private final String datasetId;
        @Nullable
        private final Integer datasetVersion;
        private final String user;
        private final String report;

        private DetachedExecution(LocalDateTime time, long duration, ServerReportStatus status, @Nullable String info, @Nullable String error, String testCaseTitle, String environment, @Nullable String datasetId, @Nullable Integer datasetVersion, String user, String report) {
            this.time = time;
            this.duration = duration;
            this.status = status;
            this.info = info;
            this.error = error;
            this.testCaseTitle = testCaseTitle;
            this.environment = environment;
            this.datasetId = datasetId;
            this.datasetVersion = datasetVersion;
            this.user = user;
            this.report = report;
        }

        @Override
        @JsonProperty(value="time")
        public LocalDateTime time() {
            return this.time;
        }

        @Override
        @JsonProperty(value="duration")
        public long duration() {
            return this.duration;
        }

        @Override
        @JsonProperty(value="status")
        public ServerReportStatus status() {
            return this.status;
        }

        @Override
        @JsonProperty(value="info")
        public Optional<String> info() {
            return Optional.ofNullable(this.info);
        }

        @Override
        @JsonProperty(value="error")
        public Optional<String> error() {
            return Optional.ofNullable(this.error);
        }

        @Override
        @JsonProperty(value="testCaseTitle")
        public String testCaseTitle() {
            return this.testCaseTitle;
        }

        @Override
        @JsonProperty(value="environment")
        public String environment() {
            return this.environment;
        }

        @Override
        @JsonProperty(value="datasetId")
        public Optional<String> datasetId() {
            return Optional.ofNullable(this.datasetId);
        }

        @Override
        @JsonProperty(value="datasetVersion")
        public Optional<Integer> datasetVersion() {
            return Optional.ofNullable(this.datasetVersion);
        }

        @Override
        @JsonProperty(value="user")
        public String user() {
            return this.user;
        }

        @Override
        @JsonProperty(value="report")
        public String report() {
            return this.report;
        }

        public final DetachedExecution withTime(LocalDateTime value) {
            if (this.time == value) {
                return this;
            }
            LocalDateTime newValue = Objects.requireNonNull(value, "time");
            return new DetachedExecution(newValue, this.duration, this.status, this.info, this.error, this.testCaseTitle, this.environment, this.datasetId, this.datasetVersion, this.user, this.report);
        }

        public final DetachedExecution withDuration(long value) {
            if (this.duration == value) {
                return this;
            }
            return new DetachedExecution(this.time, value, this.status, this.info, this.error, this.testCaseTitle, this.environment, this.datasetId, this.datasetVersion, this.user, this.report);
        }

        public final DetachedExecution withStatus(ServerReportStatus value) {
            if (this.status == value) {
                return this;
            }
            ServerReportStatus newValue = Objects.requireNonNull(value, "status");
            return new DetachedExecution(this.time, this.duration, newValue, this.info, this.error, this.testCaseTitle, this.environment, this.datasetId, this.datasetVersion, this.user, this.report);
        }

        public final DetachedExecution withInfo(String value) {
            String newValue = Objects.requireNonNull(value, "info");
            if (Objects.equals(this.info, newValue)) {
                return this;
            }
            return new DetachedExecution(this.time, this.duration, this.status, newValue, this.error, this.testCaseTitle, this.environment, this.datasetId, this.datasetVersion, this.user, this.report);
        }

        public final DetachedExecution withInfo(Optional<String> optional) {
            String value = optional.orElse(null);
            if (Objects.equals(this.info, value)) {
                return this;
            }
            return new DetachedExecution(this.time, this.duration, this.status, value, this.error, this.testCaseTitle, this.environment, this.datasetId, this.datasetVersion, this.user, this.report);
        }

        public final DetachedExecution withError(String value) {
            String newValue = Objects.requireNonNull(value, "error");
            if (Objects.equals(this.error, newValue)) {
                return this;
            }
            return new DetachedExecution(this.time, this.duration, this.status, this.info, newValue, this.testCaseTitle, this.environment, this.datasetId, this.datasetVersion, this.user, this.report);
        }

        public final DetachedExecution withError(Optional<String> optional) {
            String value = optional.orElse(null);
            if (Objects.equals(this.error, value)) {
                return this;
            }
            return new DetachedExecution(this.time, this.duration, this.status, this.info, value, this.testCaseTitle, this.environment, this.datasetId, this.datasetVersion, this.user, this.report);
        }

        public final DetachedExecution withTestCaseTitle(String value) {
            if (this.testCaseTitle.equals(value)) {
                return this;
            }
            String newValue = Objects.requireNonNull(value, "testCaseTitle");
            return new DetachedExecution(this.time, this.duration, this.status, this.info, this.error, newValue, this.environment, this.datasetId, this.datasetVersion, this.user, this.report);
        }

        public final DetachedExecution withEnvironment(String value) {
            if (this.environment.equals(value)) {
                return this;
            }
            String newValue = Objects.requireNonNull(value, "environment");
            return new DetachedExecution(this.time, this.duration, this.status, this.info, this.error, this.testCaseTitle, newValue, this.datasetId, this.datasetVersion, this.user, this.report);
        }

        public final DetachedExecution withDatasetId(String value) {
            String newValue = Objects.requireNonNull(value, "datasetId");
            if (Objects.equals(this.datasetId, newValue)) {
                return this;
            }
            return new DetachedExecution(this.time, this.duration, this.status, this.info, this.error, this.testCaseTitle, this.environment, newValue, this.datasetVersion, this.user, this.report);
        }

        public final DetachedExecution withDatasetId(Optional<String> optional) {
            String value = optional.orElse(null);
            if (Objects.equals(this.datasetId, value)) {
                return this;
            }
            return new DetachedExecution(this.time, this.duration, this.status, this.info, this.error, this.testCaseTitle, this.environment, value, this.datasetVersion, this.user, this.report);
        }

        public final DetachedExecution withDatasetVersion(int value) {
            Integer newValue = value;
            if (Objects.equals(this.datasetVersion, newValue)) {
                return this;
            }
            return new DetachedExecution(this.time, this.duration, this.status, this.info, this.error, this.testCaseTitle, this.environment, this.datasetId, newValue, this.user, this.report);
        }

        public final DetachedExecution withDatasetVersion(Optional<Integer> optional) {
            Integer value = optional.orElse(null);
            if (Objects.equals(this.datasetVersion, value)) {
                return this;
            }
            return new DetachedExecution(this.time, this.duration, this.status, this.info, this.error, this.testCaseTitle, this.environment, this.datasetId, value, this.user, this.report);
        }

        public final DetachedExecution withUser(String value) {
            if (this.user.equals(value)) {
                return this;
            }
            String newValue = Objects.requireNonNull(value, "user");
            return new DetachedExecution(this.time, this.duration, this.status, this.info, this.error, this.testCaseTitle, this.environment, this.datasetId, this.datasetVersion, newValue, this.report);
        }

        public final DetachedExecution withReport(String value) {
            if (this.report.equals(value)) {
                return this;
            }
            String newValue = Objects.requireNonNull(value, "report");
            return new DetachedExecution(this.time, this.duration, this.status, this.info, this.error, this.testCaseTitle, this.environment, this.datasetId, this.datasetVersion, this.user, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof DetachedExecution && this.equalTo((DetachedExecution)another);
        }

        private boolean equalTo(DetachedExecution another) {
            return this.time.equals(another.time) && this.duration == another.duration && this.status.equals((Object)another.status) && Objects.equals(this.info, another.info) && Objects.equals(this.error, another.error) && this.testCaseTitle.equals(another.testCaseTitle) && this.environment.equals(another.environment) && Objects.equals(this.datasetId, another.datasetId) && Objects.equals(this.datasetVersion, another.datasetVersion) && this.user.equals(another.user) && this.report.equals(another.report);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.time.hashCode();
            h += (h << 5) + Longs.hashCode((long)this.duration);
            h += (h << 5) + this.status.hashCode();
            h += (h << 5) + Objects.hashCode(this.info);
            h += (h << 5) + Objects.hashCode(this.error);
            h += (h << 5) + this.testCaseTitle.hashCode();
            h += (h << 5) + this.environment.hashCode();
            h += (h << 5) + Objects.hashCode(this.datasetId);
            h += (h << 5) + Objects.hashCode(this.datasetVersion);
            h += (h << 5) + this.user.hashCode();
            h += (h << 5) + this.report.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"DetachedExecution").omitNullValues().add("time", (Object)this.time).add("duration", this.duration).add("status", (Object)this.status).add("info", (Object)this.info).add("error", (Object)this.error).add("testCaseTitle", (Object)this.testCaseTitle).add("environment", (Object)this.environment).add("datasetId", (Object)this.datasetId).add("datasetVersion", (Object)this.datasetVersion).add("user", (Object)this.user).add("report", (Object)this.report).toString();
        }

        @Deprecated
        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        static DetachedExecution fromJson(Json json) {
            Builder builder = DetachedExecution.builder();
            if (json.time != null) {
                builder.time(json.time);
            }
            if (json.durationIsSet) {
                builder.duration(json.duration);
            }
            if (json.status != null) {
                builder.status(json.status);
            }
            if (json.info != null) {
                builder.info(json.info);
            }
            if (json.error != null) {
                builder.error(json.error);
            }
            if (json.testCaseTitle != null) {
                builder.testCaseTitle(json.testCaseTitle);
            }
            if (json.environment != null) {
                builder.environment(json.environment);
            }
            if (json.datasetId != null) {
                builder.datasetId(json.datasetId);
            }
            if (json.datasetVersion != null) {
                builder.datasetVersion(json.datasetVersion);
            }
            if (json.user != null) {
                builder.user(json.user);
            }
            if (json.report != null) {
                builder.report(json.report);
            }
            return builder.build();
        }

        public static DetachedExecution copyOf(ExecutionHistory.DetachedExecution instance) {
            if (instance instanceof DetachedExecution) {
                return (DetachedExecution)instance;
            }
            return DetachedExecution.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_TIME = 1L;
            private static final long INIT_BIT_DURATION = 2L;
            private static final long INIT_BIT_STATUS = 4L;
            private static final long INIT_BIT_TEST_CASE_TITLE = 8L;
            private static final long INIT_BIT_ENVIRONMENT = 16L;
            private static final long INIT_BIT_USER = 32L;
            private static final long INIT_BIT_REPORT = 64L;
            private long initBits = 127L;
            @Nullable
            private LocalDateTime time;
            private long duration;
            @Nullable
            private ServerReportStatus status;
            @Nullable
            private String info;
            @Nullable
            private String error;
            @Nullable
            private String testCaseTitle;
            @Nullable
            private String environment;
            @Nullable
            private String datasetId;
            @Nullable
            private Integer datasetVersion;
            @Nullable
            private String user;
            @Nullable
            private String report;

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(ExecutionHistory.ExecutionProperties instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder from(HavingReport instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder from(ExecutionHistory.DetachedExecution instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                Object instance;
                if (object instanceof ExecutionHistory.ExecutionProperties) {
                    Optional<String> datasetIdOptional;
                    instance = (ExecutionHistory.ExecutionProperties)object;
                    this.duration(instance.duration());
                    this.environment(instance.environment());
                    Optional<Integer> datasetVersionOptional = instance.datasetVersion();
                    if (datasetVersionOptional.isPresent()) {
                        this.datasetVersion(datasetVersionOptional);
                    }
                    if ((datasetIdOptional = instance.datasetId()).isPresent()) {
                        this.datasetId(datasetIdOptional);
                    }
                    this.time(instance.time());
                    Optional<String> errorOptional = instance.error();
                    if (errorOptional.isPresent()) {
                        this.error(errorOptional);
                    }
                    this.testCaseTitle(instance.testCaseTitle());
                    this.user(instance.user());
                    this.status(instance.status());
                    Optional<String> infoOptional = instance.info();
                    if (infoOptional.isPresent()) {
                        this.info(infoOptional);
                    }
                }
                if (object instanceof HavingReport) {
                    instance = (HavingReport)object;
                    this.report(instance.report());
                }
            }

            @CanIgnoreReturnValue
            public final Builder time(LocalDateTime time) {
                this.time = Objects.requireNonNull(time, "time");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder duration(long duration) {
                this.duration = duration;
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder status(ServerReportStatus status) {
                this.status = Objects.requireNonNull(status, "status");
                this.initBits &= 0xFFFFFFFFFFFFFFFBL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder info(String info) {
                this.info = Objects.requireNonNull(info, "info");
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder info(Optional<String> info) {
                this.info = info.orElse(null);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder error(String error) {
                this.error = Objects.requireNonNull(error, "error");
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder error(Optional<String> error) {
                this.error = error.orElse(null);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder testCaseTitle(String testCaseTitle) {
                this.testCaseTitle = Objects.requireNonNull(testCaseTitle, "testCaseTitle");
                this.initBits &= 0xFFFFFFFFFFFFFFF7L;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder environment(String environment) {
                this.environment = Objects.requireNonNull(environment, "environment");
                this.initBits &= 0xFFFFFFFFFFFFFFEFL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder datasetId(String datasetId) {
                this.datasetId = Objects.requireNonNull(datasetId, "datasetId");
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder datasetId(Optional<String> datasetId) {
                this.datasetId = datasetId.orElse(null);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder datasetVersion(int datasetVersion) {
                this.datasetVersion = datasetVersion;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder datasetVersion(Optional<Integer> datasetVersion) {
                this.datasetVersion = datasetVersion.orElse(null);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder user(String user) {
                this.user = Objects.requireNonNull(user, "user");
                this.initBits &= 0xFFFFFFFFFFFFFFDFL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder report(String report) {
                this.report = Objects.requireNonNull(report, "report");
                this.initBits &= 0xFFFFFFFFFFFFFFBFL;
                return this;
            }

            public DetachedExecution build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new DetachedExecution(this.time, this.duration, this.status, this.info, this.error, this.testCaseTitle, this.environment, this.datasetId, this.datasetVersion, this.user, this.report);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList attributes = Lists.newArrayList();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("time");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("duration");
                }
                if ((this.initBits & 4L) != 0L) {
                    attributes.add("status");
                }
                if ((this.initBits & 8L) != 0L) {
                    attributes.add("testCaseTitle");
                }
                if ((this.initBits & 0x10L) != 0L) {
                    attributes.add("environment");
                }
                if ((this.initBits & 0x20L) != 0L) {
                    attributes.add("user");
                }
                if ((this.initBits & 0x40L) != 0L) {
                    attributes.add("report");
                }
                return "Cannot build DetachedExecution, some of required attributes are not set " + attributes;
            }
        }

        @Deprecated
        @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
        static final class Json
        implements ExecutionHistory.DetachedExecution {
            @Nullable
            LocalDateTime time;
            long duration;
            boolean durationIsSet;
            @Nullable
            ServerReportStatus status;
            @Nullable
            Optional<String> info = Optional.empty();
            @Nullable
            Optional<String> error = Optional.empty();
            @Nullable
            String testCaseTitle;
            @Nullable
            String environment;
            @Nullable
            Optional<String> datasetId = Optional.empty();
            @Nullable
            Optional<Integer> datasetVersion = Optional.empty();
            @Nullable
            String user;
            @Nullable
            String report;

            Json() {
            }

            @JsonProperty(value="time")
            public void setTime(LocalDateTime time) {
                this.time = time;
            }

            @JsonProperty(value="duration")
            public void setDuration(long duration) {
                this.duration = duration;
                this.durationIsSet = true;
            }

            @JsonProperty(value="status")
            public void setStatus(ServerReportStatus status) {
                this.status = status;
            }

            @JsonProperty(value="info")
            public void setInfo(Optional<String> info) {
                this.info = info;
            }

            @JsonProperty(value="error")
            public void setError(Optional<String> error) {
                this.error = error;
            }

            @JsonProperty(value="testCaseTitle")
            public void setTestCaseTitle(String testCaseTitle) {
                this.testCaseTitle = testCaseTitle;
            }

            @JsonProperty(value="environment")
            public void setEnvironment(String environment) {
                this.environment = environment;
            }

            @JsonProperty(value="datasetId")
            public void setDatasetId(Optional<String> datasetId) {
                this.datasetId = datasetId;
            }

            @JsonProperty(value="datasetVersion")
            public void setDatasetVersion(Optional<Integer> datasetVersion) {
                this.datasetVersion = datasetVersion;
            }

            @JsonProperty(value="user")
            public void setUser(String user) {
                this.user = user;
            }

            @JsonProperty(value="report")
            public void setReport(String report) {
                this.report = report;
            }

            @Override
            public LocalDateTime time() {
                throw new UnsupportedOperationException();
            }

            @Override
            public long duration() {
                throw new UnsupportedOperationException();
            }

            @Override
            public ServerReportStatus status() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Optional<String> info() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Optional<String> error() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String testCaseTitle() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String environment() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Optional<String> datasetId() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Optional<Integer> datasetVersion() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String user() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String report() {
                throw new UnsupportedOperationException();
            }
        }
    }

    @CheckReturnValue
    @Immutable
    public static final class Execution
    implements ExecutionHistory.Execution {
        private final LocalDateTime time;
        private final long duration;
        private final ServerReportStatus status;
        @Nullable
        private final String info;
        @Nullable
        private final String error;
        private final String testCaseTitle;
        private final String environment;
        @Nullable
        private final String datasetId;
        @Nullable
        private final Integer datasetVersion;
        private final String user;
        private final String report;
        private final Long executionId;

        private Execution(LocalDateTime time, long duration, ServerReportStatus status, @Nullable String info, @Nullable String error, String testCaseTitle, String environment, @Nullable String datasetId, @Nullable Integer datasetVersion, String user, String report, Long executionId) {
            this.time = time;
            this.duration = duration;
            this.status = status;
            this.info = info;
            this.error = error;
            this.testCaseTitle = testCaseTitle;
            this.environment = environment;
            this.datasetId = datasetId;
            this.datasetVersion = datasetVersion;
            this.user = user;
            this.report = report;
            this.executionId = executionId;
        }

        @Override
        @JsonProperty(value="time")
        public LocalDateTime time() {
            return this.time;
        }

        @Override
        @JsonProperty(value="duration")
        public long duration() {
            return this.duration;
        }

        @Override
        @JsonProperty(value="status")
        public ServerReportStatus status() {
            return this.status;
        }

        @Override
        @JsonProperty(value="info")
        public Optional<String> info() {
            return Optional.ofNullable(this.info);
        }

        @Override
        @JsonProperty(value="error")
        public Optional<String> error() {
            return Optional.ofNullable(this.error);
        }

        @Override
        @JsonProperty(value="testCaseTitle")
        public String testCaseTitle() {
            return this.testCaseTitle;
        }

        @Override
        @JsonProperty(value="environment")
        public String environment() {
            return this.environment;
        }

        @Override
        @JsonProperty(value="datasetId")
        public Optional<String> datasetId() {
            return Optional.ofNullable(this.datasetId);
        }

        @Override
        @JsonProperty(value="datasetVersion")
        public Optional<Integer> datasetVersion() {
            return Optional.ofNullable(this.datasetVersion);
        }

        @Override
        @JsonProperty(value="user")
        public String user() {
            return this.user;
        }

        @Override
        @JsonProperty(value="report")
        public String report() {
            return this.report;
        }

        @Override
        @JsonProperty(value="executionId")
        public Long executionId() {
            return this.executionId;
        }

        public final Execution withTime(LocalDateTime value) {
            if (this.time == value) {
                return this;
            }
            LocalDateTime newValue = Objects.requireNonNull(value, "time");
            return new Execution(newValue, this.duration, this.status, this.info, this.error, this.testCaseTitle, this.environment, this.datasetId, this.datasetVersion, this.user, this.report, this.executionId);
        }

        public final Execution withDuration(long value) {
            if (this.duration == value) {
                return this;
            }
            return new Execution(this.time, value, this.status, this.info, this.error, this.testCaseTitle, this.environment, this.datasetId, this.datasetVersion, this.user, this.report, this.executionId);
        }

        public final Execution withStatus(ServerReportStatus value) {
            if (this.status == value) {
                return this;
            }
            ServerReportStatus newValue = Objects.requireNonNull(value, "status");
            return new Execution(this.time, this.duration, newValue, this.info, this.error, this.testCaseTitle, this.environment, this.datasetId, this.datasetVersion, this.user, this.report, this.executionId);
        }

        public final Execution withInfo(String value) {
            String newValue = Objects.requireNonNull(value, "info");
            if (Objects.equals(this.info, newValue)) {
                return this;
            }
            return new Execution(this.time, this.duration, this.status, newValue, this.error, this.testCaseTitle, this.environment, this.datasetId, this.datasetVersion, this.user, this.report, this.executionId);
        }

        public final Execution withInfo(Optional<String> optional) {
            String value = optional.orElse(null);
            if (Objects.equals(this.info, value)) {
                return this;
            }
            return new Execution(this.time, this.duration, this.status, value, this.error, this.testCaseTitle, this.environment, this.datasetId, this.datasetVersion, this.user, this.report, this.executionId);
        }

        public final Execution withError(String value) {
            String newValue = Objects.requireNonNull(value, "error");
            if (Objects.equals(this.error, newValue)) {
                return this;
            }
            return new Execution(this.time, this.duration, this.status, this.info, newValue, this.testCaseTitle, this.environment, this.datasetId, this.datasetVersion, this.user, this.report, this.executionId);
        }

        public final Execution withError(Optional<String> optional) {
            String value = optional.orElse(null);
            if (Objects.equals(this.error, value)) {
                return this;
            }
            return new Execution(this.time, this.duration, this.status, this.info, value, this.testCaseTitle, this.environment, this.datasetId, this.datasetVersion, this.user, this.report, this.executionId);
        }

        public final Execution withTestCaseTitle(String value) {
            if (this.testCaseTitle.equals(value)) {
                return this;
            }
            String newValue = Objects.requireNonNull(value, "testCaseTitle");
            return new Execution(this.time, this.duration, this.status, this.info, this.error, newValue, this.environment, this.datasetId, this.datasetVersion, this.user, this.report, this.executionId);
        }

        public final Execution withEnvironment(String value) {
            if (this.environment.equals(value)) {
                return this;
            }
            String newValue = Objects.requireNonNull(value, "environment");
            return new Execution(this.time, this.duration, this.status, this.info, this.error, this.testCaseTitle, newValue, this.datasetId, this.datasetVersion, this.user, this.report, this.executionId);
        }

        public final Execution withDatasetId(String value) {
            String newValue = Objects.requireNonNull(value, "datasetId");
            if (Objects.equals(this.datasetId, newValue)) {
                return this;
            }
            return new Execution(this.time, this.duration, this.status, this.info, this.error, this.testCaseTitle, this.environment, newValue, this.datasetVersion, this.user, this.report, this.executionId);
        }

        public final Execution withDatasetId(Optional<String> optional) {
            String value = optional.orElse(null);
            if (Objects.equals(this.datasetId, value)) {
                return this;
            }
            return new Execution(this.time, this.duration, this.status, this.info, this.error, this.testCaseTitle, this.environment, value, this.datasetVersion, this.user, this.report, this.executionId);
        }

        public final Execution withDatasetVersion(int value) {
            Integer newValue = value;
            if (Objects.equals(this.datasetVersion, newValue)) {
                return this;
            }
            return new Execution(this.time, this.duration, this.status, this.info, this.error, this.testCaseTitle, this.environment, this.datasetId, newValue, this.user, this.report, this.executionId);
        }

        public final Execution withDatasetVersion(Optional<Integer> optional) {
            Integer value = optional.orElse(null);
            if (Objects.equals(this.datasetVersion, value)) {
                return this;
            }
            return new Execution(this.time, this.duration, this.status, this.info, this.error, this.testCaseTitle, this.environment, this.datasetId, value, this.user, this.report, this.executionId);
        }

        public final Execution withUser(String value) {
            if (this.user.equals(value)) {
                return this;
            }
            String newValue = Objects.requireNonNull(value, "user");
            return new Execution(this.time, this.duration, this.status, this.info, this.error, this.testCaseTitle, this.environment, this.datasetId, this.datasetVersion, newValue, this.report, this.executionId);
        }

        public final Execution withReport(String value) {
            if (this.report.equals(value)) {
                return this;
            }
            String newValue = Objects.requireNonNull(value, "report");
            return new Execution(this.time, this.duration, this.status, this.info, this.error, this.testCaseTitle, this.environment, this.datasetId, this.datasetVersion, this.user, newValue, this.executionId);
        }

        public final Execution withExecutionId(Long value) {
            if (this.executionId.equals(value)) {
                return this;
            }
            Long newValue = Objects.requireNonNull(value, "executionId");
            return new Execution(this.time, this.duration, this.status, this.info, this.error, this.testCaseTitle, this.environment, this.datasetId, this.datasetVersion, this.user, this.report, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Execution && this.equalTo((Execution)another);
        }

        private boolean equalTo(Execution another) {
            return this.time.equals(another.time) && this.duration == another.duration && this.status.equals((Object)another.status) && Objects.equals(this.info, another.info) && Objects.equals(this.error, another.error) && this.testCaseTitle.equals(another.testCaseTitle) && this.environment.equals(another.environment) && Objects.equals(this.datasetId, another.datasetId) && Objects.equals(this.datasetVersion, another.datasetVersion) && this.user.equals(another.user) && this.report.equals(another.report) && this.executionId.equals(another.executionId);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.time.hashCode();
            h += (h << 5) + Longs.hashCode((long)this.duration);
            h += (h << 5) + this.status.hashCode();
            h += (h << 5) + Objects.hashCode(this.info);
            h += (h << 5) + Objects.hashCode(this.error);
            h += (h << 5) + this.testCaseTitle.hashCode();
            h += (h << 5) + this.environment.hashCode();
            h += (h << 5) + Objects.hashCode(this.datasetId);
            h += (h << 5) + Objects.hashCode(this.datasetVersion);
            h += (h << 5) + this.user.hashCode();
            h += (h << 5) + this.report.hashCode();
            h += (h << 5) + this.executionId.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"Execution").omitNullValues().add("time", (Object)this.time).add("duration", this.duration).add("status", (Object)this.status).add("info", (Object)this.info).add("error", (Object)this.error).add("testCaseTitle", (Object)this.testCaseTitle).add("environment", (Object)this.environment).add("datasetId", (Object)this.datasetId).add("datasetVersion", (Object)this.datasetVersion).add("user", (Object)this.user).add("report", (Object)this.report).add("executionId", (Object)this.executionId).toString();
        }

        @Deprecated
        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        static Execution fromJson(Json json) {
            Builder builder = Execution.builder();
            if (json.time != null) {
                builder.time(json.time);
            }
            if (json.durationIsSet) {
                builder.duration(json.duration);
            }
            if (json.status != null) {
                builder.status(json.status);
            }
            if (json.info != null) {
                builder.info(json.info);
            }
            if (json.error != null) {
                builder.error(json.error);
            }
            if (json.testCaseTitle != null) {
                builder.testCaseTitle(json.testCaseTitle);
            }
            if (json.environment != null) {
                builder.environment(json.environment);
            }
            if (json.datasetId != null) {
                builder.datasetId(json.datasetId);
            }
            if (json.datasetVersion != null) {
                builder.datasetVersion(json.datasetVersion);
            }
            if (json.user != null) {
                builder.user(json.user);
            }
            if (json.report != null) {
                builder.report(json.report);
            }
            if (json.executionId != null) {
                builder.executionId(json.executionId);
            }
            return builder.build();
        }

        public static Execution copyOf(ExecutionHistory.Execution instance) {
            if (instance instanceof Execution) {
                return (Execution)instance;
            }
            return Execution.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_TIME = 1L;
            private static final long INIT_BIT_DURATION = 2L;
            private static final long INIT_BIT_STATUS = 4L;
            private static final long INIT_BIT_TEST_CASE_TITLE = 8L;
            private static final long INIT_BIT_ENVIRONMENT = 16L;
            private static final long INIT_BIT_USER = 32L;
            private static final long INIT_BIT_REPORT = 64L;
            private static final long INIT_BIT_EXECUTION_ID = 128L;
            private long initBits = 255L;
            @Nullable
            private LocalDateTime time;
            private long duration;
            @Nullable
            private ServerReportStatus status;
            @Nullable
            private String info;
            @Nullable
            private String error;
            @Nullable
            private String testCaseTitle;
            @Nullable
            private String environment;
            @Nullable
            private String datasetId;
            @Nullable
            private Integer datasetVersion;
            @Nullable
            private String user;
            @Nullable
            private String report;
            @Nullable
            private Long executionId;

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(ExecutionHistory.Attached instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder from(ExecutionHistory.ExecutionProperties instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder from(HavingReport instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder from(ExecutionHistory.Execution instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                Object instance;
                if (object instanceof ExecutionHistory.Attached) {
                    instance = (ExecutionHistory.Attached)object;
                    this.executionId(instance.executionId());
                }
                if (object instanceof ExecutionHistory.ExecutionProperties) {
                    Optional<String> datasetIdOptional;
                    instance = (ExecutionHistory.ExecutionProperties)object;
                    this.duration(instance.duration());
                    this.environment(instance.environment());
                    Optional<Integer> datasetVersionOptional = instance.datasetVersion();
                    if (datasetVersionOptional.isPresent()) {
                        this.datasetVersion(datasetVersionOptional);
                    }
                    if ((datasetIdOptional = instance.datasetId()).isPresent()) {
                        this.datasetId(datasetIdOptional);
                    }
                    this.time(instance.time());
                    Optional<String> errorOptional = instance.error();
                    if (errorOptional.isPresent()) {
                        this.error(errorOptional);
                    }
                    this.testCaseTitle(instance.testCaseTitle());
                    this.user(instance.user());
                    this.status(instance.status());
                    Optional<String> infoOptional = instance.info();
                    if (infoOptional.isPresent()) {
                        this.info(infoOptional);
                    }
                }
                if (object instanceof HavingReport) {
                    instance = (HavingReport)object;
                    this.report(instance.report());
                }
            }

            @CanIgnoreReturnValue
            public final Builder time(LocalDateTime time) {
                this.time = Objects.requireNonNull(time, "time");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder duration(long duration) {
                this.duration = duration;
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder status(ServerReportStatus status) {
                this.status = Objects.requireNonNull(status, "status");
                this.initBits &= 0xFFFFFFFFFFFFFFFBL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder info(String info) {
                this.info = Objects.requireNonNull(info, "info");
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder info(Optional<String> info) {
                this.info = info.orElse(null);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder error(String error) {
                this.error = Objects.requireNonNull(error, "error");
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder error(Optional<String> error) {
                this.error = error.orElse(null);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder testCaseTitle(String testCaseTitle) {
                this.testCaseTitle = Objects.requireNonNull(testCaseTitle, "testCaseTitle");
                this.initBits &= 0xFFFFFFFFFFFFFFF7L;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder environment(String environment) {
                this.environment = Objects.requireNonNull(environment, "environment");
                this.initBits &= 0xFFFFFFFFFFFFFFEFL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder datasetId(String datasetId) {
                this.datasetId = Objects.requireNonNull(datasetId, "datasetId");
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder datasetId(Optional<String> datasetId) {
                this.datasetId = datasetId.orElse(null);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder datasetVersion(int datasetVersion) {
                this.datasetVersion = datasetVersion;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder datasetVersion(Optional<Integer> datasetVersion) {
                this.datasetVersion = datasetVersion.orElse(null);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder user(String user) {
                this.user = Objects.requireNonNull(user, "user");
                this.initBits &= 0xFFFFFFFFFFFFFFDFL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder report(String report) {
                this.report = Objects.requireNonNull(report, "report");
                this.initBits &= 0xFFFFFFFFFFFFFFBFL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder executionId(Long executionId) {
                this.executionId = Objects.requireNonNull(executionId, "executionId");
                this.initBits &= 0xFFFFFFFFFFFFFF7FL;
                return this;
            }

            public Execution build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new Execution(this.time, this.duration, this.status, this.info, this.error, this.testCaseTitle, this.environment, this.datasetId, this.datasetVersion, this.user, this.report, this.executionId);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList attributes = Lists.newArrayList();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("time");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("duration");
                }
                if ((this.initBits & 4L) != 0L) {
                    attributes.add("status");
                }
                if ((this.initBits & 8L) != 0L) {
                    attributes.add("testCaseTitle");
                }
                if ((this.initBits & 0x10L) != 0L) {
                    attributes.add("environment");
                }
                if ((this.initBits & 0x20L) != 0L) {
                    attributes.add("user");
                }
                if ((this.initBits & 0x40L) != 0L) {
                    attributes.add("report");
                }
                if ((this.initBits & 0x80L) != 0L) {
                    attributes.add("executionId");
                }
                return "Cannot build Execution, some of required attributes are not set " + attributes;
            }
        }

        @Deprecated
        @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
        static final class Json
        implements ExecutionHistory.Execution {
            @Nullable
            LocalDateTime time;
            long duration;
            boolean durationIsSet;
            @Nullable
            ServerReportStatus status;
            @Nullable
            Optional<String> info = Optional.empty();
            @Nullable
            Optional<String> error = Optional.empty();
            @Nullable
            String testCaseTitle;
            @Nullable
            String environment;
            @Nullable
            Optional<String> datasetId = Optional.empty();
            @Nullable
            Optional<Integer> datasetVersion = Optional.empty();
            @Nullable
            String user;
            @Nullable
            String report;
            @Nullable
            Long executionId;

            Json() {
            }

            @JsonProperty(value="time")
            public void setTime(LocalDateTime time) {
                this.time = time;
            }

            @JsonProperty(value="duration")
            public void setDuration(long duration) {
                this.duration = duration;
                this.durationIsSet = true;
            }

            @JsonProperty(value="status")
            public void setStatus(ServerReportStatus status) {
                this.status = status;
            }

            @JsonProperty(value="info")
            public void setInfo(Optional<String> info) {
                this.info = info;
            }

            @JsonProperty(value="error")
            public void setError(Optional<String> error) {
                this.error = error;
            }

            @JsonProperty(value="testCaseTitle")
            public void setTestCaseTitle(String testCaseTitle) {
                this.testCaseTitle = testCaseTitle;
            }

            @JsonProperty(value="environment")
            public void setEnvironment(String environment) {
                this.environment = environment;
            }

            @JsonProperty(value="datasetId")
            public void setDatasetId(Optional<String> datasetId) {
                this.datasetId = datasetId;
            }

            @JsonProperty(value="datasetVersion")
            public void setDatasetVersion(Optional<Integer> datasetVersion) {
                this.datasetVersion = datasetVersion;
            }

            @JsonProperty(value="user")
            public void setUser(String user) {
                this.user = user;
            }

            @JsonProperty(value="report")
            public void setReport(String report) {
                this.report = report;
            }

            @JsonProperty(value="executionId")
            public void setExecutionId(Long executionId) {
                this.executionId = executionId;
            }

            @Override
            public LocalDateTime time() {
                throw new UnsupportedOperationException();
            }

            @Override
            public long duration() {
                throw new UnsupportedOperationException();
            }

            @Override
            public ServerReportStatus status() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Optional<String> info() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Optional<String> error() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String testCaseTitle() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String environment() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Optional<String> datasetId() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Optional<Integer> datasetVersion() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String user() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String report() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Long executionId() {
                throw new UnsupportedOperationException();
            }
        }
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SCENARIO_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private String scenarioId;
        private ImmutableList.Builder<ExecutionHistory.Execution> history = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ExecutionHistory instance) {
            Objects.requireNonNull(instance, "instance");
            this.scenarioId(instance.scenarioId());
            this.addAllHistory(instance.history());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder scenarioId(String scenarioId) {
            this.scenarioId = Objects.requireNonNull(scenarioId, "scenarioId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addHistory(ExecutionHistory.Execution element) {
            this.history.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addHistory(ExecutionHistory.Execution ... elements) {
            this.history.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder history(Iterable<? extends ExecutionHistory.Execution> elements) {
            this.history = ImmutableList.builder();
            return this.addAllHistory(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllHistory(Iterable<? extends ExecutionHistory.Execution> elements) {
            this.history.addAll(elements);
            return this;
        }

        public ImmutableExecutionHistory build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableExecutionHistory(null, this.scenarioId, (ImmutableList<ExecutionHistory.Execution>)this.history.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("scenarioId");
            }
            return "Cannot build ExecutionHistory, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements ExecutionHistory {
        @Nullable
        String scenarioId;
        @Nullable
        List<ExecutionHistory.Execution> history = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="scenarioId")
        public void setScenarioId(String scenarioId) {
            this.scenarioId = scenarioId;
        }

        @JsonProperty(value="history")
        public void setHistory(List<ExecutionHistory.Execution> history) {
            this.history = history;
        }

        @Override
        public String scenarioId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<ExecutionHistory.Execution> history() {
            throw new UnsupportedOperationException();
        }
    }
}

