/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.execution.domain.compiler;

import com.chutneytesting.design.domain.scenario.TestCase;
import com.chutneytesting.execution.domain.ExecutionRequest;
import com.chutneytesting.execution.domain.compiler.TestCasePreProcessor;
import java.util.Collections;
import java.util.List;

public class TestCasePreProcessors {
    private final List<TestCasePreProcessor> processors;

    public TestCasePreProcessors(List<TestCasePreProcessor> processors) {
        this.processors = Collections.unmodifiableList(processors);
    }

    public <T extends TestCase> T apply(ExecutionRequest executionRequest) {
        TestCase tmp = executionRequest.testCase;
        for (TestCasePreProcessor p : this.processors) {
            if (!p.test(tmp)) continue;
            tmp = p.apply(executionRequest);
        }
        return (T)tmp;
    }
}

