/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.execution.domain.compiler;

import com.chutneytesting.design.domain.scenario.TestCase;
import com.chutneytesting.execution.domain.ExecutionRequest;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public interface TestCasePreProcessor<T extends TestCase> {
    public static final Pattern aliasPattern = Pattern.compile("^\\*\\*(.+)\\*\\*$");

    public T apply(ExecutionRequest var1);

    default public boolean test(T testCase) {
        Type type = ((ParameterizedType)this.getClass().getGenericInterfaces()[0]).getActualTypeArguments()[0];
        return ((Class)type).isAssignableFrom(testCase.getClass());
    }

    default public String replaceParams(String parameterizedString, Map<String, String> globalDataSet, Map<String, String> dataSet) {
        String concreteString = this.replaceParams(dataSet, parameterizedString, Function.identity());
        return this.replaceParams(globalDataSet, concreteString, Function.identity());
    }

    default public String replaceParams(String parameterizedString, Map<String, String> globalDataSet, Map<String, String> dataSet, Function<String, String> escapeValueFunction) {
        String concreteString = this.replaceParams(dataSet, parameterizedString, escapeValueFunction);
        return this.replaceParams(globalDataSet, concreteString, escapeValueFunction);
    }

    default public String replaceParams(Map<String, String> dataSet, String concreteString, Function<String, String> escapeValueFunction) {
        String stringReplaced = concreteString;
        for (Map.Entry<String, String> entry : dataSet.entrySet()) {
            stringReplaced = stringReplaced.replace("**" + entry.getKey() + "**", escapeValueFunction.apply(entry.getValue()));
        }
        return stringReplaced;
    }

    default public void makeEnvironmentNameAsGlobalVariable(Map<String, String> globalVariable, String environment) {
        if (environment != null && !environment.isEmpty()) {
            globalVariable.put("environment", environment);
        }
    }

    default public boolean isAlias(String paramValue) {
        return aliasPattern.matcher(paramValue).matches();
    }

    default public Map<String, String> buildDatasetWithAliases(Map<String, String> dataSet) {
        Map<String, String> aliases = dataSet.entrySet().stream().filter(o -> this.isAlias((String)o.getValue())).collect(Collectors.toMap(a -> ((String)a.getValue()).substring(2, ((String)a.getValue()).length() - 2), o -> ""));
        aliases.putAll(dataSet);
        return Collections.unmodifiableMap(aliases);
    }
}

