/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.execution.domain.compiler;

import com.chutneytesting.design.domain.dataset.DataSetRepository;
import com.chutneytesting.design.domain.globalvar.GlobalvarRepository;
import com.chutneytesting.execution.domain.ExecutionRequest;
import com.chutneytesting.execution.domain.compiler.ComposedTestCaseIterationsPreProcessor;
import com.chutneytesting.execution.domain.compiler.ComposedTestCaseLoopPreProcessor;
import com.chutneytesting.execution.domain.compiler.ComposedTestCaseParametersResolutionPreProcessor;
import com.chutneytesting.execution.domain.compiler.TestCasePreProcessor;
import com.chutneytesting.execution.domain.scenario.composed.ExecutableComposedTestCase;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.stereotype.Component;

@Component
public class ComposedTestCasePreProcessor
implements TestCasePreProcessor<ExecutableComposedTestCase> {
    private final ComposedTestCaseParametersResolutionPreProcessor parametersResolutionPreProcessor;
    private final ComposedTestCaseLoopPreProcessor loopPreProcessor;
    private final ComposedTestCaseIterationsPreProcessor dataSetPreProcessor;

    public ComposedTestCasePreProcessor(ObjectMapper objectMapper, GlobalvarRepository globalvarRepository, DataSetRepository dataSetRepository) {
        this.parametersResolutionPreProcessor = new ComposedTestCaseParametersResolutionPreProcessor(globalvarRepository, objectMapper);
        this.loopPreProcessor = new ComposedTestCaseLoopPreProcessor(objectMapper);
        this.dataSetPreProcessor = new ComposedTestCaseIterationsPreProcessor(dataSetRepository);
    }

    @Override
    public ExecutableComposedTestCase apply(ExecutionRequest executionRequest) {
        String environment = executionRequest.environment;
        String userId = executionRequest.userId;
        ExecutableComposedTestCase testCase = (ExecutableComposedTestCase)executionRequest.testCase;
        if (executionRequest.withExternalDataset) {
            testCase = this.dataSetPreProcessor.apply(new ExecutionRequest(testCase, environment, userId));
        }
        testCase = this.loopPreProcessor.apply(new ExecutionRequest(this.parametersResolutionPreProcessor.applyOnStrategy(testCase, environment), environment, userId));
        return this.parametersResolutionPreProcessor.apply(new ExecutionRequest(testCase, environment, userId));
    }
}

