/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.execution.domain.compiler;

import com.chutneytesting.design.domain.globalvar.GlobalvarRepository;
import com.chutneytesting.design.domain.scenario.TestCaseMetadata;
import com.chutneytesting.design.domain.scenario.TestCaseMetadataImpl;
import com.chutneytesting.design.domain.scenario.compose.Strategy;
import com.chutneytesting.execution.domain.ExecutionRequest;
import com.chutneytesting.execution.domain.compiler.TestCasePreProcessor;
import com.chutneytesting.execution.domain.scenario.composed.ExecutableComposedScenario;
import com.chutneytesting.execution.domain.scenario.composed.ExecutableComposedStep;
import com.chutneytesting.execution.domain.scenario.composed.ExecutableComposedTestCase;
import com.chutneytesting.execution.domain.scenario.composed.StepImplementation;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComposedTestCaseParametersResolutionPreProcessor
implements TestCasePreProcessor<ExecutableComposedTestCase> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComposedTestCaseParametersResolutionPreProcessor.class);
    private final GlobalvarRepository globalvarRepository;
    private final ObjectMapper objectMapper;

    ComposedTestCaseParametersResolutionPreProcessor(GlobalvarRepository globalvarRepository, ObjectMapper objectMapper) {
        this.globalvarRepository = globalvarRepository;
        this.objectMapper = objectMapper;
    }

    @Override
    public ExecutableComposedTestCase apply(ExecutionRequest executionRequest) {
        ExecutableComposedTestCase testCase = (ExecutableComposedTestCase)executionRequest.testCase;
        Map<String, String> globalVariable = this.globalvarRepository.getFlatMap();
        this.makeEnvironmentNameAsGlobalVariable(globalVariable, executionRequest.environment);
        return new ExecutableComposedTestCase(this.applyToMetadata(testCase.metadata, testCase.computedParameters, globalVariable), this.applyToScenario(testCase.composedScenario, testCase.computedParameters, globalVariable), testCase.computedParameters);
    }

    public ExecutableComposedTestCase applyOnStrategy(ExecutableComposedTestCase testCase, String environment) {
        Map<String, String> globalVariable = this.globalvarRepository.getFlatMap();
        this.makeEnvironmentNameAsGlobalVariable(globalVariable, environment);
        Map<String, String> testCaseDataSet = this.applyOnCurrentStepDataSet(testCase.computedParameters, Collections.emptyMap(), globalVariable);
        return new ExecutableComposedTestCase(testCase.metadata, this.applyOnStrategy(testCase.composedScenario, testCaseDataSet, globalVariable), testCaseDataSet);
    }

    private TestCaseMetadata applyToMetadata(TestCaseMetadata metadata, Map<String, String> dataSet, Map<String, String> globalVariable) {
        return TestCaseMetadataImpl.TestCaseMetadataBuilder.from(metadata).withTitle(this.replaceParams(metadata.title(), globalVariable, dataSet)).withDescription(this.replaceParams(metadata.description(), globalVariable, dataSet)).build();
    }

    private ExecutableComposedScenario applyToScenario(ExecutableComposedScenario composedScenario, Map<String, String> testCaseDataSet, Map<String, String> globalVariable) {
        return ExecutableComposedScenario.builder().withComposedSteps(composedScenario.composedSteps.stream().map(step -> this.applyToComposedStep((ExecutableComposedStep)step, testCaseDataSet, globalVariable)).collect(Collectors.toList())).withParameters(composedScenario.parameters).build();
    }

    private ExecutableComposedStep applyToComposedStep(ExecutableComposedStep composedStep, Map<String, String> parentDataset, Map<String, String> globalVariable) {
        Map<String, String> scopedDataset = this.applyOnCurrentStepDataSet(composedStep.dataset, parentDataset, globalVariable);
        List<ExecutableComposedStep> subSteps = composedStep.steps;
        return ExecutableComposedStep.builder().withName(this.replaceParams(composedStep.name, globalVariable, scopedDataset)).withSteps(subSteps.stream().map(f -> this.applyToComposedStep((ExecutableComposedStep)f, scopedDataset, globalVariable)).collect(Collectors.toList())).withImplementation(composedStep.stepImplementation.flatMap(si -> this.applyToImplementation((StepImplementation)si, scopedDataset, globalVariable))).withStrategy(composedStep.strategy).withDataset(scopedDataset).build();
    }

    private Optional<StepImplementation> applyToImplementation(StepImplementation stepImplementation, Map<String, String> scopedDataset, Map<String, String> globalVariable) {
        try {
            String blob = this.replaceParams(this.objectMapper.writeValueAsString((Object)stepImplementation), globalVariable, scopedDataset, StringEscapeUtils::escapeJson);
            StepImplementation impl = (StepImplementation)this.objectMapper.readValue(blob, StepImplementation.class);
            return Optional.ofNullable(impl);
        }
        catch (IOException e) {
            LOGGER.error("Error reading step implementation", (Throwable)e);
            return Optional.ofNullable(stepImplementation);
        }
    }

    private Map<String, String> applyOnCurrentStepDataSet(Map<String, String> currentStepDataset, Map<String, String> parentDataset, Map<String, String> globalVariables) {
        HashMap<String, String> scopedDataset = new HashMap<String, String>();
        Map<Boolean, List<Map.Entry>> splitDataSet = currentStepDataset.entrySet().stream().collect(Collectors.groupingBy(o -> StringUtils.isBlank((CharSequence)((CharSequence)o.getValue()))));
        Optional.ofNullable(splitDataSet.get(true)).ifPresent(l -> l.forEach(e -> scopedDataset.put((String)e.getKey(), Optional.ofNullable((String)parentDataset.get(e.getKey())).orElse(""))));
        Optional.ofNullable(splitDataSet.get(false)).ifPresent(l -> l.forEach(e -> scopedDataset.put((String)e.getKey(), this.replaceParams((String)e.getValue(), globalVariables, parentDataset))));
        return scopedDataset;
    }

    private ExecutableComposedScenario applyOnStrategy(ExecutableComposedScenario composedScenario, Map<String, String> testCaseDataSet, Map<String, String> globalVariable) {
        return ExecutableComposedScenario.builder().withComposedSteps(composedScenario.composedSteps.stream().map(step -> this.applyOnStepStrategy((ExecutableComposedStep)step, testCaseDataSet, globalVariable)).collect(Collectors.toList())).withParameters(composedScenario.parameters).build();
    }

    private ExecutableComposedStep applyOnStepStrategy(ExecutableComposedStep composedStep, Map<String, String> parentDataset, Map<String, String> globalVariable) {
        Map<String, String> scopedDataset = this.applyOnCurrentStepDataSet(composedStep.dataset, parentDataset, globalVariable);
        return ExecutableComposedStep.builder().withName(composedStep.name).withSteps(composedStep.steps.stream().map(f -> this.applyOnStepStrategy((ExecutableComposedStep)f, scopedDataset, globalVariable)).collect(Collectors.toList())).withImplementation(composedStep.stepImplementation).withStrategy(this.applyToStrategy(composedStep.strategy, scopedDataset, globalVariable)).withDataset(composedStep.dataset).build();
    }

    private Strategy applyToStrategy(Strategy strategy, Map<String, String> scopedDataset, Map<String, String> globalVariable) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        strategy.parameters.forEach((key, value) -> parameters.put((String)key, this.replaceParams(value.toString(), scopedDataset, globalVariable)));
        return new Strategy(strategy.type, parameters);
    }
}

