/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.execution.domain.compiler;

import com.chutneytesting.design.domain.dataset.DataSet;
import com.chutneytesting.design.domain.dataset.DataSetRepository;
import com.chutneytesting.design.domain.scenario.compose.Strategy;
import com.chutneytesting.execution.domain.ExecutionRequest;
import com.chutneytesting.execution.domain.compiler.TestCasePreProcessor;
import com.chutneytesting.execution.domain.scenario.composed.ExecutableComposedScenario;
import com.chutneytesting.execution.domain.scenario.composed.ExecutableComposedStep;
import com.chutneytesting.execution.domain.scenario.composed.ExecutableComposedTestCase;
import com.chutneytesting.execution.domain.scenario.composed.StepImplementation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.text.StringEscapeUtils;

public class ComposedTestCaseIterationsPreProcessor
implements TestCasePreProcessor<ExecutableComposedTestCase> {
    private final DataSetRepository dataSetRepository;

    ComposedTestCaseIterationsPreProcessor(DataSetRepository dataSetRepository) {
        this.dataSetRepository = dataSetRepository;
    }

    @Override
    public ExecutableComposedTestCase apply(ExecutionRequest executionRequest) {
        ExecutableComposedTestCase testCase = (ExecutableComposedTestCase)executionRequest.testCase;
        return this.apply(testCase);
    }

    ExecutableComposedTestCase apply(ExecutableComposedTestCase testCase) {
        Optional<DataSet> oDataset = testCase.metadata.datasetId().map(this.dataSetRepository::findById);
        if (!oDataset.isPresent()) {
            return testCase;
        }
        DataSet dataset = oDataset.get();
        Map<Boolean, List<String>> matchedHeaders = this.findMultipleValuesHeadersMatchingComputedParams(testCase, dataset.multipleValues);
        return new ExecutableComposedTestCase(testCase.metadata, this.applyToScenario(testCase.composedScenario, matchedHeaders, dataset), this.applyToComputedParameters(testCase.computedParameters, matchedHeaders.get(Boolean.TRUE), dataset));
    }

    private Map<Boolean, List<String>> findMultipleValuesHeadersMatchingComputedParams(ExecutableComposedTestCase testCase, List<Map<String, String>> multipleValues) {
        Map<Boolean, List<String>> matchedHeaders = new HashMap<Boolean, List<String>>();
        if (!multipleValues.isEmpty()) {
            Set<String> valuesHeaders = multipleValues.get(0).keySet();
            matchedHeaders = testCase.computedParameters.keySet().stream().collect(Collectors.groupingBy(valuesHeaders::contains));
        }
        matchedHeaders.putIfAbsent(Boolean.TRUE, Collections.emptyList());
        matchedHeaders.putIfAbsent(Boolean.FALSE, Collections.emptyList());
        return matchedHeaders;
    }

    private Map<String, String> applyToComputedParameters(Map<String, String> computedParameters, List<String> matchedHeaders, DataSet dataSet) {
        HashMap<String, String> parameters = new HashMap<String, String>(computedParameters);
        Map<String, String> uniqueValues = dataSet.uniqueValues;
        computedParameters.keySet().stream().filter(uniqueValues::containsKey).forEach(key -> parameters.put((String)key, (String)uniqueValues.get(key)));
        computedParameters.keySet().stream().filter(matchedHeaders::contains).forEach(parameters::remove);
        return parameters;
    }

    private ExecutableComposedScenario applyToScenario(ExecutableComposedScenario composedScenario, Map<Boolean, List<String>> matchedHeaders, DataSet dataSet) {
        HashMap iterationOutputs = new HashMap();
        return ExecutableComposedScenario.builder().withComposedSteps(composedScenario.composedSteps.stream().map(cs -> this.applyToStep((ExecutableComposedStep)cs, matchedHeaders, dataSet, iterationOutputs)).collect(Collectors.toList())).withParameters(composedScenario.parameters).build();
    }

    private ExecutableComposedStep applyToStep(ExecutableComposedStep composedStep, Map<Boolean, List<String>> matchedHeaders, DataSet dataset, Map<String, Integer> iterationOutputs) {
        Set<String> csNovaluedEntries = this.findComposedStepNoValuedMatchedEntries(composedStep.dataset, matchedHeaders.get(Boolean.TRUE));
        Map<String, Set<String>> csValuedEntriesWithRef = this.findComposedStepValuedEntriesWithRef(composedStep.dataset, matchedHeaders.get(Boolean.TRUE));
        Map<String, Integer> usedIndexedOutput = this.findUsageOfPreviousOutput(composedStep, iterationOutputs);
        Map<String, Integer> usedIndexedOutputInDataset = this.findUsageOfPreviousOutputInDataset(composedStep, iterationOutputs);
        if (csNovaluedEntries.isEmpty() && csValuedEntriesWithRef.isEmpty() && usedIndexedOutput.isEmpty() && usedIndexedOutputInDataset.isEmpty()) {
            this.removeObsoleteIndexedOutputs(iterationOutputs, composedStep);
            return composedStep;
        }
        Map<String, String> csLeftEntries = composedStep.dataset.entrySet().stream().filter(e -> ((String)e.getValue()).isEmpty()).filter(e -> !csNovaluedEntries.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        matchedHeaders.get(Boolean.FALSE).forEach(s -> csLeftEntries.put((String)s, ""));
        return ExecutableComposedStep.builder().from(composedStep).withImplementation(Optional.empty()).withStrategy(new Strategy("dataset-iterations-strategy", Collections.emptyMap())).withSteps(this.buildStepIterations(composedStep, csNovaluedEntries, csValuedEntriesWithRef, dataset.multipleValues, iterationOutputs)).withDataset(this.buildDatasetWithAliases(csLeftEntries)).build();
    }

    private Map<String, Integer> findUsageOfPreviousOutputInDataset(ExecutableComposedStep composedStep, Map<String, Integer> iterationOutputs) {
        return iterationOutputs.entrySet().stream().filter(previousOutput -> composedStep.dataset.entrySet().stream().anyMatch(input -> ((String)input.getKey()).contains("#" + (String)previousOutput.getKey()) || this.usePreviousIterationOutput((String)previousOutput.getKey(), (String)input.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Map<String, Integer> findUsageOfPreviousOutput(ExecutableComposedStep composedStep, Map<String, Integer> iterationOutputs) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        composedStep.stepImplementation.ifPresent(si -> map.putAll(iterationOutputs.entrySet().stream().filter(previousOutput -> this.contains((String)previousOutput.getKey(), si.inputs) || this.contains((String)previousOutput.getKey(), si.outputs)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))));
        return map;
    }

    private boolean contains(String previousOutput, Map<String, Object> map) {
        return map.entrySet().stream().anyMatch(entry -> ((String)entry.getKey()).contains("#" + previousOutput) || this.usePreviousIterationOutput(previousOutput, entry.getValue()));
    }

    private boolean usePreviousIterationOutput(String previousOutput, Object value) {
        if (value instanceof String) {
            return this.usePreviousIterationOutput(previousOutput, (String)value);
        }
        if (value instanceof Map) {
            return this.usePreviousIterationOutput(previousOutput, (Map)value);
        }
        return false;
    }

    private boolean usePreviousIterationOutput(String previousOutput, String value) {
        return value.contains("#" + previousOutput);
    }

    private boolean usePreviousIterationOutput(String previousOutput, Map<String, String> value) {
        return value.entrySet().stream().anyMatch(e -> ((String)e.getKey()).contains("#" + previousOutput) || this.usePreviousIterationOutput(previousOutput, (String)e.getValue()));
    }

    private Set<String> findComposedStepNoValuedMatchedEntries(Map<String, String> csDataset, List<String> matchedHeaders) {
        return csDataset.entrySet().stream().filter(e -> ((String)e.getValue()).isEmpty() && matchedHeaders.contains(e.getKey())).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    private Map<String, Set<String>> findComposedStepValuedEntriesWithRef(Map<String, String> csDataSet, List<String> matchedHeaders) {
        HashMap<String, Set<String>> valuedEntriesWithRef = new HashMap<String, Set<String>>();
        for (Map.Entry<String, String> csData : csDataSet.entrySet()) {
            String value = csData.getValue();
            for (String matchedHeader : matchedHeaders) {
                if (!value.contains("**" + matchedHeader + "**")) continue;
                valuedEntriesWithRef.putIfAbsent(csData.getKey(), new HashSet());
                valuedEntriesWithRef.get(csData.getKey()).add(matchedHeader);
            }
        }
        return valuedEntriesWithRef;
    }

    private List<ExecutableComposedStep> buildStepIterations(ExecutableComposedStep composedStep, Set<String> csNovaluedEntries, Map<String, Set<String>> csValuedEntriesWithRef, List<Map<String, String>> multipleValues, Map<String, Integer> iterationOutputs) {
        AtomicInteger index = new AtomicInteger(0);
        List<ExecutableComposedStep> iterations = this.generateIterationsForMultipleValues(composedStep, multipleValues, csNovaluedEntries, csValuedEntriesWithRef, iterationOutputs, index);
        if (iterations.isEmpty()) {
            iterations = this.generateIterationsForPreviousIterationOutputs(composedStep, iterationOutputs, index);
        }
        if (iterations.isEmpty()) {
            iterations = this.generateIterationsForPreviousIterationOutputsInDataset(composedStep, iterationOutputs, index);
        }
        this.rememberIterationsCountForEachOutput(iterationOutputs, index);
        this.updateIndexedOutputsUsingDatasetValues(iterationOutputs, composedStep);
        return iterations;
    }

    private List<ExecutableComposedStep> generateIterationsForMultipleValues(ExecutableComposedStep composedStep, List<Map<String, String>> multipleValues, Set<String> csNovaluedEntries, Map<String, Set<String>> csValuedEntriesWithRef, Map<String, Integer> iterationOutputs, AtomicInteger index) {
        List<Map<String, String>> iterationData = this.findUsageOfDatasetMultipleValues(csNovaluedEntries, csValuedEntriesWithRef, multipleValues);
        return iterationData.stream().map(mv -> {
            index.getAndIncrement();
            return ExecutableComposedStep.builder().from(composedStep).withImplementation(composedStep.stepImplementation.flatMap(si -> Optional.of(this.indexIterationIO((StepImplementation)si, index, iterationOutputs)))).withName(composedStep.name + " - dataset iteration " + index).withDataset(this.applyIndexedOutputs(this.updatedDatasetUsingCurrentValue(composedStep.dataset, csNovaluedEntries, csValuedEntriesWithRef, (Map<String, String>)mv), index, iterationOutputs)).withSteps(composedStep.steps.stream().map(s -> ExecutableComposedStep.builder().from((ExecutableComposedStep)s).withImplementation(s.stepImplementation.flatMap(si -> Optional.of(this.indexIterationIO((StepImplementation)si, index, iterationOutputs)))).withDataset(this.applyIndexedOutputs(s.dataset, index, iterationOutputs)).build()).collect(Collectors.toList())).build();
        }).collect(Collectors.toList());
    }

    private List<Map<String, String>> findUsageOfDatasetMultipleValues(Set<String> csNovaluedEntries, Map<String, Set<String>> csValuedEntriesWithRef, List<Map<String, String>> multipleValues) {
        Set dataSetEntriesReferenced = csValuedEntriesWithRef.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        return multipleValues.stream().map(mv -> mv.entrySet().stream().filter(e -> csNovaluedEntries.contains(e.getKey()) || dataSetEntriesReferenced.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).distinct().filter(mv -> !mv.isEmpty()).collect(Collectors.toList());
    }

    private List<ExecutableComposedStep> generateIterationsForPreviousIterationOutputs(ExecutableComposedStep composedStep, Map<String, Integer> iterationOutputs, AtomicInteger index) {
        Map<String, Integer> previousOutputs = this.findUsageOfPreviousOutput(composedStep, iterationOutputs);
        int iterationsCount = previousOutputs.values().stream().findFirst().orElse(0);
        ArrayList<ExecutableComposedStep> generatedIterations = new ArrayList<ExecutableComposedStep>();
        for (int i = 0; i < iterationsCount; ++i) {
            index.getAndIncrement();
            generatedIterations.add(ExecutableComposedStep.builder().from(composedStep).withImplementation(composedStep.stepImplementation.flatMap(si -> Optional.of(this.indexIterationIO((StepImplementation)si, index, iterationOutputs)))).withName(composedStep.name + " - dataset iteration " + index).withDataset(composedStep.dataset).build());
        }
        return generatedIterations;
    }

    private List<ExecutableComposedStep> generateIterationsForPreviousIterationOutputsInDataset(ExecutableComposedStep composedStep, Map<String, Integer> iterationOutputs, AtomicInteger index) {
        Map<String, Integer> previousOutputs = this.findUsageOfPreviousOutputInDataset(composedStep, iterationOutputs);
        int iterationsCount = previousOutputs.values().stream().findFirst().orElse(0);
        ArrayList<ExecutableComposedStep> generatedIterations = new ArrayList<ExecutableComposedStep>();
        for (int i = 0; i < iterationsCount; ++i) {
            index.getAndIncrement();
            generatedIterations.add(ExecutableComposedStep.builder().from(composedStep).withImplementation(composedStep.stepImplementation.flatMap(si -> Optional.of(this.indexIterationIO((StepImplementation)si, index, iterationOutputs)))).withName(composedStep.name + " - dataset iteration " + index).withDataset(this.applyIndexedOutputs(composedStep.dataset, index, iterationOutputs)).build());
        }
        return generatedIterations;
    }

    private Map<String, String> updatedDatasetUsingCurrentValue(Map<String, String> dataset, Set<String> csNovaluedEntries, Map<String, Set<String>> csValuedEntriesWithRef, Map<String, String> mv) {
        HashMap<String, String> newDataSet = new HashMap<String, String>(dataset);
        dataset.forEach((k, v) -> {
            if (csNovaluedEntries.contains(k)) {
                newDataSet.put((String)k, (String)mv.get(k));
            } else if (csValuedEntriesWithRef.containsKey(k)) {
                newDataSet.put((String)k, this.replaceParams((String)v, Collections.emptyMap(), mv));
            }
        });
        return newDataSet;
    }

    private StepImplementation indexIterationIO(StepImplementation si, AtomicInteger index, Map<String, Integer> iterationOutputs) {
        this.rememberIndexedOutput(iterationOutputs, si.outputs);
        return new StepImplementation(si.type, si.target, this.indexInputs(si.inputs, index, iterationOutputs), this.indexOutputs(si.outputs, index, iterationOutputs));
    }

    private void rememberIndexedOutput(Map<String, Integer> iterationOutputs, Map<String, Object> outputs) {
        Map<String, Integer> collect = outputs.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> 0));
        iterationOutputs.putAll(collect);
    }

    private void rememberIterationsCountForEachOutput(Map<String, Integer> iterationOutputs, AtomicInteger index) {
        iterationOutputs.replaceAll((k, v) -> {
            v = index.get();
            return v;
        });
    }

    private void updateIndexedOutputsUsingDatasetValues(Map<String, Integer> iterationOutputs, ExecutableComposedStep composedStep) {
        ArrayList<ExecutableComposedStep> steps = new ArrayList<ExecutableComposedStep>(composedStep.steps);
        Collections.reverse(steps);
        steps.forEach(executableComposedStep -> this.updateIndexedOutputsUsingDatasetValues(iterationOutputs, (ExecutableComposedStep)executableComposedStep));
        composedStep.dataset.entrySet().stream().filter(entry -> iterationOutputs.containsKey("**" + (String)entry.getKey() + "**")).forEach(entry -> {
            Integer iterationsCount = (Integer)iterationOutputs.get("**" + (String)entry.getKey() + "**");
            iterationOutputs.remove("**" + (String)entry.getKey() + "**");
            iterationOutputs.put(composedStep.dataset.get(entry.getKey()), iterationsCount);
        });
    }

    private void removeObsoleteIndexedOutputs(Map<String, Integer> iterationOutputs, ExecutableComposedStep composedStep) {
        ArrayList list = new ArrayList();
        composedStep.stepImplementation.ifPresent(si -> list.addAll(si.outputs.keySet()));
        if (list.isEmpty()) {
            composedStep.steps.forEach(executableComposedStep -> this.removeObsoleteIndexedOutputs(iterationOutputs, (ExecutableComposedStep)executableComposedStep));
        } else {
            composedStep.dataset.entrySet().stream().filter(entry -> list.contains("**" + (String)entry.getKey() + "**")).forEach(entry -> {
                list.remove("**" + (String)entry.getKey() + "**");
                list.add((String)entry.getValue());
            });
            list.stream().filter(item -> iterationOutputs.containsKey(item)).forEach(item -> iterationOutputs.remove(item));
        }
    }

    private Map<String, Object> indexInputs(Map<String, Object> inputs, AtomicInteger index, Map<String, Integer> iterationOutputs) {
        return inputs.entrySet().stream().collect(HashMap::new, (m, e) -> m.put(this.applyIndexedOutputsOnStringValue((String)e.getKey(), index, iterationOutputs), this.applyIndexedOutputs(e.getValue(), index, iterationOutputs)), HashMap::putAll);
    }

    private Map<String, Object> indexOutputs(Map<String, Object> outputs, AtomicInteger index, Map<String, Integer> iterationOutputs) {
        return outputs.entrySet().stream().collect(HashMap::new, (m, e) -> m.put((String)e.getKey() + "_" + index, this.applyIndexedOutputs(e.getValue(), index, iterationOutputs)), HashMap::putAll);
    }

    private Object applyIndexedOutputs(Object value, AtomicInteger index, Map<String, Integer> indexedOutput) {
        if (value instanceof String) {
            return this.applyIndexedOutputsOnStringValue((String)value, index, indexedOutput);
        }
        if (value instanceof Map) {
            return this.applyIndexedOutputs((Map)value, index, indexedOutput);
        }
        return value;
    }

    private Map<String, String> applyIndexedOutputs(Map<String, String> value, AtomicInteger index, Map<String, Integer> indexedOutput) {
        return value.entrySet().parallelStream().collect(Collectors.toMap(e -> this.applyIndexedOutputsOnStringValue((String)e.getKey(), index, indexedOutput), e -> this.applyIndexedOutputsOnStringValue((String)e.getValue(), index, indexedOutput)));
    }

    private String applyIndexedOutputsOnStringValue(String value, AtomicInteger index, Map<String, Integer> indexedOutput) {
        String tmp = value;
        for (String output : indexedOutput.keySet()) {
            Pattern pattern = Pattern.compile("#" + Pattern.quote(output) + "\\b");
            Matcher matcher = pattern.matcher(tmp);
            if (!matcher.find()) continue;
            tmp = matcher.replaceAll("#" + StringEscapeUtils.escapeJson((String)(output + "_" + index)));
        }
        return tmp;
    }
}

